/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;

public class ListGroupsResult {
    private final KafkaFutureImpl<Collection<GroupListing>> all = new KafkaFutureImpl();
    private final KafkaFutureImpl<Collection<GroupListing>> valid = new KafkaFutureImpl();
    private final KafkaFutureImpl<Collection<Throwable>> errors = new KafkaFutureImpl();

    ListGroupsResult(KafkaFuture<Collection<Object>> future) {
        future.thenApply(results -> {
            ArrayList<Throwable> curErrors = new ArrayList<Throwable>();
            ArrayList<GroupListing> curValid = new ArrayList<GroupListing>();
            for (Object resultObject : results) {
                if (resultObject instanceof Throwable) {
                    curErrors.add((Throwable)resultObject);
                    continue;
                }
                curValid.add((GroupListing)resultObject);
            }
            List validResult = Collections.unmodifiableList(curValid);
            List errorsResult = Collections.unmodifiableList(curErrors);
            if (!errorsResult.isEmpty()) {
                this.all.completeExceptionally((Throwable)errorsResult.get(0));
            } else {
                this.all.complete(validResult);
            }
            this.valid.complete(validResult);
            this.errors.complete(errorsResult);
            return null;
        });
    }

    public KafkaFuture<Collection<GroupListing>> all() {
        return this.all;
    }

    public KafkaFuture<Collection<GroupListing>> valid() {
        return this.valid;
    }

    public KafkaFuture<Collection<Throwable>> errors() {
        return this.errors;
    }
}

