/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.rollover.RolloverController;
import org.jdesktop.swingx.rollover.RolloverRenderer;

public class TreeRolloverController<T extends JTree>
extends RolloverController<T> {
    private Cursor oldCursor;

    @Override
    protected void rollover(Point oldLocation, Point newLocation) {
        Rectangle r2;
        if (oldLocation != null && (r2 = ((JTree)this.component).getRowBounds(oldLocation.y)) != null) {
            r2.x = 0;
            r2.width = ((JTree)this.component).getWidth();
            ((JTree)this.component).repaint(r2);
        }
        if (newLocation != null && (r2 = ((JTree)this.component).getRowBounds(newLocation.y)) != null) {
            r2.x = 0;
            r2.width = ((JTree)this.component).getWidth();
            ((JTree)this.component).repaint(r2);
        }
        this.setRolloverCursor(newLocation);
    }

    private void setRolloverCursor(Point location) {
        if (this.hasRollover(location)) {
            if (this.oldCursor == null) {
                this.oldCursor = ((JTree)this.component).getCursor();
                ((JTree)this.component).setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.oldCursor != null) {
            ((JTree)this.component).setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    protected RolloverRenderer getRolloverRenderer(Point location, boolean prepare) {
        RolloverRenderer rollover;
        TreeCellRenderer renderer = ((JTree)this.component).getCellRenderer();
        RolloverRenderer rolloverRenderer = rollover = renderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)renderer) : null;
        if (rollover != null && !rollover.isEnabled()) {
            rollover = null;
        }
        if (rollover != null && prepare) {
            TreePath path = ((JTree)this.component).getPathForRow(location.y);
            Object element = path != null ? path.getLastPathComponent() : null;
            renderer.getTreeCellRendererComponent((JTree)this.component, element, false, false, false, location.y, false);
        }
        return rollover;
    }

    @Override
    protected Point getFocusedCell() {
        return null;
    }
}

