/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.configuration;

import java.util.Optional;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PreferredAssumptionException {
    TEST_NG("org.testng.SkipException"),
    JUNIT4("org.junit.AssumptionViolatedException"),
    JUNIT5("org.opentest4j.TestAbortedException"),
    AUTO_DETECT(null){

        @Override
        public Class<?> getAssumptionExceptionClass() {
            return this.autoDetectAssumptionExceptionClass();
        }

        private Class<?> autoDetectAssumptionExceptionClass() {
            return (Class)Stream.of(TEST_NG, JUNIT4, JUNIT5).map(PreferredAssumptionException::loadAssumptionExceptionClass).flatMap(optional -> optional.map(Stream::of).orElse(Stream.empty())).findFirst().orElseThrow(() -> new IllegalStateException("Assumptions require TestNG, JUnit 4 or opentest4j on the classpath"));
        }

        @Override
        public String toString() {
            return "%s(%s)".formatted(this.name(), "try in order org.testng.SkipException, org.junit.AssumptionViolatedException and org.opentest4j.TestAbortedException");
        }
    };

    private final String assumptionExceptionClassName;

    private PreferredAssumptionException(String assumptionExceptionClassName) {
        this.assumptionExceptionClassName = assumptionExceptionClassName;
    }

    public Class<?> getAssumptionExceptionClass() {
        return this.loadAssumptionExceptionClass().orElseThrow(this::assumptionExceptionClassNotFound);
    }

    private Optional<Class<?>> loadAssumptionExceptionClass() {
        try {
            return Optional.of(Class.forName(this.assumptionExceptionClassName));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private IllegalStateException assumptionExceptionClassNotFound() {
        return new IllegalStateException("Failed to load %s class, make sure it is available in the classpath.".formatted(this.assumptionExceptionClassName));
    }

    public String toString() {
        return "%s(%s)".formatted(this.name(), this.assumptionExceptionClassName);
    }
}

