/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.GeeseUtil;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class ConvertToGeeseBracesIntention
extends GrPsiUpdateIntention {
    private static final Logger LOG = Logger.getInstance(ConvertToGeeseBracesIntention.class);
    private static final PsiElementPredicate MY_PREDICATE = new PsiElementPredicate(){

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                return false;
            }
            if (!((GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)element.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class)).USE_FLYING_GEESE_BRACES) {
                return false;
            }
            if (PsiImplUtil.isWhiteSpaceOrNls(element)) {
                element = PsiTreeUtil.prevLeaf((PsiElement)element);
            }
            if (!GeeseUtil.isClosureRBrace(element) || !GeeseUtil.isClosureContainLF(element)) {
                return false;
            }
            TextRange range = ConvertToGeeseBracesIntention.findRange(element);
            return StringUtil.contains((CharSequence)element.getContainingFile().getText(), (int)range.getStartOffset(), (int)range.getEndOffset(), (char)'\n');
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/style/ConvertToGeeseBracesIntention$1", "satisfiedBy"));
        }
    };

    @Nullable
    private static PsiElement getPrev(PsiElement element) {
        PsiElement prev = PsiUtil.getPreviousNonWhitespaceToken(element);
        if (prev != null && prev.getNode().getElementType() == GroovyTokenTypes.mNLS) {
            prev = PsiUtil.getPreviousNonWhitespaceToken(prev);
        }
        return prev;
    }

    @Nullable
    private static PsiElement getNext(PsiElement element) {
        PsiElement next = GeeseUtil.getNextNonWhitespaceToken(element);
        if (next != null && next.getNode().getElementType() == GroovyTokenTypes.mNLS) {
            next = GeeseUtil.getNextNonWhitespaceToken(next);
        }
        return next;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            ConvertToGeeseBracesIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ConvertToGeeseBracesIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ConvertToGeeseBracesIntention.$$$reportNull$$$0(2);
        }
        if (PsiImplUtil.isWhiteSpaceOrNls(element)) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        LOG.assertTrue(GeeseUtil.isClosureRBrace(element) && GeeseUtil.isClosureContainLF(element));
        PsiFile file = element.getContainingFile();
        Document document = file.getViewProvider().getDocument();
        TextRange textRange = ConvertToGeeseBracesIntention.findRange(element);
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        RangeMarker rangeMarker = document.createRangeMarker(textRange);
        String text = document.getText();
        for (int i2 = endOffset - 1; i2 >= startOffset; --i2) {
            if (text.charAt(i2) != '\n') continue;
            document.deleteString(i2, i2 + 1);
        }
        CodeStyleManager.getInstance((Project)context.project()).reformatText(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
    }

    private static TextRange findRange(PsiElement element) {
        PsiElement first = null;
        PsiElement last = null;
        PsiElement cur = element;
        while (GeeseUtil.isClosureRBrace(cur) && GeeseUtil.isClosureContainLF(cur)) {
            last = cur;
            cur = ConvertToGeeseBracesIntention.getNext(cur);
        }
        cur = element;
        while (GeeseUtil.isClosureRBrace(cur) && GeeseUtil.isClosureContainLF(cur)) {
            first = cur;
            cur = ConvertToGeeseBracesIntention.getPrev(cur);
        }
        LOG.assertTrue(first != null);
        LOG.assertTrue(last != null);
        return new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = MY_PREDICATE;
        if (psiElementPredicate == null) {
            ConvertToGeeseBracesIntention.$$$reportNull$$$0(3);
        }
        return psiElementPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/style/ConvertToGeeseBracesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/style/ConvertToGeeseBracesIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

