\name{MinMaxCurvatureFlowImageFilter}
\alias{MinMaxCurvatureFlowImageFilter}
\title{MinMaxCurvatureFlowImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Denoise an image using min/max curvature flow.
MinMaxCurvatureFlowImageFilter}
\details{
MinMaxCurvatureFlowImageFilter implements a curvature driven image denoising algorithm. Iso-
brightness contours in the grayscale input image are viewed as a level
set. The level set is then evolved using a curvature-based speed
function:
 \deqn{ I_t = F_{minmax} |\nabla I| }
where \eqn{ F_{minmax} = \max(\kappa,0) } if \eqn{ Avg_{stencil}(x) } is less than or equal to \eqn{ T_{threshold} } and \eqn{ \min(\kappa,0) } , otherwise. \eqn{ \kappa } is the mean curvature of the iso-brightness contour at point \eqn{ x } .
In min/max curvature flow, movement is turned on or off depending on
the scale of the noise one wants to remove. Switching depends on the
average image value of a region of radius \eqn{ R } around each point. The choice of \eqn{ R } , the stencil radius, governs the scale of the noise to be removed.
The threshold value \eqn{ T_{threshold} } is the average intensity obtained in the direction perpendicular to
the gradient at point \eqn{ x } at the extrema of the local neighborhood.
This filter make use of the multi-threaded finite difference solver
hierarchy. Updates are computed using a MinMaxCurvatureFlowFunction object. A zero flux Neumann boundary condition is used when computing
derivatives near the data boundary.
WARNING:
This filter assumes that the input and output types have the same
dimensions. This filter also requires that the output image pixels are
of a real type. This filter works for any dimensional images, however
for dimensions greater than 3D, an expensive brute-force search is
used to compute the local threshold.
 Reference: "Level Set Methods and Fast Marching Methods", J.A.
Sethian, Cambridge Press, Chapter 16, Second edition, 1999.
See:
MinMaxCurvatureFlowFunction
CurvatureFlowImageFilter
BinaryMinMaxCurvatureFlowImageFilter
MinMaxCurvatureFlow for the procedural interface
itk::MinMaxCurvatureFlowImageFilter for the Doxygen on the original ITK class.
MinMaxCurvatureFlowImageFilter}
%C++ includes: sitkMinMaxCurvatureFlowImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{int GetStencilRadius() const:}{
Set/Get the stencil radius.
}
\item{double GetTimeStep() const:}{}
\item{ MinMaxCurvatureFlowImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetStencilRadius(int StencilRadius):}{
Set/Get the stencil radius.
}
\item{Self SetTimeStep(double TimeStep):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MinMaxCurvatureFlowImageFilter():}{
Destructor
}
}
}
