/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstElementKt;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstStatementPart;
import com.jetbrains.python.psi.PyElementType;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstForPart
extends PyAstStatementPart {
    private static boolean followsNodeOfType(ASTNode node, PyElementType eltType) {
        if (node != null) {
            PsiElement checker = node.getPsi();
            for (checker = checker.getPrevSibling(); checker != null; checker = checker.getPrevSibling()) {
                ASTNode ch_node = checker.getNode();
                if (ch_node == null) {
                    return false;
                }
                if (ch_node.getElementType() == eltType) {
                    return true;
                }
                if (checker instanceof PsiWhiteSpace) continue;
                return false;
            }
        }
        return false;
    }

    @Nullable
    default public PyAstExpression getTarget() {
        ASTNode n = this.getNode().findChildByType(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens());
        if (PyAstForPart.followsNodeOfType(n, PyTokenTypes.FOR_KEYWORD)) {
            return (PyAstExpression)n.getPsi();
        }
        return null;
    }

    @Nullable
    default public PyAstExpression getSource() {
        List exprs = PyAstElementKt.findChildrenByType((PsiElement)this, PythonDialectsTokenSetProvider.getInstance().getExpressionTokens());
        if (exprs.size() != 2) {
            return null;
        }
        PyAstExpression ret = (PyAstExpression)exprs.get(1);
        if (PyAstForPart.followsNodeOfType(ret.getNode(), PyTokenTypes.IN_KEYWORD)) {
            return ret;
        }
        return null;
    }
}

