
#ifndef PLASMA5SUPPORT_EXPORT_H
#define PLASMA5SUPPORT_EXPORT_H

#ifdef PLASMA5SUPPORT_STATIC_DEFINE
#  define PLASMA5SUPPORT_EXPORT
#  define PLASMA5SUPPORT_NO_EXPORT
#else
#  ifndef PLASMA5SUPPORT_EXPORT
#    ifdef Plasma5Support_EXPORTS
        /* We are building this library */
#      define PLASMA5SUPPORT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define PLASMA5SUPPORT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef PLASMA5SUPPORT_NO_EXPORT
#    define PLASMA5SUPPORT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef PLASMA5SUPPORT_DECL_DEPRECATED
#  define PLASMA5SUPPORT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef PLASMA5SUPPORT_DECL_DEPRECATED_EXPORT
#  define PLASMA5SUPPORT_DECL_DEPRECATED_EXPORT PLASMA5SUPPORT_EXPORT PLASMA5SUPPORT_DECL_DEPRECATED
#endif

#ifndef PLASMA5SUPPORT_DECL_DEPRECATED_NO_EXPORT
#  define PLASMA5SUPPORT_DECL_DEPRECATED_NO_EXPORT PLASMA5SUPPORT_NO_EXPORT PLASMA5SUPPORT_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef PLASMA5SUPPORT_NO_DEPRECATED
#    define PLASMA5SUPPORT_NO_DEPRECATED
#  endif
#endif

#define PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(PLASMA5SUPPORT_NO_DEPRECATED) && !defined(PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define PLASMA5SUPPORT_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(PLASMA5SUPPORT_NO_DEPRECATED_WARNINGS) && !defined(PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define PLASMA5SUPPORT_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(PLASMA5SUPPORT_NO_DEPRECATED)
#  undef PLASMA5SUPPORT_DEPRECATED
#  define PLASMA5SUPPORT_DEPRECATED_EXPORT PLASMA5SUPPORT_EXPORT
#  define PLASMA5SUPPORT_DEPRECATED_NO_EXPORT PLASMA5SUPPORT_NO_EXPORT
#elif defined(PLASMA5SUPPORT_NO_DEPRECATED_WARNINGS)
#  define PLASMA5SUPPORT_DEPRECATED
#  define PLASMA5SUPPORT_DEPRECATED_EXPORT PLASMA5SUPPORT_EXPORT
#  define PLASMA5SUPPORT_DEPRECATED_NO_EXPORT PLASMA5SUPPORT_NO_EXPORT
#else
#  define PLASMA5SUPPORT_DEPRECATED PLASMA5SUPPORT_DECL_DEPRECATED
#  define PLASMA5SUPPORT_DEPRECATED_EXPORT PLASMA5SUPPORT_DECL_DEPRECATED_EXPORT
#  define PLASMA5SUPPORT_DEPRECATED_NO_EXPORT PLASMA5SUPPORT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define PLASMA5SUPPORT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define PLASMA5SUPPORT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef PLASMA5SUPPORT_NO_DEPRECATED
#  define PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60501
#endif
#ifdef PLASMA5SUPPORT_NO_DEPRECATED_WARNINGS
#  define PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE
#  ifdef PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE 0x60501
#  endif
#endif

#ifndef PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef PLASMA5SUPPORT_DEPRECATED
#  define PLASMA5SUPPORT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > PLASMA5SUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define PLASMA5SUPPORT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x50600
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_6(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_6(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x51300
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_19(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_19(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x51c00
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_28(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_28(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x51e00
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_30(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_30(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x52400
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_36(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_36(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x52e00
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_46(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_46(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x54300
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_67(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_67(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x54d00
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_77(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_77(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x54e00
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_78(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_78(text)
#endif

#if PLASMA5SUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_81(text) PLASMA5SUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA5SUPPORT_DEPRECATED_VERSION_5_81(text)
#endif
#define PLASMA5SUPPORT_DEPRECATED_VERSION_5(minor, text)      PLASMA5SUPPORT_DEPRECATED_VERSION_5_##minor(text)
#define PLASMA5SUPPORT_DEPRECATED_VERSION(major, minor, text) PLASMA5SUPPORT_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define PLASMA5SUPPORT_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) PLASMA5SUPPORT_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define PLASMA5SUPPORT_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) PLASMA5SUPPORT_DEPRECATED_VERSION(major, minor, text)
#  define PLASMA5SUPPORT_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) PLASMA5SUPPORT_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define PLASMA5SUPPORT_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define PLASMA5SUPPORT_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* PLASMA5SUPPORT_EXPORT_H */
