/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DelegatedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DynamoDBSigner;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionFlags;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.AttributeValueMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.Utils;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.ILegacyDynamoDbEncryptor;

public class DynamoDBEncryptor
implements ILegacyDynamoDbEncryptor {
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String DEFAULT_METADATA_FIELD = "*amzn-ddb-map-desc*";
    private static final String DEFAULT_SIGNATURE_FIELD = "*amzn-ddb-map-sig*";
    private static final String DEFAULT_DESCRIPTION_BASE = "amzn-ddb-map-";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String SYMMETRIC_ENCRYPTION_MODE = "/CBC/PKCS5Padding";
    private static final ConcurrentHashMap<String, Integer> BLOCK_SIZE_CACHE = new ConcurrentHashMap();
    private static final Function<String, Integer> BLOCK_SIZE_CALCULATOR = transformation -> {
        try {
            Cipher c = Cipher.getInstance(transformation);
            return c.getBlockSize();
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException("Algorithm does not exist", ex);
        }
    };
    private static final int CURRENT_VERSION = 0;
    private String signatureFieldName = "*amzn-ddb-map-sig*";
    private String materialDescriptionFieldName = "*amzn-ddb-map-desc*";
    private EncryptionMaterialsProvider encryptionMaterialsProvider;
    private final String descriptionBase;
    private final String symmetricEncryptionModeHeader;
    private final String signingAlgorithmHeader;
    public static final String DEFAULT_SIGNING_ALGORITHM_HEADER = "amzn-ddb-map-signingAlg";
    private Function<EncryptionContext, EncryptionContext> encryptionContextOverrideOperator;

    protected DynamoDBEncryptor(EncryptionMaterialsProvider provider, String descriptionBase) {
        this.encryptionMaterialsProvider = provider;
        this.descriptionBase = descriptionBase;
        this.symmetricEncryptionModeHeader = this.descriptionBase + "sym-mode";
        this.signingAlgorithmHeader = this.descriptionBase + "signingAlg";
    }

    public static DynamoDBEncryptor getInstance(EncryptionMaterialsProvider provider, String descriptionbase) {
        return new DynamoDBEncryptor(provider, descriptionbase);
    }

    public static DynamoDBEncryptor getInstance(EncryptionMaterialsProvider provider) {
        return DynamoDBEncryptor.getInstance(provider, DEFAULT_DESCRIPTION_BASE);
    }

    public Map<String, AttributeValue> decryptAllFieldsExcept(Map<String, AttributeValue> itemAttributes, EncryptionContext context, String ... doNotDecrypt) throws GeneralSecurityException {
        return this.decryptAllFieldsExcept(itemAttributes, context, Arrays.asList(doNotDecrypt));
    }

    public Map<String, AttributeValue> decryptAllFieldsExcept(Map<String, AttributeValue> itemAttributes, EncryptionContext context, Collection<String> doNotDecrypt) throws GeneralSecurityException {
        Map<String, Set<EncryptionFlags>> attributeActionsOnEncrypt = this.allDecryptionFlagsExcept(itemAttributes, doNotDecrypt);
        return this.decryptRecord(itemAttributes, attributeActionsOnEncrypt, context);
    }

    public Map<String, Set<EncryptionFlags>> allDecryptionFlagsExcept(Map<String, AttributeValue> itemAttributes, String ... doNotDecrypt) {
        return this.allDecryptionFlagsExcept(itemAttributes, Arrays.asList(doNotDecrypt));
    }

    public Map<String, Set<EncryptionFlags>> allDecryptionFlagsExcept(Map<String, AttributeValue> itemAttributes, Collection<String> doNotDecrypt) {
        HashMap<String, Set<EncryptionFlags>> attributeActionsOnEncrypt = new HashMap<String, Set<EncryptionFlags>>();
        for (String fieldName : doNotDecrypt) {
            attributeActionsOnEncrypt.put(fieldName, EnumSet.of(EncryptionFlags.SIGN));
        }
        for (String fieldName : itemAttributes.keySet()) {
            if (attributeActionsOnEncrypt.containsKey(fieldName) || fieldName.equals(this.getMaterialDescriptionFieldName()) || fieldName.equals(this.getSignatureFieldName())) continue;
            attributeActionsOnEncrypt.put(fieldName, EnumSet.of(EncryptionFlags.ENCRYPT, EncryptionFlags.SIGN));
        }
        return attributeActionsOnEncrypt;
    }

    public Map<String, AttributeValue> encryptAllFieldsExcept(Map<String, AttributeValue> itemAttributes, EncryptionContext context, String ... doNotEncrypt) throws GeneralSecurityException {
        return this.encryptAllFieldsExcept(itemAttributes, context, Arrays.asList(doNotEncrypt));
    }

    public Map<String, AttributeValue> encryptAllFieldsExcept(Map<String, AttributeValue> itemAttributes, EncryptionContext context, Collection<String> doNotEncrypt) throws GeneralSecurityException {
        Map<String, Set<EncryptionFlags>> attributeActionsOnEncrypt = this.allEncryptionFlagsExcept(itemAttributes, doNotEncrypt);
        return this.encryptRecord(itemAttributes, attributeActionsOnEncrypt, context);
    }

    public Map<String, Set<EncryptionFlags>> allEncryptionFlagsExcept(Map<String, AttributeValue> itemAttributes, String ... doNotEncrypt) {
        return this.allEncryptionFlagsExcept(itemAttributes, Arrays.asList(doNotEncrypt));
    }

    public Map<String, Set<EncryptionFlags>> allEncryptionFlagsExcept(Map<String, AttributeValue> itemAttributes, Collection<String> doNotEncrypt) {
        HashMap<String, Set<EncryptionFlags>> attributeActionsOnEncrypt = new HashMap<String, Set<EncryptionFlags>>();
        for (String fieldName : doNotEncrypt) {
            attributeActionsOnEncrypt.put(fieldName, EnumSet.of(EncryptionFlags.SIGN));
        }
        for (String fieldName : itemAttributes.keySet()) {
            if (attributeActionsOnEncrypt.containsKey(fieldName)) continue;
            attributeActionsOnEncrypt.put(fieldName, EnumSet.of(EncryptionFlags.ENCRYPT, EncryptionFlags.SIGN));
        }
        return attributeActionsOnEncrypt;
    }

    public Map<String, AttributeValue> decryptRecord(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeActionsOnEncrypt, EncryptionContext context) throws GeneralSecurityException {
        if (!this.itemContainsFieldsToDecryptOrSign(itemAttributes.keySet(), attributeActionsOnEncrypt)) {
            return itemAttributes;
        }
        itemAttributes = new HashMap<String, AttributeValue>(itemAttributes);
        Map<String, String> materialDescription = Collections.emptyMap();
        DynamoDBSigner signer = DynamoDBSigner.getInstance(DEFAULT_SIGNATURE_ALGORITHM, Utils.getRng());
        if (itemAttributes.containsKey(this.materialDescriptionFieldName)) {
            materialDescription = DynamoDBEncryptor.unmarshallDescription(itemAttributes.get(this.materialDescriptionFieldName));
        }
        context = new EncryptionContext.Builder(context).withMaterialDescription(materialDescription).withAttributeValues(itemAttributes).build();
        Function<EncryptionContext, EncryptionContext> encryptionContextOverrideOperator = this.getEncryptionContextOverrideOperator();
        if (encryptionContextOverrideOperator != null) {
            context = encryptionContextOverrideOperator.apply(context);
        }
        DecryptionMaterials materials = this.encryptionMaterialsProvider.getDecryptionMaterials(context);
        SecretKey decryptionKey = materials.getDecryptionKey();
        if (materialDescription.containsKey(this.signingAlgorithmHeader)) {
            String signingAlg = materialDescription.get(this.signingAlgorithmHeader);
            signer = DynamoDBSigner.getInstance(signingAlg, Utils.getRng());
        }
        ByteBuffer signature = !itemAttributes.containsKey(this.signatureFieldName) || itemAttributes.get(this.signatureFieldName).getB() == null ? ByteBuffer.allocate(0) : itemAttributes.get(this.signatureFieldName).getB().asReadOnlyBuffer();
        itemAttributes.remove(this.signatureFieldName);
        String associatedData = "TABLE>" + context.getTableName() + "<TABLE";
        signer.verifySignature(itemAttributes, attributeActionsOnEncrypt, associatedData.getBytes(UTF8), materials.getVerificationKey(), signature);
        itemAttributes.remove(this.materialDescriptionFieldName);
        this.actualDecryption(itemAttributes, attributeActionsOnEncrypt, decryptionKey, materialDescription);
        return itemAttributes;
    }

    private boolean itemContainsFieldsToDecryptOrSign(Set<String> attributeNamesToCheck, Map<String, Set<EncryptionFlags>> attributeActionsOnEncrypt) {
        return attributeNamesToCheck.stream().filter(attributeActionsOnEncrypt::containsKey).anyMatch(attributeName -> !((Set)attributeActionsOnEncrypt.get(attributeName)).isEmpty());
    }

    public Map<String, AttributeValue> encryptRecord(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeActionsOnEncrypt, EncryptionContext context) throws GeneralSecurityException {
        if (attributeActionsOnEncrypt.isEmpty()) {
            return itemAttributes;
        }
        itemAttributes = new HashMap<String, AttributeValue>(itemAttributes);
        context = new EncryptionContext.Builder(context).withAttributeValues(itemAttributes).build();
        Function<EncryptionContext, EncryptionContext> encryptionContextOverrideOperator = this.getEncryptionContextOverrideOperator();
        if (encryptionContextOverrideOperator != null) {
            context = encryptionContextOverrideOperator.apply(context);
        }
        EncryptionMaterials materials = this.encryptionMaterialsProvider.getEncryptionMaterials(context);
        HashMap<String, String> materialDescription = new HashMap<String, String>(materials.getMaterialDescription());
        SecretKey encryptionKey = materials.getEncryptionKey();
        this.actualEncryption(itemAttributes, attributeActionsOnEncrypt, materialDescription, encryptionKey);
        String signingAlgo = (String)materialDescription.get(this.signingAlgorithmHeader);
        DynamoDBSigner signer = signingAlgo != null ? DynamoDBSigner.getInstance(signingAlgo, Utils.getRng()) : DynamoDBSigner.getInstance(DEFAULT_SIGNATURE_ALGORITHM, Utils.getRng());
        if (materials.getSigningKey() instanceof PrivateKey) {
            materialDescription.put(this.signingAlgorithmHeader, signer.getSigningAlgorithm());
        }
        if (!materialDescription.isEmpty()) {
            itemAttributes.put(this.materialDescriptionFieldName, DynamoDBEncryptor.marshallDescription(materialDescription));
        }
        String associatedData = "TABLE>" + context.getTableName() + "<TABLE";
        byte[] signature = signer.calculateSignature(itemAttributes, attributeActionsOnEncrypt, associatedData.getBytes(UTF8), materials.getSigningKey());
        AttributeValue signatureAttribute = new AttributeValue();
        signatureAttribute.setB(ByteBuffer.wrap(signature));
        itemAttributes.put(this.signatureFieldName, signatureAttribute);
        return itemAttributes;
    }

    private void actualDecryption(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeActionsOnEncrypt, SecretKey encryptionKey, Map<String, String> materialDescription) throws GeneralSecurityException {
        String encryptionMode = encryptionKey != null ? encryptionKey.getAlgorithm() + materialDescription.get(this.symmetricEncryptionModeHeader) : null;
        Cipher cipher = null;
        int blockSize = -1;
        for (Map.Entry<String, AttributeValue> entry : itemAttributes.entrySet()) {
            ByteBuffer plainText;
            Set<EncryptionFlags> flags = attributeActionsOnEncrypt.get(entry.getKey());
            if (flags == null || !flags.contains((Object)EncryptionFlags.ENCRYPT)) continue;
            if (!flags.contains((Object)EncryptionFlags.SIGN)) {
                throw new IllegalArgumentException("All encrypted fields must be signed. Bad field: " + entry.getKey());
            }
            ByteBuffer cipherText = entry.getValue().getB().asReadOnlyBuffer();
            cipherText.rewind();
            if (encryptionKey instanceof DelegatedKey) {
                plainText = ByteBuffer.wrap(((DelegatedKey)encryptionKey).decrypt(DynamoDBEncryptor.toByteArray(cipherText), null, encryptionMode));
            } else {
                if (cipher == null) {
                    blockSize = DynamoDBEncryptor.getBlockSize(encryptionMode);
                    cipher = Cipher.getInstance(encryptionMode);
                }
                byte[] iv = new byte[blockSize];
                cipherText.get(iv);
                cipher.init(2, (Key)encryptionKey, new IvParameterSpec(iv), Utils.getRng());
                plainText = ByteBuffer.allocate(cipher.getOutputSize(cipherText.remaining()));
                cipher.doFinal(cipherText, plainText);
                plainText.rewind();
            }
            entry.setValue(AttributeValueMarshaller.unmarshall(plainText));
        }
    }

    protected static int getBlockSize(String encryptionMode) {
        return BLOCK_SIZE_CACHE.computeIfAbsent(encryptionMode, BLOCK_SIZE_CALCULATOR);
    }

    private void actualEncryption(Map<String, AttributeValue> itemAttributes, Map<String, Set<EncryptionFlags>> attributeActionsOnEncrypt, Map<String, String> materialDescription, SecretKey encryptionKey) throws GeneralSecurityException {
        String encryptionMode = null;
        if (encryptionKey != null) {
            materialDescription.put(this.symmetricEncryptionModeHeader, SYMMETRIC_ENCRYPTION_MODE);
            encryptionMode = encryptionKey.getAlgorithm() + SYMMETRIC_ENCRYPTION_MODE;
        }
        Cipher cipher = null;
        int blockSize = -1;
        for (Map.Entry<String, AttributeValue> entry : itemAttributes.entrySet()) {
            ByteBuffer cipherText;
            Set<EncryptionFlags> flags = attributeActionsOnEncrypt.get(entry.getKey());
            if (flags == null || !flags.contains((Object)EncryptionFlags.ENCRYPT)) continue;
            if (!flags.contains((Object)EncryptionFlags.SIGN)) {
                throw new IllegalArgumentException("All encrypted fields must be signed. Bad field: " + entry.getKey());
            }
            ByteBuffer plainText = AttributeValueMarshaller.marshall(entry.getValue());
            plainText.rewind();
            if (encryptionKey instanceof DelegatedKey) {
                DelegatedKey dk = (DelegatedKey)encryptionKey;
                cipherText = ByteBuffer.wrap(dk.encrypt(DynamoDBEncryptor.toByteArray(plainText), null, encryptionMode));
            } else {
                if (cipher == null) {
                    blockSize = DynamoDBEncryptor.getBlockSize(encryptionMode);
                    cipher = Cipher.getInstance(encryptionMode);
                }
                cipher.init(1, (Key)encryptionKey, Utils.getRng());
                cipherText = ByteBuffer.allocate(blockSize + cipher.getOutputSize(plainText.remaining()));
                cipherText.position(blockSize);
                cipher.doFinal(plainText, cipherText);
                cipherText.flip();
                byte[] iv = cipher.getIV();
                if (iv.length != blockSize) {
                    throw new IllegalStateException(String.format("Generated IV length (%d) not equal to block size (%d)", iv.length, blockSize));
                }
                cipherText.put(iv);
                cipherText.rewind();
            }
            entry.setValue(new AttributeValue().withB(cipherText));
        }
    }

    public String getSignatureFieldName() {
        return this.signatureFieldName;
    }

    public void setSignatureFieldName(String signatureFieldName) {
        this.signatureFieldName = signatureFieldName;
    }

    public String getMaterialDescriptionFieldName() {
        return this.materialDescriptionFieldName;
    }

    public void setMaterialDescriptionFieldName(String materialDescriptionFieldName) {
        this.materialDescriptionFieldName = materialDescriptionFieldName;
    }

    protected static AttributeValue marshallDescription(Map<String, String> description) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bos);
            out.writeInt(0);
            for (Map.Entry<String, String> entry : description.entrySet()) {
                byte[] bytes = entry.getKey().getBytes(UTF8);
                out.writeInt(bytes.length);
                out.write(bytes);
                bytes = entry.getValue().getBytes(UTF8);
                out.writeInt(bytes.length);
                out.write(bytes);
            }
            out.close();
            AttributeValue result = new AttributeValue();
            result.setB(ByteBuffer.wrap(bos.toByteArray()));
            return result;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
    }

    public String getSigningAlgorithmHeader() {
        return this.signingAlgorithmHeader;
    }

    /*
     * Exception decompiling
     */
    protected static Map<String, String> unmarshallDescription(AttributeValue attributeValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void setEncryptionContextOverrideOperator(Function<EncryptionContext, EncryptionContext> encryptionContextOverrideOperator) {
        this.encryptionContextOverrideOperator = encryptionContextOverrideOperator;
    }

    public final Function<EncryptionContext, EncryptionContext> getEncryptionContextOverrideOperator() {
        return this.encryptionContextOverrideOperator;
    }

    private static byte[] toByteArray(ByteBuffer buffer) {
        byte[] result;
        if ((buffer = buffer.duplicate()).hasArray() && buffer.arrayOffset() == 0) {
            result = buffer.array();
            if (buffer.remaining() == result.length) {
                return result;
            }
        }
        result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }
}

