/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.datum;

import java.time.ZonedDateTime;
import java.util.Date;
import mediathek.tool.datum.DateUtil;

public class DatumFilm
extends Date {
    public static final DatumFilm UNDEFINED_FILM_DATE = new DatumFilm(0, 0, 1);
    private ZonedDateTime zonedDateTime;

    public DatumFilm(long date) {
        super(date);
        this.convertToZonedDateTime();
    }

    public DatumFilm(int year, int month, int date) {
        super(year, month, date);
        this.convertToZonedDateTime();
    }

    @Override
    public String toString() {
        if (this.equals(UNDEFINED_FILM_DATE)) {
            return "";
        }
        return DateUtil.FORMATTER.format(DateUtil.convertToLocalDate(this));
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    private void convertToZonedDateTime() {
        this.zonedDateTime = this.toInstant().atZone(DateUtil.MV_DEFAULT_TIMEZONE);
    }
}

