/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.duplicates;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mediathek.config.Daten;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.gui.duplicates.BigSenderPenaltyComparator;
import mediathek.gui.duplicates.FilmStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilmDuplicateEvaluationTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger();
    private final ListeFilme listeFilme = Daten.getInstance().getListeFilme();

    private void printDuplicateStatistics() {
        Stopwatch watch = Stopwatch.createStarted();
        List<DatenFilm> duplicates = this.listeFilme.parallelStream().filter(DatenFilm::isDuplicate).toList();
        EventList<FilmStatistics> statisticsEventList = Daten.getInstance().getDuplicateStatistics();
        Map<String, Long> statisticsMap = duplicates.parallelStream().collect(Collectors.groupingBy(DatenFilm::getSender, Collectors.counting()));
        TransactionList tList = new TransactionList(statisticsEventList);
        tList.getReadWriteLock().writeLock().lock();
        tList.beginEvent(true);
        tList.clear();
        for (String sender : statisticsMap.keySet()) {
            tList.add((Object)new FilmStatistics(sender, statisticsMap.get(sender)));
        }
        tList.commitEvent();
        tList.getReadWriteLock().writeLock().unlock();
        watch.stop();
        logger.trace("Duplicate stream filter took: {}", (Object)watch);
        logger.trace("Number of duplicates: {}", (Object)duplicates.size());
    }

    private void checkDuplicates() {
        logger.trace("Start Duplicate URL search");
        Set urlCache = Sets.newConcurrentHashSet();
        HashFunction hf = Hashing.murmur3_128();
        Stopwatch watch = Stopwatch.createStarted();
        this.listeFilme.stream().filter(f -> !f.isLivestream()).sorted(new BigSenderPenaltyComparator()).forEach(film -> {
            Hasher hasher = hf.newHasher().putString((CharSequence)film.getUrlNormalQuality(), StandardCharsets.UTF_8);
            if (film.isHighQuality()) {
                hasher = hasher.putString((CharSequence)film.getHighQualityUrl(), StandardCharsets.UTF_8);
            }
            if (film.hasLowQuality()) {
                hasher = hasher.putString((CharSequence)film.getLowQualityUrl(), StandardCharsets.UTF_8);
            }
            HashCode hc = hasher.hash();
            long hash = hc.padToLong();
            film.setDuplicate(urlCache.contains(hash));
            urlCache.add(hash);
        });
        watch.stop();
        logger.trace("Duplicate URL search took: {}", (Object)watch);
        urlCache.clear();
    }

    @Override
    public void run() {
        this.checkDuplicates();
        this.printDuplicateStatistics();
    }
}

