/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.credential.RecoveryAuthnCodesCredentialModel;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.util.JsonSerialization;

public class CredentialHelper {
    private static final Logger logger = Logger.getLogger(CredentialHelper.class);

    public static void setOrReplaceAuthenticationRequirement(KeycloakSession session, RealmModel realm, String type, AuthenticationExecutionModel.Requirement requirement, AuthenticationExecutionModel.Requirement currentRequirement) {
        realm.getAuthenticationFlowsStream().forEach(flow -> realm.getAuthenticationExecutionsStream(flow.getId()).filter(exe -> {
            ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory(session, exe.getAuthenticator());
            return Objects.nonNull(factory) && Objects.equals(type, factory.getReferenceCategory());
        }).filter(exe -> {
            if (Objects.isNull(currentRequirement) || Objects.equals(exe.getRequirement(), currentRequirement)) {
                return true;
            }
            logger.debugf("Skip switch authenticator execution '%s' to '%s' as it's in state %s", (Object)exe.getAuthenticator(), (Object)requirement.toString(), (Object)exe.getRequirement());
            return false;
        }).forEachOrdered(exe -> {
            exe.setRequirement(requirement);
            realm.updateAuthenticatorExecution(exe);
            logger.debugf("Authenticator execution '%s' switched to '%s'", (Object)exe.getAuthenticator(), (Object)requirement.toString());
        }));
    }

    public static ConfigurableAuthenticatorFactory getConfigurableAuthenticatorFactory(KeycloakSession session, String providerId) {
        ConfigurableAuthenticatorFactory factory = (AuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, providerId);
        if (factory == null) {
            factory = (FormActionFactory)session.getKeycloakSessionFactory().getProviderFactory(FormAction.class, providerId);
        }
        if (factory == null) {
            factory = (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, providerId);
        }
        return factory;
    }

    public static boolean createOTPCredential(KeycloakSession session, RealmModel realm, UserModel user, String totpCode, OTPCredentialModel credentialModel) {
        CredentialProvider otpCredentialProvider = (CredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
        String totpSecret = credentialModel.getOTPSecretData().getValue();
        UserCredentialModel otpUserCredential = new UserCredentialModel("", realm.getOTPPolicy().getType(), totpSecret);
        boolean userStorageCreated = user.credentialManager().updateCredential((CredentialInput)otpUserCredential);
        String credentialId = null;
        if (userStorageCreated) {
            logger.debugf("Created OTP credential for user '%s' in the user storage", (Object)user.getUsername());
        } else {
            CredentialModel createdCredential = otpCredentialProvider.createCredential(realm, user, (CredentialModel)credentialModel);
            credentialId = createdCredential.getId();
        }
        UserCredentialModel credential = new UserCredentialModel(credentialId, otpCredentialProvider.getType(), totpCode);
        return user.credentialManager().isValid(new CredentialInput[]{credential});
    }

    public static void createRecoveryCodesCredential(KeycloakSession session, RealmModel realm, UserModel user, RecoveryAuthnCodesCredentialModel credentialModel, List<String> generatedCodes) {
        String recoveryCodesJson;
        CredentialProvider recoveryCodeCredentialProvider = (CredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-recovery-authn-codes");
        try {
            recoveryCodesJson = JsonSerialization.writeValueAsString(generatedCodes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        UserCredentialModel recoveryCodesCredential = new UserCredentialModel("", credentialModel.getType(), recoveryCodesJson);
        boolean userStorageCreated = user.credentialManager().updateCredential((CredentialInput)recoveryCodesCredential);
        if (userStorageCreated) {
            logger.debugf("Created RecoveryCodes credential for user '%s' in the user storage", (Object)user.getUsername());
        } else {
            recoveryCodeCredentialProvider.createCredential(realm, user, (CredentialModel)credentialModel);
        }
    }

    public static CredentialRepresentation createUserStorageCredentialRepresentation(String credentialProviderType) {
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setId(credentialProviderType + "-id");
        credential.setType(credentialProviderType);
        credential.setCreatedDate(Long.valueOf(-1L));
        credential.setPriority(Integer.valueOf(0));
        return credential;
    }
}

