/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.usertype;

import java.util.function.BiConsumer;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.BaseUserTypeSupport;

public class UserTypeSupport<T>
extends BaseUserTypeSupport<T>
implements TypeConfigurationAware {
    private final Class<T> returnedClass;
    private final int jdbcTypeCode;
    private TypeConfiguration typeConfiguration;

    public UserTypeSupport(Class<T> returnedClass, int jdbcTypeCode) {
        this.returnedClass = returnedClass;
        this.jdbcTypeCode = jdbcTypeCode;
    }

    @Override
    protected void resolve(BiConsumer<BasicJavaType<T>, JdbcType> resolutionConsumer) {
        assert (this.typeConfiguration != null);
        JavaType descriptor = this.typeConfiguration.getJavaTypeRegistry().getDescriptor(this.returnedClass);
        resolutionConsumer.accept((BasicJavaType)descriptor, this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(this.jdbcTypeCode));
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void setTypeConfiguration(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }
}

