/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.ide.DataManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import java.awt.Component;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.branch.HgBranchPopup;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

final class HgStatusWidget
extends DvcsStatusWidget<HgRepository> {
    @NonNls
    private static final String ID = "hg";
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings myProjectSettings;

    HgStatusWidget(@NotNull HgVcs vcs, @NotNull Project project, @NotNull HgProjectSettings projectSettings) {
        if (vcs == null) {
            HgStatusWidget.$$$reportNull$$$0(0);
        }
        if (project == null) {
            HgStatusWidget.$$$reportNull$$$0(1);
        }
        if (projectSettings == null) {
            HgStatusWidget.$$$reportNull$$$0(2);
        }
        super(project, vcs.getShortName());
        this.myVcs = vcs;
        this.myProjectSettings = projectSettings;
        this.myConnection.subscribe(HgVcs.STATUS_TOPIC, (p, root) -> this.updateLater());
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    public StatusBarWidget copy() {
        return new HgStatusWidget(this.myVcs, this.getProject(), this.myProjectSettings);
    }

    @Nullable
    protected HgRepository guessCurrentRepository(@NotNull Project project, @Nullable VirtualFile selectedFile) {
        if (project == null) {
            HgStatusWidget.$$$reportNull$$$0(3);
        }
        return HgUtil.guessWidgetRepository(project, selectedFile);
    }

    @NotNull
    protected String getFullBranchName(@NotNull HgRepository repository) {
        if (repository == null) {
            HgStatusWidget.$$$reportNull$$$0(4);
        }
        String string = HgUtil.getDisplayableBranchOrBookmarkText(repository);
        if (string == null) {
            HgStatusWidget.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        if (project == null) {
            HgStatusWidget.$$$reportNull$$$0(6);
        }
        return HgUtil.getRepositoryManager(project).moreThanOneRoot();
    }

    protected JBPopup getWidgetPopup(@NotNull Project project, @NotNull HgRepository repository) {
        StatusBar statusBar;
        if (project == null) {
            HgStatusWidget.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            HgStatusWidget.$$$reportNull$$$0(8);
        }
        return (statusBar = this.myStatusBar) == null ? null : HgBranchPopup.getInstance(project, repository, DataManager.getInstance().getDataContext((Component)statusBar.getComponent())).asListPopup();
    }

    protected void rememberRecentRoot(@NotNull String path) {
        if (path == null) {
            HgStatusWidget.$$$reportNull$$$0(9);
        }
        this.myProjectSettings.setRecentRootPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/status/ui/HgStatusWidget";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/status/ui/HgStatusWidget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "guessCurrentRepository";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFullBranchName";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMultiRoot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetPopup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rememberRecentRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    static final class Factory
    implements StatusBarWidgetFactory {
        Factory() {
        }

        @NotNull
        public String getId() {
            return HgStatusWidget.ID;
        }

        @NotNull
        public String getDisplayName() {
            String string = HgBundle.message("hg4idea.status.bar.widget.name", new Object[0]);
            if (string == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return !((HgRepositoryManager)((Object)project.getService(HgRepositoryManager.class))).getRepositories().isEmpty();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return new HgStatusWidget(Objects.requireNonNull(HgVcs.getInstance(project)), project, HgProjectSettings.getInstance(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/status/ui/HgStatusWidget$Factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/status/ui/HgStatusWidget$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static final class Listener
    implements VcsRepositoryMappingListener {
        private final Project myProject;

        Listener(@NotNull Project project) {
            if (project == null) {
                Listener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void mappingChanged() {
            ((StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class)).updateWidget(Factory.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgStatusWidget$Listener", "<init>"));
        }
    }
}

