/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;

public class MavenProjectProblem
implements Serializable {
    private final boolean myIsError;
    private final String myPath;
    private final String myDescription;
    private final ProblemType myType;
    private final Exception st;
    @Nullable
    private final MavenArtifact myMavenArtifact;

    public static MavenProjectProblem createStructureProblem(String path, String description, boolean isError) {
        return MavenProjectProblem.createProblem(path, description, ProblemType.STRUCTURE, isError);
    }

    public static MavenProjectProblem createStructureProblem(String path, String description) {
        return MavenProjectProblem.createProblem(path, description, ProblemType.STRUCTURE, true);
    }

    public static MavenProjectProblem createSyntaxProblem(String path, ProblemType type) {
        return MavenProjectProblem.createProblem(path, MessageFormat.format("''{0}'' has syntax errors", new File(path).getName()), type, true);
    }

    public static MavenProjectProblem createProblem(String path, String description, ProblemType type, boolean isError) {
        return new MavenProjectProblem(path, description, type, isError);
    }

    public static MavenProjectProblem createRepositoryProblem(String path, String description, boolean isError, MavenArtifact mavenArtifact) {
        return new MavenProjectProblem(path, description, ProblemType.REPOSITORY, isError, mavenArtifact);
    }

    public static MavenProjectProblem createUnresolvedArtifactProblem(String path, String description, boolean isError, MavenArtifact mavenArtifact) {
        return new MavenProjectProblem(path, description, ProblemType.DEPENDENCY, isError, mavenArtifact);
    }

    public MavenProjectProblem(String path, String description, ProblemType type, boolean isError) {
        this(path, description, type, isError, null);
    }

    public MavenProjectProblem(String path, String description, ProblemType type, boolean isError, MavenArtifact mavenArtifact) {
        this.myPath = path;
        this.myDescription = description;
        this.myType = type;
        this.myIsError = isError;
        this.myMavenArtifact = mavenArtifact;
        this.st = new Exception();
    }

    public String getPath() {
        return this.myPath;
    }

    public boolean isError() {
        return this.myIsError;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public ProblemType getType() {
        return this.myType;
    }

    @Nullable
    public MavenArtifact getMavenArtifact() {
        return this.myMavenArtifact;
    }

    public String toString() {
        return (Object)((Object)this.myType) + ":" + this.myDescription + ":" + this.myPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenProjectProblem that = (MavenProjectProblem)o;
        if (!Objects.equals(this.myDescription, that.myDescription)) {
            return false;
        }
        if (this.myType != that.myType) {
            return false;
        }
        return Objects.equals(this.myPath, that.myPath);
    }

    public int hashCode() {
        int result = this.myPath != null ? this.myPath.hashCode() : 0;
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }

    public static enum ProblemType {
        SYNTAX,
        STRUCTURE,
        DEPENDENCY,
        PARENT,
        SETTINGS_OR_PROFILES,
        REPOSITORY;

    }
}

