/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringsKmp;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtilKmp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\nJ\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/intellij/util/text/CharSequenceSubSequence;", "", "Lcom/intellij/util/text/CharArrayExternalizable;", "Lcom/intellij/openapi/util/text/CharSequenceWithStringHash;", "baseSequence", "start", "", "end", "<init>", "(Ljava/lang/CharSequence;II)V", "(Ljava/lang/CharSequence;)V", "getBaseSequence", "()Ljava/lang/CharSequence;", "hash", "length", "getLength", "()I", "get", "", "index", "subSequence", "startIndex", "endIndex", "toString", "", "getChars", "", "dest", "", "destPos", "hashCode", "equals", "", "other", "", "intellij.platform.util.base.multiplatform"})
public class CharSequenceSubSequence
implements CharSequence,
CharArrayExternalizable,
CharSequenceWithStringHash {
    @NotNull
    private final CharSequence baseSequence;
    private final int start;
    private final int end;
    private transient int hash;

    public CharSequenceSubSequence(@NotNull CharSequence baseSequence, int start, int end) {
        Intrinsics.checkNotNullParameter(baseSequence, "baseSequence");
        this.baseSequence = baseSequence;
        this.start = start;
        this.end = end;
        if (this.start < 0 || this.end > this.baseSequence.length() || this.start > this.end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + this.baseSequence.length() + ", start:" + this.start + ", end:" + this.end);
        }
    }

    @NotNull
    public final CharSequence getBaseSequence() {
        return this.baseSequence;
    }

    public CharSequenceSubSequence(@NotNull CharSequence baseSequence) {
        Intrinsics.checkNotNullParameter(baseSequence, "baseSequence");
        this(baseSequence, 0, baseSequence.length());
    }

    public int getLength() {
        return this.end - this.start;
    }

    public char get(int index) {
        return this.baseSequence.charAt(index + this.start);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex == this.start && endIndex == this.end) {
            return this;
        }
        return new CharSequenceSubSequence(this.baseSequence, this.start + startIndex, this.start + endIndex);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.baseSequence instanceof String) {
            String string = ((String)this.baseSequence).substring(this.start, this.end);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return string;
        }
        return StringsKt.concatToString(CharArrayUtilKmp.fromSequence(this.baseSequence, this.start, this.end));
    }

    @Override
    public void getChars(int start, int end, @NotNull char[] dest, int destPos) {
        Intrinsics.checkNotNullParameter(dest, "dest");
        if (!(end - start <= this.end - this.start)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CharArrayUtilKmp.getChars(this.baseSequence, dest, start + this.start, destPos, end - start);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringsKmp.stringHashCode$default(this.baseSequence, this.start, this.end, 0, 4, null);
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof CharSequence && StringsKt.contentEquals(this, (CharSequence)other);
    }
}

