/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.initScript.util;

import com.intellij.gradle.toolingExtension.impl.initScript.util.GradleDebuggerUtil;
import com.intellij.gradle.toolingExtension.impl.initScript.util.GradleTasksUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerHelper;
import java.util.ArrayList;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;
import org.gradle.process.JavaForkOptions;

public class GradleJvmForkedDebuggerHelper {
    public static TaskCollection<Task> getTasksToDebug(Project project) {
        boolean isDebugAllEnabled = GradleDebuggerUtil.isDebugAllEnabled();
        project.getLogger().debug("isDebugAllEnabled: {}", (Object)isDebugAllEnabled);
        return (isDebugAllEnabled ? project.getTasks() : GradleTasksUtil.getStartTasks(project)).matching(task -> task instanceof JavaForkOptions);
    }

    public static void setupDebugger(Task task, String projectDirectory) {
        if (GradleDebuggerUtil.isDebuggerEnabled()) {
            if (task instanceof Test) {
                ((Test)task).setMaxParallelForks(1);
                GradleTaskUtil.setTaskTestForkEvery((Test)task, 0L);
            }
            String processName = task.getPath();
            String debuggerId = GradleDebuggerUtil.getDebuggerId();
            String processParameters = GradleDebuggerUtil.getProcessParameters();
            int debugPort = ForkedDebuggerHelper.setupDebugger((String)debuggerId, (String)processName, (String)processParameters, (String)projectDirectory);
            ArrayList<String> jvmArgs = new ArrayList<String>(Objects.requireNonNull(((JavaForkOptions)task).getJvmArgs()));
            jvmArgs.removeIf(it -> it == null || it.startsWith("-agentlib:jdwp") || it.startsWith("-Xrunjdwp"));
            jvmArgs.add("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + ForkedDebuggerHelper.getAddrFromProperty() + ':' + debugPort);
            jvmArgs.addAll(GradleDebuggerUtil.getProcessOptions());
            ((JavaForkOptions)task).setJvmArgs(jvmArgs);
        }
    }

    public static void signalizeFinish(Task task) {
        if (GradleDebuggerUtil.isDebuggerEnabled()) {
            String processName = task.getPath();
            String debuggerId = GradleDebuggerUtil.getDebuggerId();
            ForkedDebuggerHelper.signalizeFinish((String)debuggerId, (String)processName);
        }
    }
}

