/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ9\u0010\u000e\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J9\u0010\u0014\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)V", "checkTypeAliasExpansionCapturesOuterTypeParameters", "fullyExpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expandedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "checkTypealiasShouldExpandToClass", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnyTypeAliasChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnyTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,131:1\n63#2:132\n37#2:133\n63#2:134\n808#3,11:135\n1#4:146\n12637#5,2:147\n*S KotlinDebug\n*F\n+ 1 FirAnyTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker\n*L\n35#1:132\n67#1:133\n67#1:134\n78#1:135,11\n82#1:147,2\n*E\n"})
public final class FirAnyTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirAnyTypeAliasChecker INSTANCE = new FirAnyTypeAliasChecker();

    private FirAnyTypeAliasChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!FirHelpersKt.isTopLevel(context)) {
            FirClassLikeDeclaration $this$isLocal$iv = declaration;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Local type aliases are unsupported.", null, (int)16, null);
            } else {
                FirHelpersKt.requireFeatureSupport$default(context, reporter, declaration, LanguageFeature.NestedTypeAliases, null, 8, null);
            }
        }
        FirTypeRef expandedTypeRef = declaration.getExpandedTypeRef();
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context, FirTypeUtilsKt.getConeType(expandedTypeRef));
        this.checkTypeAliasExpansionCapturesOuterTypeParameters(context, reporter, declaration, fullyExpandedType2, expandedTypeRef);
        this.checkTypealiasShouldExpandToClass(context, reporter, declaration, fullyExpandedType2, expandedTypeRef);
        FirUnderscoreHelpersKt.checkTypeRefForUnderscore(context, reporter, expandedTypeRef);
        boolean allowNullableNothing = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.NullableNothingInReifiedPosition);
        if (FirHelpersKt.isMalformedExpandedType(context, fullyExpandedType2, allowNullableNothing)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getExpandedTypeRef().getSource()), FirErrors.INSTANCE.getTYPEALIAS_EXPANDS_TO_ARRAY_OF_NOTHINGS(), (Object)fullyExpandedType2, null, (int)16, null);
        }
    }

    private final void checkTypeAliasExpansionCapturesOuterTypeParameters(CheckerContext context, DiagnosticReporter reporter, FirTypeAlias $this$checkTypeAliasExpansionCapturesOuterTypeParameters, ConeKotlinType fullyExpandedType2, FirTypeRef expandedTypeRef) {
        block5: {
            block4: {
                if (FirHelpersKt.isTopLevel(context)) break block4;
                FirMemberDeclaration $this$isInner$iv = $this$checkTypeAliasExpansionCapturesOuterTypeParameters;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block4;
                FirClassLikeDeclaration $this$isLocal$iv = $this$checkTypeAliasExpansionCapturesOuterTypeParameters;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block5;
            }
            return;
        }
        Set unsubstitutedOuterTypeParameters = new LinkedHashSet();
        FirAnyTypeAliasChecker.checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively(fullyExpandedType2, context, unsubstitutedOuterTypeParameters);
        if (!((Collection)unsubstitutedOuterTypeParameters).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expandedTypeRef.getSource()), FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_CAPTURES_OUTER_TYPE_PARAMETERS(), (Object)unsubstitutedOuterTypeParameters, null, (int)16, null);
        }
    }

    private final void checkTypealiasShouldExpandToClass(CheckerContext context, DiagnosticReporter reporter, FirTypeAlias $this$checkTypealiasShouldExpandToClass, ConeKotlinType fullyExpandedType2, FirTypeRef expandedTypeRef) {
        if (FirAnyTypeAliasChecker.checkTypealiasShouldExpandToClass$containsTypeParameter(context, fullyExpandedType2) || fullyExpandedType2 instanceof ConeDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkTypealiasShouldExpandToClass.getExpandedTypeRef().getSource()), FirErrors.INSTANCE.getTYPEALIAS_SHOULD_EXPAND_TO_CLASS(), (Object)FirTypeUtilsKt.getConeType(expandedTypeRef), null, (int)16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively(ConeKotlinType $this$checkTypeAliasExpansionCapturesOuterTypeParameters_u24checkRecursively, CheckerContext $context, Set<FirTypeParameterSymbol> unsubstitutedOuterTypeParameters) {
        void $this$filterIsInstanceTo$iv$iv;
        Object object;
        for (ConeTypeProjection typeArgument : $this$checkTypeAliasExpansionCapturesOuterTypeParameters_u24checkRecursively.getTypeArguments()) {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(typeArgument);
            if (coneKotlinType == null || (object = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)$context, coneKotlinType)) == null) continue;
            FirAnyTypeAliasChecker.checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively((ConeKotlinType)object, $context, unsubstitutedOuterTypeParameters);
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol($this$checkTypeAliasExpansionCapturesOuterTypeParameters_u24checkRecursively, $context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
        Iterable $this$filterIsInstance$iv = ((FirRegularClass)regularClassSymbol.getFir()).getTypeParameters();
        boolean $i$f$filterIsInstance = false;
        object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirOuterClassTypeParameterRef)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable it = $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable = !((Collection)it).isEmpty() ? $this$filterIsInstance$iv : null;
        if (iterable == null) {
            return;
        }
        Iterable outerTypeParameterRefs = iterable;
        for (FirOuterClassTypeParameterRef outerTypeParameterRef : outerTypeParameterRefs) {
            boolean bl2;
            block6: {
                ConeTypeProjection[] $this$any$iv = $this$checkTypeAliasExpansionCapturesOuterTypeParameters_u24checkRecursively.getTypeArguments();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it2 = element$iv = $this$any$iv[j];
                    boolean bl3 = false;
                    ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it2);
                    if (!Intrinsics.areEqual((Object)(coneKotlinType != null ? ToSymbolUtilsKt.toTypeParameterSymbol(coneKotlinType, $context.getSession()) : null), (Object)outerTypeParameterRef.getSymbol())) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            unsubstitutedOuterTypeParameters.add(outerTypeParameterRef.getSymbol());
        }
    }

    private static final boolean checkTypealiasShouldExpandToClass$containsTypeParameter(CheckerContext $context, ConeKotlinType type2) {
        ConeSimpleKotlinType unwrapped = ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(type2);
        if (unwrapped instanceof ConeTypeParameterType) {
            return true;
        }
        if (unwrapped instanceof ConeClassLikeType && ToSymbolUtilsKt.toSymbol(((ConeClassLikeType)unwrapped).getLookupTag(), $context.getSession()) instanceof FirTypeAliasSymbol) {
            for (ConeTypeProjection typeArgument : unwrapped.getTypeArguments()) {
                ConeKotlinType typeArgumentType;
                ConeKotlinType coneKotlinType = typeArgument instanceof ConeKotlinType ? (ConeKotlinType)typeArgument : null;
                if (coneKotlinType == null) {
                    ConeKotlinTypeProjection coneKotlinTypeProjection = typeArgument instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)typeArgument : null;
                    coneKotlinType = coneKotlinTypeProjection != null ? coneKotlinTypeProjection.getType() : null;
                }
                if ((typeArgumentType = coneKotlinType) == null || !FirAnyTypeAliasChecker.checkTypealiasShouldExpandToClass$containsTypeParameter($context, typeArgumentType)) continue;
                return true;
            }
        }
        return false;
    }
}

