/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponent;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.ConflictState;
import org.jetbrains.kotlin.fir.analysis.checkers.DeclarationBuckets;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirRedeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirNameConflictsTracker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOverloadabilityHelper;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOverloadabilityHelperKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImplKt;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirErrorCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.util.ListMultimap;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00c8\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0007H\u0002\u001a \u0010\u000e\u001a\u00020\u00012\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\u001a3\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u00020\u0015j\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u001a\u001a \u0010\u001b\u001a\u00020\u001c*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f\u001a9\u0010$\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070&0\u00122\u0006\u0010'\u001a\u00020(R\u00020\u0015j\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0002\u0010)\u001aY\u0010*\u001a\u00020\u001c\"\f\b\u0000\u0010+*\u0006\u0012\u0002\b\u00030\u0007\"\b\b\u0001\u0010,*\u0002H+*\b\u0012\u0004\u0012\u0002H+0\u001d2\u0006\u0010-\u001a\u0002H,2\u0006\u0010.\u001a\u00020/2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u0002H,0201H\u0002\u00a2\u0006\u0002\u00103\u001a$\u00104\u001a\u00020\u001c*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u001d2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208\u001a/\u00109\u001a\u0010\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<\u0018\u00010:*\u0006\u0012\u0002\b\u00030=H\u0002R\u00020\u0015j\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0002\u0010>\u001a \u0010?\u001a\u00020\u00012\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\u001aV\u0010B\u001a\u00020\u001c*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u001d2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u0002062\n\u0010E\u001a\u0006\u0012\u0002\b\u00030\u00072\n\b\u0002\u0010F\u001a\u0004\u0018\u00010/2\n\b\u0002\u0010G\u001a\u0004\u0018\u000106H\u0002\u001a\u0014\u0010H\u001a\u00020\u0001*\u00020\t2\u0006\u0010I\u001a\u00020JH\u0002\u001a:\u0010K\u001a\u00020\u00012\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010M\u001a\u0002062\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010O\u001a\u0004\u0018\u0001062\u0006\u0010I\u001a\u00020JH\u0002\u001a(\u0010P\u001a\u00020Q*\u0006\u0012\u0002\b\u00030\u001d2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010R\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\u001a$\u0010S\u001a\u00020Q*\u00020T2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030U2\n\u0010R\u001a\u0006\u0012\u0002\b\u00030UH\u0002\u001a1\u0010V\u001a\u00020\u001c2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020Z0\u0018R\u00020\u0015R\u00020Wj\u0006\u0010\u0016\u001a\u00020\u0015j\u0006\u0010X\u001a\u00020W\u00a2\u0006\u0002\u0010[\"\u0018\u0010\u0003\u001a\u00020\u0001*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\"\u0018\u0010\b\u001a\u00020\u0001*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u0006\u0012\u0002\b\u00030\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001c\u0010 \u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006\\"}, d2={"isAllowedForMainFunction", "", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "isTopLevel", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "isCollectable", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isCollectableAccordingToSource", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Z", "resolvedStatus", "getResolvedStatus", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "isAtLeastOneExpect", "first", "second", "groupTopLevelByName", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/DeclarationBuckets;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "declarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/List;)Ljava/util/Map;", "collectClassMembers", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "klass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "name", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "getName", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;)Lorg/jetbrains/kotlin/name/Name;", "collectConflictingLocalFunctionsFrom", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)Ljava/util/Map;", "collect", "D", "S", "declaration", "representation", "", "map", "", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Ljava/lang/String;Ljava/util/Map;)V", "collectTopLevel", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "packageMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "expandedClassWithConstructorsScope", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Lkotlin/Pair;", "shouldCheckForMultiplatformRedeclaration", "dependency", "dependent", "collectTopLevelConflict", "declarationPresentation", "containingFile", "conflictingSymbol", "conflictingPresentation", "conflictingFile", "representsMainFunctionAllowingConflictingOverloads", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "areCompatibleMainFunctions", "declaration1", "file1", "declaration2", "file2", "getConflictState", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConflictState;", "conflicting", "getConflictStateWithContextParameters", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOverloadabilityHelper;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkForLocalRedeclarations", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "elements", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConflictsHelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 FirScope.kt\norg/jetbrains/kotlin/fir/scopes/FirScopeKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,605:1\n1761#2,3:606\n1761#2,3:609\n1761#2,3:612\n774#2:638\n865#2,2:639\n1869#2,2:656\n382#3,7:615\n382#3,7:622\n382#3,7:629\n382#3,7:641\n382#3,7:648\n382#3,7:658\n124#4,2:636\n1#5:655\n*S KotlinDebug\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConflictsHelpersKt\n*L\n63#1:606,3\n64#1:609,3\n66#1:612,3\n264#1:638\n264#1:639,2\n416#1:656,2\n116#1:615,7\n119#1:622,7\n129#1:629,7\n296#1:641,7\n309#1:648,7\n487#1:658,7\n244#1:636,2\n*E\n"})
public final class FirConflictsHelpersKt {
    private static final boolean isAllowedForMainFunction(FirResolvedDeclarationStatus $this$isAllowedForMainFunction) {
        FirResolvedDeclarationStatus defaultStatusForMain = FirResolvedDeclarationStatusImpl.Companion.getDEFAULT_STATUS_FOR_STATUSLESS_DECLARATIONS();
        if (!Intrinsics.areEqual((Object)$this$isAllowedForMainFunction.getVisibility(), (Object)defaultStatusForMain.getVisibility()) && $this$isAllowedForMainFunction.getModality() != defaultStatusForMain.getModality() && !Intrinsics.areEqual((Object)$this$isAllowedForMainFunction.getEffectiveVisibility(), (Object)defaultStatusForMain.getEffectiveVisibility())) {
            return false;
        }
        FirDeclarationStatus cleanedStatus = UtilsKt.copy$default($this$isAllowedForMainFunction, null, null, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0x3EFFFF, null);
        return FirDeclarationStatusImplKt.getModifiersRepresentation(cleanedStatus) == FirDeclarationStatusImplKt.getModifiersRepresentation(defaultStatusForMain);
    }

    private static final boolean isTopLevel(CallableId $this$isTopLevel) {
        return $this$isTopLevel.getClassName() == null;
    }

    private static final boolean isCollectable(FirBasedSymbol<?> $this$isCollectable) {
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol;
        if ($this$isCollectable instanceof FirCallableSymbol) {
            boolean bl2;
            FirBasedSymbol it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block26: {
                boolean bl3;
                block25: {
                    if ($this$isCollectable instanceof FirErrorCallableSymbol) {
                        return false;
                    }
                    $this$any$iv = ((FirCallableSymbol)$this$isCollectable).getContextParameterSymbols();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (FirValueParameterSymbol)element$iv;
                            boolean bl4 = false;
                            if (!ConeTypeUtilsKt.hasError(((FirCallableSymbol)it).getResolvedReturnType())) continue;
                            bl3 = true;
                            break block25;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return false;
                }
                $this$any$iv = ((FirCallableSymbol)$this$isCollectable).getTypeParameterSymbols();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (FirTypeParameterSymbol)element$iv;
                        boolean bl5 = false;
                        if (!ConeTypeUtilsKt.hasError(FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)it))) continue;
                        bl2 = true;
                        break block26;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return false;
            }
            ConeKotlinType coneKotlinType = ((FirCallableSymbol)$this$isCollectable).getResolvedReceiverType();
            boolean bl6 = coneKotlinType != null ? ConeTypeUtilsKt.hasError(coneKotlinType) : false;
            if (bl6) {
                return false;
            }
            if ($this$isCollectable instanceof FirFunctionSymbol) {
                boolean bl7;
                block27: {
                    $this$any$iv = ((FirFunctionSymbol)$this$isCollectable).getValueParameterSymbols();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl7 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (FirValueParameterSymbol)element$iv;
                            boolean bl8 = false;
                            if (!ConeTypeUtilsKt.hasError(((FirCallableSymbol)it).getResolvedReturnType())) continue;
                            bl7 = true;
                            break block27;
                        }
                        bl7 = false;
                    }
                }
                if (bl7) {
                    return false;
                }
            }
            if (Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenToOvercomeSignatureClash((FirCallableDeclaration)((FirCallableSymbol)$this$isCollectable).getFir()), (Object)true)) {
                return false;
            }
        }
        if ((firBasedSymbol = $this$isCollectable) instanceof FirNamedFunctionSymbol) {
            bl = FirConflictsHelpersKt.isCollectableAccordingToSource((FirNamedFunctionSymbol)$this$isCollectable) && !Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)$this$isCollectable).getName(), (Object)SpecialNames.NO_NAME_PROVIDED);
        } else if (firBasedSymbol instanceof FirRegularClassSymbol) {
            bl = !Intrinsics.areEqual((Object)((FirRegularClassSymbol)$this$isCollectable).getName(), (Object)SpecialNames.NO_NAME_PROVIDED);
        } else if (firBasedSymbol instanceof FirPropertySymbol) {
            KtSourceElement ktSourceElement = ((FirPropertySymbol)$this$isCollectable).getSource();
            bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.EnumGeneratedDeclaration);
        } else if (firBasedSymbol instanceof FirFieldSymbol) {
            KtSourceElement ktSourceElement = ((FirFieldSymbol)$this$isCollectable).getSource();
            bl = !Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ClassDelegationField.INSTANCE);
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCollectableAccordingToSource(FirNamedFunctionSymbol $this$isCollectableAccordingToSource) {
        KtSourceElement ktSourceElement = $this$isCollectableAccordingToSource.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) return true;
        KtSourceElement ktSourceElement2 = $this$isCollectableAccordingToSource.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) return false;
        return true;
    }

    @Nullable
    public static final FirResolvedDeclarationStatus getResolvedStatus(@NotNull FirBasedSymbol<?> $this$resolvedStatus) {
        Intrinsics.checkNotNullParameter($this$resolvedStatus, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$resolvedStatus;
        return firBasedSymbol instanceof FirCallableSymbol ? ((FirCallableSymbol)$this$resolvedStatus).getResolvedStatus() : (firBasedSymbol instanceof FirClassLikeSymbol ? ((FirClassLikeSymbol)$this$resolvedStatus).getResolvedStatus() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAtLeastOneExpect(FirBasedSymbol<?> first, FirBasedSymbol<?> second) {
        boolean bl;
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = FirConflictsHelpersKt.getResolvedStatus(first);
        if (firResolvedDeclarationStatus != null) {
            if (firResolvedDeclarationStatus.isExpect()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        FirResolvedDeclarationStatus firResolvedDeclarationStatus2 = FirConflictsHelpersKt.getResolvedStatus(second);
        if (firResolvedDeclarationStatus2 == null) return false;
        if (!firResolvedDeclarationStatus2.isExpect()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Name, DeclarationBuckets> groupTopLevelByName(CheckerContext context2, List<? extends FirDeclaration> declarations2) {
        Map groups = new LinkedHashMap();
        for (FirDeclaration firDeclaration : declarations2) {
            Pair<FirRegularClassSymbol, FirScope> pair;
            String representation;
            Object object;
            void $this$getOrPut$iv;
            Object key$iv;
            if (!FirConflictsHelpersKt.isCollectable(firDeclaration.getSymbol())) continue;
            FirDeclaration firDeclaration2 = firDeclaration;
            if (firDeclaration2 instanceof FirSimpleFunction) {
                Object object2;
                Collection $this$getOrPut$iv2;
                Map map = groups;
                key$iv = ((FirSimpleFunction)firDeclaration).getName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv2.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    DeclarationBuckets answer$iv = new DeclarationBuckets();
                    $this$getOrPut$iv2.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                $this$getOrPut$iv2 = ((DeclarationBuckets)object2).getSimpleFunctions();
                key$iv = TuplesKt.to((Object)((FirSimpleFunction)firDeclaration).getSymbol(), (Object)FirRedeclarationPresenter.INSTANCE.represent(((FirSimpleFunction)firDeclaration).getSymbol()));
                $this$getOrPut$iv2.add(key$iv);
                continue;
            }
            if (firDeclaration2 instanceof FirProperty) {
                Object object3;
                void $this$getOrPut$iv3;
                key$iv = groups;
                Name key$iv2 = ((FirProperty)firDeclaration).getName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv3.get(key$iv2);
                if (value$iv == null) {
                    boolean bl = false;
                    DeclarationBuckets answer$iv = new DeclarationBuckets();
                    $this$getOrPut$iv3.put(key$iv2, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                DeclarationBuckets group = (DeclarationBuckets)object3;
                String representation2 = FirRedeclarationPresenter.INSTANCE.represent(((FirProperty)firDeclaration).getSymbol());
                if (((FirProperty)firDeclaration).getReceiverParameter() != null) {
                    ((Collection)group.getExtensionProperties()).add(TuplesKt.to((Object)((FirProperty)firDeclaration).getSymbol(), (Object)representation2));
                    continue;
                }
                ((Collection)group.getProperties()).add(TuplesKt.to((Object)((FirProperty)firDeclaration).getSymbol(), (Object)representation2));
                continue;
            }
            if (!(firDeclaration2 instanceof FirClassLikeDeclaration) || FirRedeclarationPresenter.INSTANCE.represent((FirBasedSymbol)((FirClassLikeDeclaration)firDeclaration).getSymbol()) == null) continue;
            Map key$iv2 = groups;
            Name key$iv3 = FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)firDeclaration);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv3);
            if (value$iv == null) {
                boolean bl = false;
                DeclarationBuckets answer$iv = new DeclarationBuckets();
                $this$getOrPut$iv.put(key$iv3, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            DeclarationBuckets group = (DeclarationBuckets)object;
            ((Collection)group.getClassLikes()).add(TuplesKt.to(((FirClassLikeDeclaration)firDeclaration).getSymbol(), (Object)representation));
            if (FirConflictsHelpersKt.expandedClassWithConstructorsScope(context2, ((FirClassLikeDeclaration)firDeclaration).getSymbol()) == null) continue;
            boolean bl = false;
            FirRegularClassSymbol expandedClass = (FirRegularClassSymbol)pair.component1();
            FirScope scopeWithConstructors = (FirScope)pair.component2();
            if (expandedClass.getClassKind() == ClassKind.OBJECT) continue;
            scopeWithConstructors.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.groupTopLevelByName$lambda$2$0(group, firDeclaration, arg_0)));
        }
        return groups;
    }

    /*
     * WARNING - void declaration
     */
    public static final void collectClassMembers(@NotNull FirDeclarationCollector<FirBasedSymbol<?>> $this$collectClassMembers, @NotNull FirClassSymbol<?> klass) {
        Intrinsics.checkNotNullParameter($this$collectClassMembers, (String)"<this>");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        CheckerContext $this$collectClassMembers_u24lambda_u240 = $this$collectClassMembers.getContext$checkers();
        boolean bl = false;
        Map otherDeclarations = new LinkedHashMap();
        Map functionDeclarations = new LinkedHashMap();
        FirContainingNamesAwareScope declaredMemberScope = FirHelpersKt.declaredMemberScope($this$collectClassMembers_u24lambda_u240, klass);
        FirTypeScope unsubstitutedScope = FirHelpersKt.unsubstitutedScope($this$collectClassMembers_u24lambda_u240, klass);
        FirContainingNamesAwareScopeKt.processAllFunctions(declaredMemberScope, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$0$0($this$collectClassMembers, functionDeclarations, unsubstitutedScope, klass, arg_0)));
        if (FirHelpersKt.isTopLevel($this$collectClassMembers.getContext$checkers())) {
            unsubstitutedScope.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$0$1(klass, $this$collectClassMembers, functionDeclarations, arg_0)));
        }
        FirContainingNamesAwareScopeKt.processAllProperties(declaredMemberScope, arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$0$2($this$collectClassMembers, otherDeclarations, unsubstitutedScope, klass, arg_0));
        for (FirBasedSymbol<?> declaredClassifier : klass.getDeclarationSymbols()) {
            void name$iv;
            void $this$processClassifiersByName$iv;
            if (!(declaredClassifier instanceof FirClassifierSymbol)) continue;
            FirConflictsHelpersKt.collectClassMembers$lambda$0$processClassifier(klass, $this$collectClassMembers, otherDeclarations, $this$collectClassMembers_u24lambda_u240, functionDeclarations, (FirClassifierSymbol)declaredClassifier);
            FirScope firScope = unsubstitutedScope;
            Name name2 = FirConflictsHelpersKt.getName((FirClassifierSymbol)declaredClassifier);
            Function1 processor$iv = arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$0$4(declaredClassifier, klass, $this$collectClassMembers, otherDeclarations, $this$collectClassMembers_u24lambda_u240, functionDeclarations, arg_0);
            boolean $i$f$processClassifiersByName = false;
            $this$processClassifiersByName$iv.processClassifiersByNameWithSubstitution((Name)name$iv, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
                final /* synthetic */ Function1 $processor;
                {
                    this.$processor = $processor;
                }

                public final void invoke(FirClassifierSymbol<?> symbol, ConeSubstitutor coneSubstitutor) {
                    Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                    Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<unused var>");
                    this.$processor.invoke(symbol);
                }
            });
        }
    }

    private static final Name getName(FirClassifierSymbol<?> $this$name) {
        Name name2;
        FirClassifierSymbol<?> firClassifierSymbol = $this$name;
        if (firClassifierSymbol instanceof FirClassLikeSymbol) {
            name2 = ((FirClassLikeSymbol)$this$name).getName();
        } else if (firClassifierSymbol instanceof FirTypeParameterSymbol) {
            name2 = ((FirTypeParameterSymbol)$this$name).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<FirFunctionSymbol<?>, Set<FirBasedSymbol<?>>> collectConflictingLocalFunctionsFrom(@NotNull CheckerContext context2, @NotNull FirBlock block) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Iterable $this$filter$iv = block.getStatements();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirStatement it = (FirStatement)element$iv$iv;
            boolean bl = false;
            if (!((it instanceof FirSimpleFunction || it instanceof FirRegularClass) && FirConflictsHelpersKt.isCollectable(((FirDeclaration)((Object)it)).getSymbol()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List collectables = (List)destination$iv$iv;
        if (collectables.isEmpty()) {
            return MapsKt.emptyMap();
        }
        FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
        Map functionDeclarations = new LinkedHashMap();
        for (FirStatement collectable : collectables) {
            Pair<FirRegularClassSymbol, FirScope> pair;
            FirStatement firStatement = collectable;
            if (firStatement instanceof FirSimpleFunction) {
                FirConflictsHelpersKt.collect(inspector, (FirBasedSymbol)((FirSimpleFunction)collectable).getSymbol(), FirRedeclarationPresenter.INSTANCE.represent(((FirSimpleFunction)collectable).getSymbol()), functionDeclarations);
                continue;
            }
            if (!(firStatement instanceof FirClassLikeDeclaration)) continue;
            if (FirConflictsHelpersKt.expandedClassWithConstructorsScope(context2, ((FirClassLikeDeclaration)collectable).getSymbol()) == null) continue;
            boolean bl = false;
            FirScope scopeWithConstructors = (FirScope)pair.component2();
            scopeWithConstructors.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectConflictingLocalFunctionsFrom$lambda$1$0(inspector, collectable, functionDeclarations, arg_0)));
        }
        return inspector.getDeclarationConflictingSymbols();
    }

    /*
     * WARNING - void declaration
     */
    private static final <D extends FirBasedSymbol<?>, S extends D> void collect(FirDeclarationCollector<D> $this$collect, S declaration, String representation, Map<String, Set<S>> map) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, Set<Object>> map2 = map;
        String key$iv = representation;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map2 = object;
        Set it = (Set)((Object)map2);
        boolean bl = false;
        if (it.add(declaration)) {
            SmartSet<FirBasedSymbol> conflicts = SmartSet.Companion.create();
            SmartSet<FirBasedSymbol> shadowing = SmartSet.Companion.create();
            block5: for (FirBasedSymbol otherDeclaration : it) {
                if (Intrinsics.areEqual((Object)otherDeclaration, declaration)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[FirConflictsHelpersKt.getConflictState($this$collect, declaration, otherDeclaration).ordinal()]) {
                    case 1: {
                        Object object2;
                        void $this$getOrPut$iv2;
                        conflicts.add(otherDeclaration);
                        Map map3 = $this$collect.getDeclarationConflictingSymbols();
                        FirBasedSymbol key$iv2 = otherDeclaration;
                        boolean $i$f$getOrPut2 = false;
                        Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                        if (value$iv2 == null) {
                            boolean bl2 = false;
                            SmartSet answer$iv = SmartSet.Companion.create();
                            $this$getOrPut$iv2.put(key$iv2, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv2;
                        }
                        ((SmartSet)((Object)object2)).add(declaration);
                        continue block5;
                    }
                    case 2: {
                        shadowing.add(otherDeclaration);
                        continue block5;
                    }
                    case 3: {
                        continue block5;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            ((Map)$this$collect.getDeclarationConflictingSymbols()).put(declaration, conflicts);
            ((Map)$this$collect.getDeclarationShadowedViaContextParameters()).put(declaration, shadowing);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void collectTopLevel(@NotNull FirDeclarationCollector<FirBasedSymbol<?>> $this$collectTopLevel, @NotNull FirFile file, @NotNull FirPackageMemberScope packageMemberScope) {
        Intrinsics.checkNotNullParameter($this$collectTopLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)packageMemberScope, (String)"packageMemberScope");
        CheckerContext $this$collectTopLevel_u24lambda_u240 = $this$collectTopLevel.getContext$checkers();
        boolean bl = false;
        for (Map.Entry<Name, DeclarationBuckets> entry : FirConflictsHelpersKt.groupTopLevelByName($this$collectTopLevel_u24lambda_u240, file.getDeclarations()).entrySet()) {
            boolean groupHasSimpleFunctions;
            Name declarationName = entry.getKey();
            DeclarationBuckets group = entry.getValue();
            boolean groupHasClassLikesOrProperties = !((Collection)group.getClassLikes()).isEmpty() || !((Collection)group.getProperties()).isEmpty();
            boolean bl2 = groupHasSimpleFunctions = !((Collection)group.getSimpleFunctions()).isEmpty();
            if (groupHasSimpleFunctions || !((Collection)group.getConstructors()).isEmpty()) {
                packageMemberScope.processFunctionsByName(declarationName, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectTopLevel$lambda$0$1(group, $this$collectTopLevel, file, $this$collectTopLevel_u24lambda_u240, declarationName, arg_0)));
            }
            if (groupHasClassLikesOrProperties || groupHasSimpleFunctions) {
                packageMemberScope.processClassifiersByNameWithSubstitution(declarationName, (arg_0, arg_1) -> FirConflictsHelpersKt.collectTopLevel$lambda$0$2(group, groupHasSimpleFunctions, $this$collectTopLevel_u24lambda_u240, $this$collectTopLevel, file, declarationName, arg_0, arg_1));
                FirNameConflictsTrackerComponent firNameConflictsTrackerComponent = FirNameConflictsTrackerComponentKt.getNameConflictsTracker($this$collectTopLevel_u24lambda_u240.getSession());
                if (firNameConflictsTrackerComponent != null) {
                    Map<ClassId, Set<FirNameConflictsTracker.ClassifierWithFile>> map;
                    Object it = firNameConflictsTrackerComponent;
                    boolean bl322 = false;
                    FirNameConflictsTracker firNameConflictsTracker = it instanceof FirNameConflictsTracker ? (FirNameConflictsTracker)it : null;
                    if (firNameConflictsTracker != null && (map = firNameConflictsTracker.getRedeclaredClassifiers()) != null && (it = map.get(new ClassId(UtilsKt.getPackageFqName(file), declarationName))) != null) {
                        void $this$forEach$iv;
                        Iterable bl322 = (Iterable)it;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            FirNameConflictsTracker.ClassifierWithFile it2 = (FirNameConflictsTracker.ClassifierWithFile)element$iv;
                            boolean bl4 = false;
                            FirConflictsHelpersKt.collectTopLevel$lambda$0$collectFromClassifierSource$default(group, groupHasSimpleFunctions, $this$collectTopLevel_u24lambda_u240, $this$collectTopLevel, file, declarationName, it2.getClassifier(), null, it2.getFile(), 128, null);
                        }
                    }
                }
                for (Pair pair : group.getClassLikes()) {
                    FirClassLikeSymbol classLike = (FirClassLikeSymbol)pair.component1();
                    String representation = (String)pair.component2();
                    FirConflictsHelpersKt.collectTopLevel$lambda$0$collectFromClassifierSource(group, groupHasSimpleFunctions, $this$collectTopLevel_u24lambda_u240, $this$collectTopLevel, file, declarationName, classLike, representation, file);
                }
            }
            if (!groupHasClassLikesOrProperties && !(!((Collection)group.getExtensionProperties()).isEmpty())) continue;
            packageMemberScope.processPropertiesByName(declarationName, arg_0 -> FirConflictsHelpersKt.collectTopLevel$lambda$0$5(group, $this$collectTopLevel, file, $this$collectTopLevel_u24lambda_u240, declarationName, arg_0));
        }
    }

    private static final Pair<FirRegularClassSymbol, FirScope> expandedClassWithConstructorsScope(CheckerContext context2, FirClassLikeSymbol<?> $this$expandedClassWithConstructorsScope) {
        return ScopeUtilsKt.expandedClassWithConstructorsScope($this$expandedClassWithConstructorsScope, context2.getSession(), context2.getScopeSession(), FirResolvePhase.STATUS);
    }

    private static final boolean shouldCheckForMultiplatformRedeclaration(FirBasedSymbol<?> dependency, FirBasedSymbol<?> dependent) {
        if (!dependent.getModuleData().getAllDependsOnDependencies().contains(dependency.getModuleData())) {
            return false;
        }
        return !FirConflictsHelpersKt.isAtLeastOneExpect(dependency, dependent);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectTopLevelConflict(FirDeclarationCollector<FirBasedSymbol<?>> $this$collectTopLevelConflict, FirBasedSymbol<?> declaration, String declarationPresentation, FirFile containingFile, FirBasedSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        Object object;
        void $this$getOrPut$iv;
        HashMap<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> hashMap;
        FirFile actualConflictingFile;
        String actualConflictingPresentation;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(conflictingSymbol, FirResolvePhase.STATUS);
        if (Intrinsics.areEqual(conflictingSymbol, declaration)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)declaration.getModuleData(), (Object)conflictingSymbol.getModuleData()) && !FirConflictsHelpersKt.shouldCheckForMultiplatformRedeclaration(declaration, conflictingSymbol)) {
            return;
        }
        String string = conflictingPresentation;
        if (string == null) {
            string = FirRedeclarationPresenter.INSTANCE.represent(conflictingSymbol);
        }
        if (!Intrinsics.areEqual((Object)(actualConflictingPresentation = string), (Object)declarationPresentation)) {
            return;
        }
        FirFile firFile = conflictingFile;
        if (firFile == null) {
            FirBasedSymbol<?> firBasedSymbol = conflictingSymbol;
            firFile = firBasedSymbol instanceof FirClassLikeSymbol ? FirProviderKt.getFirProvider($this$collectTopLevelConflict.getSession$checkers()).getFirClassifierContainerFileIfAny((FirClassLikeSymbol)conflictingSymbol) : (actualConflictingFile = firBasedSymbol instanceof FirCallableSymbol ? FirProviderKt.getFirProvider($this$collectTopLevelConflict.getSession$checkers()).getFirCallableContainerFile((FirCallableSymbol)conflictingSymbol) : null);
        }
        if (!FirConflictsHelpersKt.isCollectable(conflictingSymbol)) {
            return;
        }
        if (FirConflictsHelpersKt.areCompatibleMainFunctions(declaration, containingFile, conflictingSymbol, actualConflictingFile, $this$collectTopLevelConflict.getSession$checkers())) {
            return;
        }
        Object conflicting = conflictingSymbol.getFir();
        if (conflicting instanceof FirMemberDeclaration && !FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker($this$collectTopLevelConflict.getSession$checkers()), (FirMemberDeclaration)conflicting, $this$collectTopLevelConflict.getSession$checkers(), containingFile, CollectionsKt.emptyList(), null, false, null, false, null, 480, null)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[FirConflictsHelpersKt.getConflictState($this$collectTopLevelConflict, declaration, conflictingSymbol).ordinal()]) {
            case 1: {
                hashMap = $this$collectTopLevelConflict.getDeclarationConflictingSymbols();
                break;
            }
            case 2: {
                hashMap = $this$collectTopLevelConflict.getDeclarationShadowedViaContextParameters();
                break;
            }
            case 3: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Map map = hashMap;
        FirBasedSymbol<?> key$iv = declaration;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            SmartSet answer$iv = SmartSet.Companion.create();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((SmartSet)((Object)object)).add(conflictingSymbol);
    }

    private static final boolean representsMainFunctionAllowingConflictingOverloads(FirNamedFunctionSymbol $this$representsMainFunctionAllowingConflictingOverloads, FirSession session) {
        if (!(Intrinsics.areEqual((Object)$this$representsMainFunctionAllowingConflictingOverloads.getName(), (Object)StandardNames.MAIN) && FirConflictsHelpersKt.isTopLevel($this$representsMainFunctionAllowingConflictingOverloads.getCallableId()) && FirConflictsHelpersKt.isAllowedForMainFunction($this$representsMainFunctionAllowingConflictingOverloads.getResolvedStatus()))) {
            return false;
        }
        if ($this$representsMainFunctionAllowingConflictingOverloads.getReceiverParameterSymbol() != null || !((Collection)$this$representsMainFunctionAllowingConflictingOverloads.getTypeParameterSymbols()).isEmpty() || FirCallableSymbolKt.getHasContextParameters($this$representsMainFunctionAllowingConflictingOverloads)) {
            return false;
        }
        ConeKotlinType returnType = TypeExpansionUtilsKt.fullyExpandedType$default($this$representsMainFunctionAllowingConflictingOverloads.getResolvedReturnType(), session, null, 2, null);
        if (!ConeBuiltinTypeUtilsKt.isUnit(returnType)) {
            return false;
        }
        if ($this$representsMainFunctionAllowingConflictingOverloads.getValueParameterSymbols().isEmpty()) {
            return true;
        }
        Object object = (FirValueParameterSymbol)CollectionsKt.singleOrNull($this$representsMainFunctionAllowingConflictingOverloads.getValueParameterSymbols());
        if (object == null || (object = ((FirCallableSymbol)object).getResolvedReturnTypeRef()) == null || (object = ((FirResolvedTypeRef)object).getConeType()) == null || (object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)object, session, null, 2, null)) == null) {
            return false;
        }
        Object paramType = object;
        if (!ConeBuiltinTypeUtilsKt.isNonPrimitiveArray((ConeKotlinType)paramType)) {
            return false;
        }
        Object object2 = ArraysKt.singleOrNull((Object[])((ConeKotlinType)paramType).getTypeArguments());
        ConeKotlinTypeProjection coneKotlinTypeProjection = object2 instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)object2 : null;
        if (coneKotlinTypeProjection == null) {
            return false;
        }
        ConeKotlinTypeProjection typeArgument = coneKotlinTypeProjection;
        if (!(typeArgument instanceof ConeKotlinType) && !(typeArgument instanceof ConeKotlinTypeProjectionOut)) {
            return false;
        }
        return ConeBuiltinTypeUtilsKt.isString(TypeExpansionUtilsKt.fullyExpandedType$default(typeArgument.getType(), session, null, 2, null));
    }

    private static final boolean areCompatibleMainFunctions(FirBasedSymbol<?> declaration1, FirFile file1, FirBasedSymbol<?> declaration2, FirFile file2, FirSession session) {
        return !Intrinsics.areEqual((Object)file1, (Object)file2) && declaration1 instanceof FirNamedFunctionSymbol && declaration2 instanceof FirNamedFunctionSymbol && FirConflictsHelpersKt.representsMainFunctionAllowingConflictingOverloads((FirNamedFunctionSymbol)declaration1, session) && FirConflictsHelpersKt.representsMainFunctionAllowingConflictingOverloads((FirNamedFunctionSymbol)declaration2, session);
    }

    private static final ConflictState getConflictState(FirDeclarationCollector<?> $this$getConflictState, FirBasedSymbol<?> declaration, FirBasedSymbol<?> conflicting) {
        boolean conflictingIsLowPriority;
        if (FirConflictsHelpersKt.isAtLeastOneExpect(declaration, conflicting) && !Intrinsics.areEqual((Object)declaration.getModuleData(), (Object)conflicting.getModuleData())) {
            return ConflictState.NoConflict;
        }
        boolean declarationIsLowPriority = FirAnnotationUtilsKt.hasLowPriorityAnnotation(declaration.getResolvedAnnotationsWithClassIds());
        if (declarationIsLowPriority != (conflictingIsLowPriority = FirAnnotationUtilsKt.hasLowPriorityAnnotation(conflicting.getResolvedAnnotationsWithClassIds()))) {
            return ConflictState.NoConflict;
        }
        if (!(declaration instanceof FirCallableSymbol) || !(conflicting instanceof FirCallableSymbol)) {
            return ConflictState.Conflict;
        }
        boolean declarationIsFinal = DeclarationUtilsKt.isEffectivelyFinal(declaration);
        boolean conflictingIsFinal = DeclarationUtilsKt.isEffectivelyFinal(conflicting);
        if (declarationIsFinal && conflictingIsFinal) {
            boolean declarationIsHidden = DeprecationUtilsKt.isDeprecationLevelHidden(declaration, $this$getConflictState.getSession$checkers());
            if (declarationIsHidden) {
                return ConflictState.NoConflict;
            }
            boolean conflictingIsHidden = DeprecationUtilsKt.isDeprecationLevelHidden(conflicting, $this$getConflictState.getSession$checkers());
            if (conflictingIsHidden) {
                return ConflictState.NoConflict;
            }
        }
        FirDeclarationOverloadabilityHelper overloadabilityHelper = FirDeclarationOverloadabilityHelperKt.getDeclarationOverloadabilityHelper($this$getConflictState.getSession$checkers());
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings($this$getConflictState.getSession$checkers()).supportsFeature(LanguageFeature.ContextParameters) ? FirConflictsHelpersKt.getConflictStateWithContextParameters(overloadabilityHelper, (FirCallableSymbol)declaration, (FirCallableSymbol)conflicting) : (overloadabilityHelper.isConflicting((FirCallableSymbol)declaration, (FirCallableSymbol)conflicting, false) ? ConflictState.Conflict : ConflictState.NoConflict);
    }

    private static final ConflictState getConflictStateWithContextParameters(FirDeclarationOverloadabilityHelper $this$getConflictStateWithContextParameters, FirCallableSymbol<?> declaration, FirCallableSymbol<?> conflicting) {
        ConflictState conflictState;
        if (!$this$getConflictStateWithContextParameters.isConflicting(declaration, conflicting, true)) {
            return ConflictState.NoConflict;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getConflictStateWithContextParameters.getContextParameterShadowing(declaration, conflicting).ordinal()]) {
            case 1: {
                conflictState = ConflictState.Conflict;
                break;
            }
            case 2: {
                conflictState = ConflictState.ContextParameterShadowing;
                break;
            }
            case 3: {
                conflictState = ConflictState.NoConflict;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return conflictState;
    }

    public static final void checkForLocalRedeclarations(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull List<? extends FirElement> elements) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.size() <= 1) {
            return;
        }
        ListMultimap<Name, FirBasedSymbol> multimap = new ListMultimap<Name, FirBasedSymbol>();
        for (FirElement firElement : elements) {
            Name name2;
            Pair pair;
            FirElement firElement2 = firElement;
            if (firElement2 instanceof FirProperty) {
                FirPureAbstractElement firPureAbstractElement;
                pair = Intrinsics.areEqual((Object)DeclarationAttributesKt.isReplSnippetDeclaration((FirDeclaration)firElement), (Object)true) && ((FirProperty)firElement).getDelegate() != null && ((FirProperty)firElement).getReceiverParameter() != null ? TuplesKt.to((Object)((FirProperty)firElement).getSymbol(), (Object)Name.identifier("" + ((firPureAbstractElement = ((FirProperty)firElement).getReceiverParameter()) != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null) + '.' + ((FirProperty)firElement).getName())) : TuplesKt.to((Object)((FirProperty)firElement).getSymbol(), (Object)((FirProperty)firElement).getName());
            } else if (firElement2 instanceof FirVariable) {
                pair = TuplesKt.to(((FirVariable)firElement).getSymbol(), (Object)((FirVariable)firElement).getName());
            } else {
                if (firElement2 instanceof FirOuterClassTypeParameterRef) continue;
                if (firElement2 instanceof FirTypeParameterRef) {
                    FirTypeParameterSymbol it = ((FirTypeParameterRef)firElement).getSymbol();
                    boolean bl = false;
                    pair = TuplesKt.to((Object)it, (Object)it.getName());
                } else {
                    pair = TuplesKt.to(null, null);
                }
            }
            Pair pair2 = pair;
            FirBasedSymbol symbol = (FirBasedSymbol)pair2.component1();
            Name name3 = name2 = (Name)pair2.component2();
            boolean bl = name3 != null ? !name3.isSpecial() : false;
            if (!bl) continue;
            FirBasedSymbol firBasedSymbol = symbol;
            Intrinsics.checkNotNull((Object)firBasedSymbol);
            multimap.put(name2, firBasedSymbol);
        }
        for (Name name4 : multimap.getKeys()) {
            List conflictingElements = (List)multimap.get(name4);
            if (conflictingElements.size() <= 1) continue;
            for (FirBasedSymbol conflictingElement : conflictingElements) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)conflictingElement.getSource(), FirErrors.INSTANCE.getREDECLARATION(), (Object)conflictingElements, null, 16, null);
            }
        }
    }

    private static final Unit groupTopLevelByName$lambda$2$0(DeclarationBuckets $group, FirDeclaration $declaration, FirConstructorSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)$group.getConstructors()).add(TuplesKt.to((Object)it, (Object)FirRedeclarationPresenter.INSTANCE.represent(it, ((FirClassLikeDeclaration)$declaration).getSymbol())));
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$0$0(FirDeclarationCollector $this_collectClassMembers, Map $functionDeclarations, FirTypeScope $unsubstitutedScope, FirClassSymbol $klass, FirNamedFunctionSymbol declaredFunction) {
        Intrinsics.checkNotNullParameter((Object)declaredFunction, (String)"declaredFunction");
        if (!FirConflictsHelpersKt.isCollectable(declaredFunction)) {
            return Unit.INSTANCE;
        }
        FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)declaredFunction, FirRedeclarationPresenter.INSTANCE.represent(declaredFunction), $functionDeclarations);
        $unsubstitutedScope.processFunctionsByName(declaredFunction.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$0$0$0(declaredFunction, $klass, $this_collectClassMembers, $functionDeclarations, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$0$0$0(FirNamedFunctionSymbol $declaredFunction, FirClassSymbol $klass, FirDeclarationCollector $this_collectClassMembers, Map $functionDeclarations, FirNamedFunctionSymbol anotherFunction) {
        Intrinsics.checkNotNullParameter((Object)anotherFunction, (String)"anotherFunction");
        if (!Intrinsics.areEqual((Object)anotherFunction, (Object)$declaredFunction) && FirConflictsHelpersKt.isCollectable(anotherFunction) && FirHelpersKt.isVisibleInClass(anotherFunction, $klass)) {
            FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)anotherFunction, FirRedeclarationPresenter.INSTANCE.represent(anotherFunction), $functionDeclarations);
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$0$1(FirClassSymbol $klass, FirDeclarationCollector $this_collectClassMembers, Map $functionDeclarations, FirConstructorSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (FirConflictsHelpersKt.isCollectable(it) && FirHelpersKt.isVisibleInClass(it, $klass)) {
            FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)it, FirRedeclarationPresenter.INSTANCE.represent(it, $klass), $functionDeclarations);
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$0$2(FirDeclarationCollector $this_collectClassMembers, Map $otherDeclarations, FirTypeScope $unsubstitutedScope, FirClassSymbol $klass, FirVariableSymbol declaredProperty) {
        Intrinsics.checkNotNullParameter((Object)declaredProperty, (String)"declaredProperty");
        if (!FirConflictsHelpersKt.isCollectable(declaredProperty)) {
            return Unit.INSTANCE;
        }
        FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)declaredProperty, FirRedeclarationPresenter.INSTANCE.represent(declaredProperty), $otherDeclarations);
        $unsubstitutedScope.processPropertiesByName(declaredProperty.getName(), arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$0$2$0(declaredProperty, $klass, $this_collectClassMembers, $otherDeclarations, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$0$2$0(FirVariableSymbol $declaredProperty, FirClassSymbol $klass, FirDeclarationCollector $this_collectClassMembers, Map $otherDeclarations, FirVariableSymbol anotherProperty) {
        Intrinsics.checkNotNullParameter((Object)anotherProperty, (String)"anotherProperty");
        if (!Intrinsics.areEqual((Object)anotherProperty, (Object)$declaredProperty) && FirConflictsHelpersKt.isCollectable(anotherProperty) && FirHelpersKt.isVisibleInClass(anotherProperty, $klass)) {
            FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)anotherProperty, FirRedeclarationPresenter.INSTANCE.represent(anotherProperty), $otherDeclarations);
        }
        return Unit.INSTANCE;
    }

    private static final void collectClassMembers$lambda$0$processClassifier(FirClassSymbol<?> $klass, FirDeclarationCollector<FirBasedSymbol<?>> $this_collectClassMembers, Map<String, Set<FirBasedSymbol<?>>> otherDeclarations, CheckerContext $this_with, Map<String, Set<FirFunctionSymbol<?>>> functionDeclarations, FirClassifierSymbol<?> it) {
        block6: {
            if (!FirConflictsHelpersKt.isCollectable((FirBasedSymbol)it) || !FirHelpersKt.isVisibleInClass((FirBasedSymbol)it, $klass)) {
                return;
            }
            if (it instanceof FirRegularClassSymbol) {
                FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)it, FirRedeclarationPresenter.INSTANCE.represent((FirRegularClassSymbol)it), otherDeclarations);
            } else if (it instanceof FirTypeAliasSymbol) {
                FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)it, FirRedeclarationPresenter.INSTANCE.represent((FirTypeAliasSymbol)it), otherDeclarations);
            }
            if (!(it instanceof FirClassLikeSymbol)) {
                return;
            }
            Pair<FirRegularClassSymbol, FirScope> pair = FirConflictsHelpersKt.expandedClassWithConstructorsScope($this_with, (FirClassLikeSymbol)it);
            if (pair == null) break block6;
            Pair<FirRegularClassSymbol, FirScope> pair2 = pair;
            boolean bl = false;
            FirRegularClassSymbol expandedClass = (FirRegularClassSymbol)pair2.component1();
            FirScope scopeWithConstructors = (FirScope)pair2.component2();
            if (expandedClass.getClassKind() != ClassKind.OBJECT) {
                scopeWithConstructors.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectClassMembers$lambda$0$processClassifier$3$0($this_collectClassMembers, it, functionDeclarations, arg_0)));
            }
        }
    }

    private static final Unit collectClassMembers$lambda$0$processClassifier$3$0(FirDeclarationCollector $this_collectClassMembers, FirClassifierSymbol $it, Map $functionDeclarations, FirConstructorSymbol constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        FirConflictsHelpersKt.collect($this_collectClassMembers, (FirBasedSymbol)constructor, FirRedeclarationPresenter.INSTANCE.represent(constructor, (FirClassLikeSymbol)$it), $functionDeclarations);
        return Unit.INSTANCE;
    }

    private static final Unit collectClassMembers$lambda$0$4(FirBasedSymbol $declaredClassifier, FirClassSymbol $klass, FirDeclarationCollector $this_collectClassMembers, Map $otherDeclarations, CheckerContext $this_with, Map $functionDeclarations, FirClassifierSymbol anotherClassifier) {
        Intrinsics.checkNotNullParameter((Object)anotherClassifier, (String)"anotherClassifier");
        if (!Intrinsics.areEqual((Object)anotherClassifier, (Object)$declaredClassifier)) {
            FirConflictsHelpersKt.collectClassMembers$lambda$0$processClassifier($klass, $this_collectClassMembers, $otherDeclarations, $this_with, $functionDeclarations, anotherClassifier);
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectConflictingLocalFunctionsFrom$lambda$1$0(FirDeclarationCollector $inspector, FirStatement $collectable, Map $functionDeclarations, FirConstructorSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirConflictsHelpersKt.collect($inspector, (FirBasedSymbol)it, FirRedeclarationPresenter.INSTANCE.represent(it, ((FirClassLikeDeclaration)$collectable).getSymbol()), $functionDeclarations);
        return Unit.INSTANCE;
    }

    private static final void collectTopLevel$lambda$0$collect(FirDeclarationCollector<FirBasedSymbol<?>> $this_collectTopLevel, FirFile $file, CheckerContext $this_with, Name declarationName, List<? extends Pair<? extends FirBasedSymbol<?>, String>> declarations2, FirBasedSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        for (Pair<FirBasedSymbol<?>, String> pair : declarations2) {
            FirBasedSymbol declaration = (FirBasedSymbol)pair.component1();
            String declarationPresentation = (String)pair.component2();
            FirConflictsHelpersKt.collectTopLevelConflict($this_collectTopLevel, declaration, declarationPresentation, $file, conflictingSymbol, conflictingPresentation, conflictingFile);
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker($this_with.getSession());
            if (firLookupTrackerComponent == null) continue;
            FirLookupTrackerComponentKt.recordNameLookup(firLookupTrackerComponent, declarationName, UtilsKt.getPackageFqName($file).asString(), declaration.getSource(), $file.getSource());
        }
    }

    static /* synthetic */ void collectTopLevel$lambda$0$collect$default(FirDeclarationCollector firDeclarationCollector, FirFile firFile, CheckerContext checkerContext, Name name2, List list, FirBasedSymbol firBasedSymbol, String string, FirFile firFile2, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            string = null;
        }
        if ((n2 & 0x80) != 0) {
            firFile2 = null;
        }
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collect(firDeclarationCollector, firFile, checkerContext, name2, list, firBasedSymbol, string, firFile2);
    }

    private static final void collectTopLevel$lambda$0$collectFromClassifierSource(DeclarationBuckets group, boolean groupHasSimpleFunctions, CheckerContext $this_with, FirDeclarationCollector<FirBasedSymbol<?>> $this_collectTopLevel, FirFile $file, Name declarationName, FirClassifierSymbol<?> conflictingSymbol, String conflictingPresentation, FirFile conflictingFile) {
        block3: {
            FirConflictsHelpersKt.collectTopLevel$lambda$0$collect($this_collectTopLevel, $file, $this_with, declarationName, group.getClassLikes(), (FirBasedSymbol)conflictingSymbol, conflictingPresentation, conflictingFile);
            FirConflictsHelpersKt.collectTopLevel$lambda$0$collect($this_collectTopLevel, $file, $this_with, declarationName, group.getProperties(), (FirBasedSymbol)conflictingSymbol, conflictingPresentation, conflictingFile);
            if (!groupHasSimpleFunctions) break block3;
            if (!(conflictingSymbol instanceof FirClassLikeSymbol)) {
                return;
            }
            Pair<FirRegularClassSymbol, FirScope> pair = FirConflictsHelpersKt.expandedClassWithConstructorsScope($this_with, (FirClassLikeSymbol)conflictingSymbol);
            if (pair != null) {
                Pair<FirRegularClassSymbol, FirScope> pair2 = pair;
                boolean bl = false;
                FirRegularClassSymbol expandedClass = (FirRegularClassSymbol)pair2.component1();
                FirScope scopeWithConstructors = (FirScope)pair2.component2();
                if (expandedClass.getClassKind() == ClassKind.OBJECT || expandedClass.getClassKind() == ClassKind.ENUM_ENTRY) {
                    return;
                }
                scopeWithConstructors.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> FirConflictsHelpersKt.collectTopLevel$lambda$0$collectFromClassifierSource$0$0(conflictingSymbol, group, $this_collectTopLevel, $file, $this_with, declarationName, arg_0)));
            }
        }
    }

    static /* synthetic */ void collectTopLevel$lambda$0$collectFromClassifierSource$default(DeclarationBuckets declarationBuckets, boolean bl, CheckerContext checkerContext, FirDeclarationCollector firDeclarationCollector, FirFile firFile, Name name2, FirClassifierSymbol firClassifierSymbol, String string, FirFile firFile2, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            string = null;
        }
        if ((n2 & 0x100) != 0) {
            firFile2 = null;
        }
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collectFromClassifierSource(declarationBuckets, bl, checkerContext, firDeclarationCollector, firFile, name2, firClassifierSymbol, string, firFile2);
    }

    private static final Unit collectTopLevel$lambda$0$collectFromClassifierSource$0$0(FirClassifierSymbol $conflictingSymbol, DeclarationBuckets $group, FirDeclarationCollector $this_collectTopLevel, FirFile $file, CheckerContext $this_with, Name $declarationName, FirConstructorSymbol constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        String ctorRepresentation = FirRedeclarationPresenter.INSTANCE.represent(constructor, (FirClassLikeSymbol)$conflictingSymbol);
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collect$default($this_collectTopLevel, $file, $this_with, $declarationName, $group.getSimpleFunctions(), constructor, ctorRepresentation, null, 128, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectTopLevel$lambda$0$1(DeclarationBuckets $group, FirDeclarationCollector $this_collectTopLevel, FirFile $file, CheckerContext $this_with, Name $declarationName, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collect$default($this_collectTopLevel, $file, $this_with, $declarationName, $group.getSimpleFunctions(), it, null, null, 192, null);
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collect$default($this_collectTopLevel, $file, $this_with, $declarationName, $group.getConstructors(), it, null, null, 192, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectTopLevel$lambda$0$2(DeclarationBuckets $group, boolean $groupHasSimpleFunctions, CheckerContext $this_with, FirDeclarationCollector $this_collectTopLevel, FirFile $file, Name $declarationName, FirClassifierSymbol symbol, ConeSubstitutor coneSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<unused var>");
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collectFromClassifierSource$default($group, $groupHasSimpleFunctions, $this_with, $this_collectTopLevel, $file, $declarationName, symbol, null, null, 384, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectTopLevel$lambda$0$5(DeclarationBuckets $group, FirDeclarationCollector $this_collectTopLevel, FirFile $file, CheckerContext $this_with, Name $declarationName, FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collect$default($this_collectTopLevel, $file, $this_with, $declarationName, $group.getClassLikes(), it, null, null, 192, null);
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collect$default($this_collectTopLevel, $file, $this_with, $declarationName, $group.getProperties(), it, null, null, 192, null);
        FirConflictsHelpersKt.collectTopLevel$lambda$0$collect$default($this_collectTopLevel, $file, $this_with, $declarationName, $group.getExtensionProperties(), it, null, null, 192, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ConflictState.values().length];
            try {
                nArray[ConflictState.Conflict.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConflictState.ContextParameterShadowing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConflictState.NoConflict.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FirDeclarationOverloadabilityHelper.ContextParameterShadowing.values().length];
            try {
                nArray[FirDeclarationOverloadabilityHelper.ContextParameterShadowing.BothWays.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirDeclarationOverloadabilityHelper.ContextParameterShadowing.Shadowing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirDeclarationOverloadabilityHelper.ContextParameterShadowing.None.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

