/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.Objects;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ClassImplementationSnapshot
extends ImplementationSnapshot {
    private final HashCode classLoaderHash;

    public ClassImplementationSnapshot(String classIdentifier, HashCode classLoaderHash) {
        super(classIdentifier);
        this.classLoaderHash = classLoaderHash;
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)ClassImplementationSnapshot.class.getName());
        hasher.putString((CharSequence)this.classIdentifier);
        hasher.putHash(this.classLoaderHash);
    }

    @Override
    protected boolean isSameSnapshot(@Nullable Object o) {
        return this.equals(o);
    }

    @Override
    public @NonNull HashCode getClassLoaderHash() {
        return this.classLoaderHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassImplementationSnapshot that = (ClassImplementationSnapshot)o;
        return this.classIdentifier.equals(that.classIdentifier) && this.classLoaderHash.equals((Object)that.classLoaderHash);
    }

    public int hashCode() {
        return Objects.hash(this.classIdentifier, this.classLoaderHash);
    }

    public String toString() {
        return this.classIdentifier + "@" + this.classLoaderHash;
    }
}

