/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.awt.Container;
import java.util.ArrayList;
import tim.prune.config.Config;
import tim.prune.data.MarkingData;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionDialog;
import tim.prune.function.compress.MethodList;
import tim.prune.function.compress.MethodPanel;
import tim.prune.function.compress.MethodPanelContainer;
import tim.prune.function.compress.ParameterValues;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.CompressionMethod;

public class PanelController
implements MethodPanelContainer {
    private final Track _track;
    private final CompressionDialog _parentDialog;
    private final ArrayList<MethodPanel> _panels = new ArrayList();
    private final Container _container;
    private ParameterValues _values = null;

    public PanelController(Track track, CompressionDialog compressionDialog, Container container) {
        this._track = track;
        this._parentDialog = compressionDialog;
        this._container = container;
    }

    public int getNumPanels() {
        return this._panels.size();
    }

    public void addMethod(Config config) {
        MethodPanel methodPanel2;
        for (MethodPanel methodPanel2 : this._panels) {
            if (methodPanel2.hasMethodSelected()) continue;
            return;
        }
        methodPanel2 = new MethodPanel(this._panels.size(), this, this._values, config);
        this.addPanel(methodPanel2);
    }

    public void addMethod(CompressionMethod compressionMethod, Config config) {
        MethodPanel methodPanel = new MethodPanel(this._panels.size(), this, this._values, config);
        methodPanel.setMethod(compressionMethod);
        this.addPanel(methodPanel);
    }

    public void addDummyPanels() {
        int n = 0;
        while (n < 5) {
            this.addPanel(new MethodPanel(this._panels.size(), this, this._values, null));
            ++n;
        }
    }

    @Override
    public void movePanelUp(int n) {
        this.swapPanels(n - 1, n);
    }

    @Override
    public void movePanelDown(int n) {
        this.swapPanels(n, n + 1);
    }

    private void swapPanels(int n, int n2) {
        if (n < 0 || n2 >= this._panels.size()) {
            return;
        }
        MethodPanel.swapPanels(this._panels.get(n), this._panels.get(n2));
        this.recalculateAll();
    }

    private void addPanel(MethodPanel methodPanel) {
        this._panels.add(methodPanel);
        this._container.add(methodPanel);
        this._container.revalidate();
        this._container.repaint();
    }

    @Override
    public void deletePanel(int n) {
        if (n < 0 || this._panels.size() <= 1 || n >= this._panels.size()) {
            return;
        }
        int n2 = n + 1;
        while (n2 < this._panels.size()) {
            this.movePanelUp(n2);
            ++n2;
        }
        MethodPanel methodPanel = this._panels.get(this._panels.size() - 1);
        this._panels.remove(this._panels.size() - 1);
        this._container.remove(methodPanel);
        this._container.revalidate();
        this._container.repaint();
    }

    public void deleteAllPanels() {
        while (!this._panels.isEmpty()) {
            this._container.remove(0);
            this._panels.remove(0);
        }
        this._container.revalidate();
        this._container.repaint();
    }

    public void refresh() {
        for (MethodPanel methodPanel : this._panels) {
            methodPanel.refresh();
        }
    }

    @Override
    public MarkingData recalculateAll() {
        int n = 0;
        MarkingData markingData = new MarkingData(this._track);
        for (MethodPanel methodPanel : this._panels) {
            CompressionMethod compressionMethod;
            CompressionMethod compressionMethod2 = compressionMethod = methodPanel == null ? null : methodPanel.getCompressionMethod();
            if (compressionMethod == null) continue;
            TrackDetails trackDetails = new TrackDetails(this._track);
            int n2 = compressionMethod.preview(this._track, trackDetails, markingData);
            methodPanel.showNumDeleted(n2);
            n += n2;
        }
        this._parentDialog.informNumPointsDeleted(n);
        return markingData;
    }

    public MethodList getMethodList() {
        MethodList methodList = new MethodList();
        for (MethodPanel methodPanel : this._panels) {
            CompressionMethod compressionMethod;
            CompressionMethod compressionMethod2 = compressionMethod = methodPanel == null ? null : methodPanel.getCompressionMethod();
            if (compressionMethod == null) continue;
            methodList.add(compressionMethod);
        }
        return methodList;
    }

    public void setParameterValues(ParameterValues parameterValues) {
        this._values = parameterValues;
    }
}

