/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StringEditorTableFactory;
import org.jkiss.utils.CommonUtils;

public class StringEditorTableUtils {
    @NotNull
    public static Table createEditableList(@NotNull Composite parent, @NotNull String name, @Nullable List<String> values, @Nullable DBPImage icon, @Nullable IContentProposalProvider proposalProvider) {
        return StringEditorTableUtils.createCustomEditableList(parent, name, values, new StringEditorTableFactory.StringValuesManager(icon), proposalProvider, false);
    }

    @NotNull
    public static <T> Table createCustomEditableList(@NotNull Composite parent, @NotNull String name, @Nullable List<T> values, @NotNull TableValuesManager<T> valuesManager, @Nullable IContentProposalProvider proposalProvider, boolean withReordering) {
        Composite group = UIUtils.createTitledComposite(parent, name, 2, 1808);
        StringEditorTableFactory<T> stringEditorTableFactory = new StringEditorTableFactory<T>(group, values, valuesManager, proposalProvider, withReordering);
        return stringEditorTableFactory.createTable();
    }

    public static void replaceAllStringValues(@NotNull Table valueTable, @Nullable List<String> values, @Nullable DBPImage icon) {
        valueTable.removeAll();
        if (!CommonUtils.isEmpty(values)) {
            for (String value : values) {
                TableItem tableItem = new TableItem(valueTable, 16384);
                tableItem.setText(value);
                StringEditorTableUtils.setCustomValue(tableItem, value);
                if (icon == null) continue;
                tableItem.setImage(DBeaverIcons.getImage(icon));
            }
        }
    }

    @NotNull
    public static List<String> collectStringValues(@NotNull Table table) {
        ArrayList<String> values = new ArrayList<String>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String value = item.getText().trim();
            if (!value.isEmpty()) {
                values.add(value);
            }
            ++n2;
        }
        return values;
    }

    @NotNull
    public static <T> List<T> collectCustomValues(@NotNull Table table) {
        ArrayList<T> values = new ArrayList<T>(table.getItemCount());
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            T value = StringEditorTableUtils.getCustomValue(item);
            if (value != null) {
                values.add(value);
            }
            ++n2;
        }
        return values;
    }

    @NotNull
    private static <T> T getCustomValue(@NotNull TableItem tableItem) {
        return (T)tableItem.getData("CUSTOM_EDITABLE_LIST_VALUE");
    }

    private static <T> void setCustomValue(@NotNull TableItem tableItem, @NotNull T value) {
        tableItem.setData("CUSTOM_EDITABLE_LIST_VALUE", value);
    }

    public static interface TableValuesManager<T> {
        @Nullable
        public DBPImage getIcon(@Nullable T var1);

        @NotNull
        public String getString(@Nullable T var1);

        @NotNull
        public Boolean isEditable(@Nullable T var1);

        @Nullable
        public T prepareNewValue(@Nullable T var1, @Nullable String var2);
    }
}

