/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai.dto;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.AIUsage;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesPrompt;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesReasoning;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesStreamOptions;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesText;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesUsage;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAITool;

public abstract class OAIResponsesBase {
    public String[] include;
    @SerializedName(value="max_output_tokens")
    public Integer maxOutputTokens;
    @SerializedName(value="max_tool_calls")
    public Integer maxToolCalls;
    public Map<String, String> metadata;
    public String model;
    @SerializedName(value="parallel_tool_calls")
    public Boolean parallel_tool_calls;
    @SerializedName(value="previous_response_id")
    public String previous_response_id;
    @SerializedName(value="prompt")
    public OAIResponsesPrompt prompt;
    @SerializedName(value="prompt_cache_key")
    public String promptCacheKey;
    @SerializedName(value="reasoning")
    public OAIResponsesReasoning reasoning;
    @SerializedName(value="safety_identifier")
    public String safetyIdentifier;
    @SerializedName(value="service_tier")
    public String serviceTier;
    @SerializedName(value="store")
    public Boolean store;
    @SerializedName(value="stream")
    public Boolean stream;
    @SerializedName(value="stream_options")
    public OAIResponsesStreamOptions stream_options;
    @SerializedName(value="temperature")
    public Double temperature;
    @SerializedName(value="text")
    public OAIResponsesText text;
    @SerializedName(value="tool_choice")
    public String toolChoice;
    @SerializedName(value="tools")
    public List<OAITool> tools;
    @SerializedName(value="top_logprobs")
    public Integer topLogprobs;
    @SerializedName(value="top_p")
    public Float topP;
    @SerializedName(value="truncation")
    public String truncation;
    @SerializedName(value="usage")
    @Nullable
    public OAIResponsesUsage usage;

    @Nullable
    public AIUsage getAIUsage() {
        if (this.usage == null) {
            return null;
        }
        return new AIUsage(this.usage.inputTokens(), this.usage.inputTokensDetails() != null ? this.usage.inputTokensDetails().cachedTokens() : 0, this.usage.outputTokens(), this.usage.outputTokensDetails() != null ? this.usage.outputTokensDetails().reasoningTokens() : 0);
    }
}

