/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzer;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzerParameters;
import org.jkiss.dbeaver.model.lsm.sql.dialect.LSMDialectRegistry;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryExpressionMapper;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionDummyContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionRealContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTupleRefEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryObjectDropModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableAlterModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableCreateModel;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableDropModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryCallModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryDeleteModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryInsertModel;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryUpdateModel;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueConstantExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueFlattenedExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueFunctionExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueIndexingExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueMemberExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueSubqueryExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueTypeCastExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueVariableExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMErrorListener;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMSkippingErrorListener;
import org.jkiss.dbeaver.model.stm.STMSource;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;

public class SQLQueryModelRecognizer {
    private static final Log log = Log.getLog(SQLQueryModelRecognizer.class);
    private final Set<SQLQuerySymbolEntry> symbolEntries = new HashSet<SQLQuerySymbolEntry>();
    private final TreeMap<Integer, SQLQueryLexicalScopeItem> lexicalItems = new TreeMap();
    private final SQLQueryRecognitionContext recognitionContext;
    private final DBCExecutionContext executionContext;
    private final Set<String> reservedWords;
    private final SQLDialect dialect;
    private final LinkedList<SQLQueryLexicalScope> currentLexicalScopes = new LinkedList();
    @NotNull
    private static final Set<String> columnNameListWrapperNames = Set.of(STMKnownRuleNames.correspondingSpec, STMKnownRuleNames.referencedTableAndColumns, STMKnownRuleNames.correlationSpecification, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.namedColumnsJoin, STMKnownRuleNames.joinSpecification, STMKnownRuleNames.naturalJoinTerm, STMKnownRuleNames.unionTerm, STMKnownRuleNames.exceptTerm, STMKnownRuleNames.intersectTerm, STMKnownRuleNames.uniqueConstraintDefinition, STMKnownRuleNames.createViewStatement, STMKnownRuleNames.insertColumnsAndSource, STMKnownRuleNames.referenceColumnList, STMKnownRuleNames.referencingColumns, STMKnownRuleNames.derivedColumnList, STMKnownRuleNames.joinColumnList, STMKnownRuleNames.correspondingColumnList, STMKnownRuleNames.uniqueColumnList, STMKnownRuleNames.viewColumnList, STMKnownRuleNames.insertColumnList);
    private static final Set<String> identifierDirectWrapperNames = Set.of(STMKnownRuleNames.correlationName, STMKnownRuleNames.authorizationIdentifier, STMKnownRuleNames.columnName, STMKnownRuleNames.queryName);
    private static final Set<String> tableNameContainers = Set.of(STMKnownRuleNames.selectTargetItem, STMKnownRuleNames.referencedTableAndColumns, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.explicitTable, STMKnownRuleNames.createTableStatement, STMKnownRuleNames.createViewStatement, STMKnownRuleNames.alterTableStatement, STMKnownRuleNames.dropTableStatement, STMKnownRuleNames.dropViewStatement, STMKnownRuleNames.deleteStatement, STMKnownRuleNames.insertStatement, STMKnownRuleNames.updateStatement);
    private static final Set<String> actualTableNameContainers = Set.of(STMKnownRuleNames.tableName);
    private static final Set<String> qualifiedNameDirectWrapperNames = Set.of(STMKnownRuleNames.characterSetSpecification, STMKnownRuleNames.characterSetName, STMKnownRuleNames.schemaName, STMKnownRuleNames.tableName, STMKnownRuleNames.constraintName);
    private static final Set<String> knownValueExpressionRootNames = Set.of(STMKnownRuleNames.valueExpression, STMKnownRuleNames.valueExpressionAtom, STMKnownRuleNames.searchCondition, STMKnownRuleNames.havingClause, STMKnownRuleNames.whereClause, STMKnownRuleNames.groupByClause, STMKnownRuleNames.orderByClause, STMKnownRuleNames.rowValueConstructor, STMKnownRuleNames.defaultClause, STMKnownRuleNames.checkConstraintDefinition);
    private static final Set<String> knownRecognizableValueExpressionNames = Set.of(STMKnownRuleNames.functionCallExpression, STMKnownRuleNames.subquery, STMKnownRuleNames.columnReference, STMKnownRuleNames.valueReference, STMKnownRuleNames.variableExpression, STMKnownRuleNames.truthValue, STMKnownRuleNames.unsignedNumericLiteral, STMKnownRuleNames.signedNumericLiteral, STMKnownRuleNames.characterStringLiteral, STMKnownRuleNames.datetimeLiteral, STMKnownRuleNames.columnIndex);

    private SQLQueryModelRecognizer(@NotNull SQLQueryRecognitionContext recognitionContext) {
        this.recognitionContext = recognitionContext;
        this.executionContext = recognitionContext.getExecutionContext();
        this.dialect = recognitionContext.getDialect();
        this.reservedWords = new HashSet<String>(this.dialect.getReservedWords());
    }

    @Nullable
    private SQLQueryModel recognizeQuery(@NotNull String text) {
        SQLQueryModelContent contents;
        STMSource querySource = STMSource.fromString((String)text);
        LSMAnalyzer analyzer = LSMDialectRegistry.getInstance().getAnalyzerFactoryForDialect(this.dialect).createAnalyzer(LSMAnalyzerParameters.forDialect((SQLDialect)this.dialect, (SQLSyntaxManager)this.recognitionContext.getSyntaxManager()));
        STMTreeRuleNode tree = analyzer.parseSqlQueryTree(querySource, (STMErrorListener)new STMSkippingErrorListener());
        if (tree == null || tree.start == tree.stop && !LSMInspections.prepareOffquerySyntaxInspection().predictedTokenIds().contains(tree.start.getType())) {
            return tree == null ? null : new SQLQueryModel((STMTreeNode)tree, null, Collections.emptySet(), Collections.emptyList());
        }
        SQLQueryConnectionContext connectionContext = this.prepareConnectionContext((STMTreeNode)tree);
        SQLQueryRowsSourceContext rootRowsContext = new SQLQueryRowsSourceContext(connectionContext);
        STMTreeNode queryNode = tree.findFirstNonErrorChild();
        if (queryNode == null) {
            return new SQLQueryModel((STMTreeNode)tree, null, Collections.emptySet(), Collections.emptyList());
        }
        block0 : switch (queryNode.getNodeKindId()) {
            case 2: {
                SQLQueryModelContent sQLQueryModelContent;
                STMTreeNode stmtBodyNode = queryNode.findLastNonErrorChild();
                if (stmtBodyNode == null) {
                    sQLQueryModelContent = null;
                    break;
                }
                switch (stmtBodyNode.getNodeKindId()) {
                    case 244: {
                        sQLQueryModelContent = SQLQueryDeleteModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                    case 245: {
                        sQLQueryModelContent = SQLQueryInsertModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                    case 249: {
                        sQLQueryModelContent = SQLQueryUpdateModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                }
                sQLQueryModelContent = this.collectQueryExpression((STMTreeNode)tree);
                break;
            }
            case 207: {
                SQLQueryModelContent sQLQueryModelContent;
                STMTreeNode stmtBodyNode = queryNode.findFirstNonErrorChild();
                if (stmtBodyNode == null) {
                    sQLQueryModelContent = null;
                    break;
                }
                switch (stmtBodyNode.getNodeKindId()) {
                    case 214: {
                        sQLQueryModelContent = SQLQueryTableCreateModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                    case 220: {
                        sQLQueryModelContent = null;
                        break block0;
                    }
                    case 236: {
                        sQLQueryModelContent = SQLQueryTableDropModel.recognize(this, stmtBodyNode, false);
                        break block0;
                    }
                    case 237: {
                        sQLQueryModelContent = SQLQueryTableDropModel.recognize(this, stmtBodyNode, true);
                        break block0;
                    }
                    case 238: {
                        sQLQueryModelContent = SQLQueryObjectDropModel.recognize(this, stmtBodyNode, RelationalObjectType.TYPE_PROCEDURE, Collections.emptySet());
                        break block0;
                    }
                    case 225: {
                        sQLQueryModelContent = SQLQueryTableAlterModel.recognize(this, stmtBodyNode);
                        break block0;
                    }
                }
                sQLQueryModelContent = null;
                break;
            }
            case 241: {
                SQLQueryModelContent sQLQueryModelContent;
                STMTreeNode stmtBodyNode = queryNode.findFirstNonErrorChild();
                if (stmtBodyNode == null) {
                    sQLQueryModelContent = null;
                    break;
                }
                sQLQueryModelContent = this.collectQueryExpression((STMTreeNode)tree);
                break;
            }
            case 274: {
                SQLQueryModelContent sQLQueryModelContent = SQLQueryCallModel.recognize(this, queryNode, RelationalObjectType.TYPE_PROCEDURE);
                break;
            }
            default: {
                SQLQueryModelContent sQLQueryModelContent = contents = null;
            }
        }
        if (contents != null) {
            SQLQueryModel model = new SQLQueryModel((STMTreeNode)tree, contents, this.symbolEntries, this.lexicalItems.values().stream().toList());
            model.resolveRelations(rootRowsContext, this.recognitionContext);
            for (SQLQuerySymbolEntry symbolEntry : this.symbolEntries) {
                if (!symbolEntry.isNotClassified() || !this.reservedWords.contains(symbolEntry.getRawName().toUpperCase())) continue;
                symbolEntry.getSymbol().setSymbolClass(SQLQuerySymbolClass.RESERVED);
            }
            return model;
        }
        Predicate<SQLQuerySymbolEntry> tryFallbackForStringLiteral = s -> {
            boolean forced;
            String rawString = s.getRawName();
            SQLQuerySymbolClass forcedClass = this.dialect.isQuotedString(rawString) ? SQLQuerySymbolClass.STRING : SQLQueryModelRecognizer.tryFallbackSymbolForStringLiteral(this.dialect, s, false);
            boolean bl = forced = forcedClass != null;
            if (forced) {
                s.getSymbol().setSymbolClass(forcedClass);
            }
            return forced;
        };
        this.classifySymbolsWithoutModel(connectionContext, tree, tryFallbackForStringLiteral, rootRowsContext);
        return new SQLQueryModel((STMTreeNode)tree, null, this.symbolEntries, this.lexicalItems.values().stream().toList());
    }

    private void classifySymbolsWithoutModel(@NotNull SQLQueryConnectionContext connectionContext, @NotNull STMTreeRuleNode tree, @NotNull Predicate<SQLQuerySymbolEntry> tryFallbackForStringLiteral, @NotNull SQLQueryRowsSourceContext rootRowsContext) {
        SQLQuerySymbolOrigin.DbObjectRef objectNameOrigin = new SQLQuerySymbolOrigin.DbObjectRef(new SQLQueryRowsSourceContext(connectionContext), Set.of(RelationalObjectType.TYPE_UNKNOWN), true);
        HashMap allTableNames = new HashMap();
        HashSet allTableAliases = new HashSet();
        LinkedList allMaybeColumns = new LinkedList();
        LinkedList allValueRefs = new LinkedList();
        this.traverseForIdentifiers((STMTreeNode)tree, allMaybeColumns::add, entityName -> {
            if (entityName.isNotClassified() || !tryFallbackForStringLiteral.test(entityName.parts.getLast())) {
                if (!this.recognitionContext.useRealMetadata() || connectionContext.isDummy()) {
                    for (SQLQuerySymbolEntry part : entityName.parts) {
                        if (part == null) continue;
                        part.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE);
                    }
                } else {
                    SQLQuerySemanticUtils.performPartialResolution(rootRowsContext, this.recognitionContext, entityName, objectNameOrigin, SQLQuerySymbolOrigin.DbObjectFilterMode.DEFAULT, SQLQuerySymbolClass.OBJECT);
                }
            }
            allTableNames.put(entityName, entityName);
        }, allValueRefs::addLast, aliasEntry -> {
            aliasEntry.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE_ALIAS);
            allTableAliases.add(aliasEntry.getName().toLowerCase());
        }, true);
        Iterator iterator = allValueRefs.iterator();
        while (iterator.hasNext()) {
            List<SQLQuerySymbolEntry> tail;
            SQLQueryComplexName valueRef;
            SQLQueryComplexName prefix = valueRef = (SQLQueryComplexName)iterator.next();
            while (prefix != null && !prefix.parts.isEmpty()) {
                SQLQueryComplexName table = (SQLQueryComplexName)allTableNames.get(prefix);
                if (table != null) {
                    int i = 0;
                    while (i < prefix.parts.size()) {
                        SQLQuerySymbolEntry a = prefix.parts.get(i);
                        SQLQuerySymbolEntry b = table.parts.get(i);
                        if (a != null && b != null) {
                            a.setDefinition(b.getDefinition());
                            a.setOrigin(b.getOrigin());
                            if (a.isNotClassified()) {
                                a.getSymbol().setSymbolClass(b.getSymbolClass());
                            }
                        }
                        ++i;
                    }
                    break;
                }
                prefix = prefix.trimEnd();
            }
            if (prefix == null && valueRef.parts.size() > 1 && valueRef.parts.getFirst() != null && allTableAliases.contains(valueRef.parts.getFirst().getName().toLowerCase())) {
                valueRef.parts.getFirst().getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE_ALIAS);
                tail = valueRef.parts.subList(1, valueRef.parts.size());
            } else {
                tail = valueRef.parts.subList(prefix == null ? 0 : prefix.parts.size(), valueRef.parts.size());
            }
            for (SQLQuerySymbolEntry column : tail) {
                if (column == null) continue;
                column.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
            }
        }
        for (SQLQuerySymbolEntry maybeColumn : allMaybeColumns) {
            if (!maybeColumn.isNotClassified() || tryFallbackForStringLiteral.test(maybeColumn)) continue;
            maybeColumn.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
        }
    }

    private void traverseForIdentifiers(@NotNull STMTreeNode root, @NotNull Consumer<SQLQuerySymbolEntry> columnAction, @NotNull Consumer<SQLQueryComplexName> entityAction, @NotNull Consumer<SQLQueryComplexName> valueRefAction, @NotNull Consumer<SQLQuerySymbolEntry> entityAliasAction, boolean forceUnquotted) {
        List refs = STMUtils.expandSubtree((STMTreeNode)root, null, Set.of(STMKnownRuleNames.columnReference, STMKnownRuleNames.columnName, STMKnownRuleNames.tableName, STMKnownRuleNames.correlationName));
        block6: for (STMTreeNode ref : refs) {
            switch (ref.getNodeKindId()) {
                case 33: {
                    SQLQuerySymbolEntry columnName = this.collectIdentifier(ref, forceUnquotted, null);
                    if (columnName == null) continue block6;
                    columnAction.accept(columnName);
                    break;
                }
                case 87: {
                    SQLQueryValueReferenceExpression valueRef;
                    SQLQueryValueExpression expr = this.collectColumnReferenceExpression(ref, false);
                    if (expr instanceof SQLQueryValueTupleReferenceExpression) {
                        SQLQueryValueTupleReferenceExpression tupleRef = (SQLQueryValueTupleReferenceExpression)expr;
                        entityAction.accept(tupleRef.getTableName());
                        break;
                    }
                    if (expr instanceof SQLQueryValueColumnReferenceExpression) {
                        SQLQueryValueColumnReferenceExpression columnRef = (SQLQueryValueColumnReferenceExpression)expr;
                        columnAction.accept(columnRef.getColumnName());
                        break;
                    }
                    if (!(expr instanceof SQLQueryValueReferenceExpression) || (valueRef = (SQLQueryValueReferenceExpression)expr).getName() == null) continue block6;
                    for (SQLQuerySymbolEntry c : valueRef.getName().parts) {
                        if (c == null) continue;
                        columnAction.accept(c);
                    }
                    valueRefAction.accept(valueRef.getName());
                    break;
                }
                case 45: {
                    SQLQueryComplexName tableName = this.collectTableName(ref, forceUnquotted);
                    if (tableName == null) continue block6;
                    entityAction.accept(tableName);
                    break;
                }
                case 95: {
                    SQLQuerySymbolEntry entityAlias = this.collectIdentifier(ref, forceUnquotted, null);
                    if (entityAlias == null) continue block6;
                    entityAliasAction.accept(entityAlias);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + ref.getNodeName());
                }
            }
        }
    }

    @NotNull
    private SQLQueryConnectionContext prepareConnectionContext(@NotNull STMTreeNode root) {
        SQLDialect sQLDialect;
        if (this.recognitionContext.useRealMetadata() && this.executionContext != null && this.executionContext.getDataSource() instanceof DBSObjectContainer && (sQLDialect = this.executionContext.getDataSource().getSQLDialect()) instanceof BasicSQLDialect) {
            Function<SQLQueryRowsSourceModel, List<SQLQueryResultPseudoColumn>> rowsetPseudoColumns;
            BasicSQLDialect basicSQLDialect = (BasicSQLDialect)sQLDialect;
            Map<String, SQLQueryResultPseudoColumn> globalPseudoColumns = Stream.of(basicSQLDialect.getGlobalVariables()).map(v -> new SQLQueryResultPseudoColumn(new SQLQuerySymbol(v.name()), null, null, SQLQueryExprType.forPredefined(v.type()), DBDPseudoAttribute.PropagationPolicy.GLOBAL_VARIABLE, v.description())).collect(Collectors.toMap(c -> c.symbol.getName(), c -> c));
            DBPDataSource dBPDataSource = this.executionContext.getDataSource();
            if (dBPDataSource instanceof DBDPseudoAttributeContainer) {
                DBDPseudoAttributeContainer pac = (DBDPseudoAttributeContainer)dBPDataSource;
                try {
                    DBDPseudoAttribute[] pc = pac.getAllPseudoAttributes(this.recognitionContext.getMonitor());
                    List<DBDPseudoAttribute> rowsetsPc = Stream.of(pc).filter(a -> a.getPropagationPolicy().providedByRowset).toList();
                    rowsetPseudoColumns = rowsetsPc.isEmpty() ? s -> Collections.emptyList() : s -> SQLQuerySemanticUtils.prepareResultPseudoColumnsList(this.dialect, s, null, rowsetsPc.stream());
                }
                catch (DBException e) {
                    this.recognitionContext.appendError(root, "Failed to obtain global pseudo-columns information", e);
                    rowsetPseudoColumns = s -> Collections.emptyList();
                }
            } else {
                rowsetPseudoColumns = s -> Collections.emptyList();
            }
            return new SQLQueryConnectionRealContext(this.dialect, new SQLIdentifierDetector(this.dialect), this.executionContext, this.recognitionContext.validateFunctions(), globalPseudoColumns, rowsetPseudoColumns);
        }
        HashSet<String> allColumnNames = new HashSet<String>();
        HashSet<List<String>> allTableNames = new HashSet<List<String>>();
        this.traverseForIdentifiers(root, columnName -> {
            boolean bl = allColumnNames.add(columnName.getName());
        }, entityName -> {
            boolean bl = allTableNames.add(entityName.stringParts);
        }, valueRef -> {}, columnAlias -> {}, true);
        this.symbolEntries.clear();
        return new SQLQueryConnectionDummyContext(this.dialect, allColumnNames, allTableNames);
    }

    @NotNull
    public SQLQueryRowsSourceModel collectQueryExpression(@NotNull STMTreeNode tree) {
        SQLQueryExpressionMapper queryExpressionMapper = new SQLQueryExpressionMapper(this);
        return (SQLQueryRowsSourceModel)queryExpressionMapper.translate(tree);
    }

    @NotNull
    public List<SQLQuerySymbolEntry> collectColumnNameList(@NotNull STMTreeNode node) {
        if (!node.getNodeName().equals(STMKnownRuleNames.columnNameList)) {
            if (!columnNameListWrapperNames.contains(node.getNodeName())) {
                log.debug((Object)("columnNameList (or its wrapper) expected while facing with " + node.getNodeName()));
                return Collections.emptyList();
            }
            List actual = STMUtils.expandSubtree((STMTreeNode)node, columnNameListWrapperNames, Set.of(STMKnownRuleNames.columnNameList));
            switch (actual.size()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    node = (STMTreeNode)actual.get(0);
                    break;
                }
                default: {
                    log.debug((Object)("Ambiguous columnNameList collection at " + node.getNodeName()));
                    return Collections.emptyList();
                }
            }
        }
        List<SQLQuerySymbolEntry> result = node.findChildrenOfName(STMKnownRuleNames.columnName).stream().map(n -> this.collectIdentifier((STMTreeNode)n, null)).toList();
        return result;
    }

    @Nullable
    public SQLQuerySymbolEntry collectIdentifier(@NotNull STMTreeNode node, @Nullable STMTreeNode periodNode) {
        return this.collectIdentifier(node, false, periodNode);
    }

    @Nullable
    private SQLQuerySymbolEntry collectIdentifier(@NotNull STMTreeNode node, boolean forceUnquotted, @Nullable STMTreeNode periodNode) {
        Token t;
        STMTreeNode identifierNode;
        STMTreeNode sTMTreeNode = identifierNode = identifierDirectWrapperNames.contains(node.getNodeName()) ? node.findFirstChildOfName(STMKnownRuleNames.identifier) : node;
        if (identifierNode == null) {
            return null;
        }
        if (!identifierNode.getNodeName().equals(STMKnownRuleNames.identifier)) {
            log.debug((Object)("identifier expected while facing with " + identifierNode.getNodeName()));
            return null;
        }
        STMTreeNode actualIdentifierNode = identifierNode.findLastChildOfName(STMKnownRuleNames.actualIdentifier);
        if (actualIdentifierNode == null) {
            return null;
        }
        STMTreeNode identifierTextNode = actualIdentifierNode.findFirstNonErrorChild();
        if (identifierTextNode == null) {
            return null;
        }
        SQLQueryMemberAccessEntry memberAccessEntry = periodNode == null ? null : this.registerScopeItem(new SQLQueryMemberAccessEntry(periodNode));
        String rawIdentifierString = identifierTextNode.getTextContent();
        Object object = identifierTextNode.getPayload();
        if (object instanceof Token && (t = (Token)object).getType() == 219) {
            SQLQuerySymbolEntry entry = this.registerSymbolEntry(identifierTextNode, rawIdentifierString, rawIdentifierString, memberAccessEntry);
            return entry;
        }
        String actualIdentifierString = SQLUtils.identifierToCanonicalForm((SQLDialect)this.dialect, (String)rawIdentifierString, (boolean)forceUnquotted, (boolean)false);
        return this.registerSymbolEntry(identifierTextNode, actualIdentifierString, rawIdentifierString, memberAccessEntry);
    }

    @NotNull
    private SQLQuerySymbolEntry registerSymbolEntry(@NotNull STMTreeNode syntaxNode, @NotNull String name, @NotNull String rawName, @Nullable SQLQueryMemberAccessEntry memberAccessEntry) {
        SQLQuerySymbolEntry entry = new SQLQuerySymbolEntry(syntaxNode, name, rawName, memberAccessEntry);
        this.symbolEntries.add(entry);
        this.registerScopeItem(entry);
        return entry;
    }

    @NotNull
    public SQLQueryRowsTableDataModel collectTableReference(@NotNull STMTreeNode node, boolean forDDL) {
        return new SQLQueryRowsTableDataModel(node, this.collectTableName(node), forDDL);
    }

    @Nullable
    public SQLQueryComplexName collectTableName(@NotNull STMTreeNode node) {
        return this.collectTableName(node, false);
    }

    @Nullable
    private SQLQueryComplexName collectTableName(@NotNull STMTreeNode node, boolean forceUnquotted) {
        List actual = STMUtils.expandSubtree((STMTreeNode)node, tableNameContainers, actualTableNameContainers);
        if (actual.size() > 1) {
            log.debug((Object)("Ambiguous tableName collection at " + node.getNodeName()));
        }
        if (actual.isEmpty()) {
            return null;
        }
        return this.collectQualifiedName((STMTreeNode)actual.getFirst(), forceUnquotted);
    }

    @Nullable
    public SQLQueryComplexName collectQualifiedName(@NotNull STMTreeNode node) {
        return this.collectQualifiedName(node, false);
    }

    @Nullable
    private SQLQueryComplexName collectQualifiedName(@NotNull STMTreeNode node, boolean forceUnquotted) {
        List<Object> nameParts;
        int invalidPartsCount;
        STMTreeNode qualifiedNameNode;
        STMTreeNode sTMTreeNode = qualifiedNameNode = qualifiedNameDirectWrapperNames.contains(node.getNodeName()) ? node.findFirstChildOfName(STMKnownRuleNames.qualifiedName) : node;
        if (qualifiedNameNode == null) {
            return null;
        }
        if (!qualifiedNameNode.getNodeName().equals(STMKnownRuleNames.qualifiedName)) {
            log.debug((Object)("qualifiedName expected while facing with " + node.getNodeName()));
            return null;
        }
        SQLQueryMemberAccessEntry endingMemberAccessEntry = null;
        if (qualifiedNameNode.getChildCount() == 1 && !qualifiedNameNode.hasErrorChildren()) {
            SQLQuerySymbolEntry entityName = this.collectIdentifier(qualifiedNameNode.getChildNode(0), forceUnquotted, null);
            if (entityName == null) {
                return null;
            }
            invalidPartsCount = 0;
            nameParts = Collections.singletonList(entityName);
        } else {
            invalidPartsCount = 0;
            nameParts = new ArrayList(qualifiedNameNode.getChildCount());
            boolean expectingName = true;
            STMTreeNode periodNode = null;
            int i = 0;
            while (i < qualifiedNameNode.getChildCount()) {
                STMTreeNode partNode = qualifiedNameNode.getChildNode(i);
                if (expectingName) {
                    SQLQuerySymbolEntry namePart;
                    if (partNode.getNodeName().equals(STMKnownRuleNames.PERIOD_TERM)) {
                        namePart = null;
                        if (periodNode != null && endingMemberAccessEntry == null) {
                            endingMemberAccessEntry = new SQLQueryMemberAccessEntry(periodNode);
                        }
                        periodNode = null;
                    } else {
                        namePart = this.collectIdentifier(partNode, forceUnquotted, periodNode);
                        expectingName = false;
                        periodNode = null;
                    }
                    nameParts.add(namePart);
                    invalidPartsCount += namePart == null ? 1 : 0;
                } else if (partNode.getNodeName().equals(STMKnownRuleNames.PERIOD_TERM)) {
                    expectingName = true;
                    periodNode = partNode;
                } else {
                    nameParts.add(null);
                    ++invalidPartsCount;
                    periodNode = null;
                }
                ++i;
            }
            if (expectingName) {
                nameParts.add(null);
                ++invalidPartsCount;
                if (endingMemberAccessEntry != null) {
                    this.registerScopeItem(endingMemberAccessEntry);
                } else if (periodNode != null) {
                    endingMemberAccessEntry = new SQLQueryMemberAccessEntry(periodNode);
                    this.registerScopeItem(endingMemberAccessEntry);
                }
            }
        }
        return new SQLQueryComplexName(node, nameParts, invalidPartsCount, endingMemberAccessEntry);
    }

    @NotNull
    public SQLQueryValueExpression collectValueExpression(@NotNull STMTreeNode node, @Nullable SQLQueryLexicalScope scope) {
        if (!knownValueExpressionRootNames.contains(node.getNodeName())) {
            log.debug((Object)("Search condition or value expression expected while facing with " + node.getNodeName()));
            return new SQLQueryValueFlattenedExpression(node, Collections.emptyList());
        }
        if (knownRecognizableValueExpressionNames.contains(node.getNodeName())) {
            return this.collectKnownValueExpression(node, scope);
        }
        try (LexicalScopeHolder exprScopeHolder = scope != null ? null : this.openScope();){
            SQLQueryValueExpression result;
            Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
            Stack childLists = new Stack();
            stack.add(node);
            childLists.push(new ArrayList(1));
            while (!stack.isEmpty()) {
                SQLQueryValueFlattenedExpression child;
                SQLQueryValueExpression sQLQueryValueExpression;
                List children;
                STMTreeNode n = (STMTreeNode)stack.pop();
                if (n != null) {
                    STMTreeNode rn = n;
                    while (rn != null && rn.getChildCount() == 1 && !knownRecognizableValueExpressionNames.contains(rn.getNodeName())) {
                        rn = rn.findFirstNonErrorChild();
                    }
                    if (rn == null) continue;
                    if (knownRecognizableValueExpressionNames.contains(rn.getNodeName()) || rn.getNodeName().equals(STMKnownRuleNames.valueExpressionPrimary)) {
                        ((List)childLists.peek()).add(this.collectKnownValueExpression(rn, scope));
                        continue;
                    }
                    stack.push(n);
                    stack.push(null);
                    children = rn.findNonErrorChildren();
                    childLists.push(new ArrayList(children.size()));
                    int i = children.size() - 1;
                    while (i >= 0) {
                        stack.push((STMTreeNode)children.get(i));
                        --i;
                    }
                    continue;
                }
                STMTreeNode content = (STMTreeNode)stack.pop();
                children = (List)childLists.pop();
                if (children.isEmpty()) continue;
                SQLQueryValueFlattenedExpression e = children.size() == 1 && (sQLQueryValueExpression = (SQLQueryValueExpression)children.get(0)) instanceof SQLQueryValueFlattenedExpression ? (child = (SQLQueryValueFlattenedExpression)sQLQueryValueExpression) : new SQLQueryValueFlattenedExpression(content, children);
                ((List)childLists.peek()).add(e);
            }
            List roots = (List)childLists.pop();
            SQLQueryValueExpression sQLQueryValueExpression = result = roots.isEmpty() ? new SQLQueryValueFlattenedExpression(node, Collections.emptyList()) : (SQLQueryValueExpression)roots.get(0);
            if (exprScopeHolder != null) {
                result.registerLexicalScope(exprScopeHolder.lexicalScope);
            }
            SQLQueryValueExpression sQLQueryValueExpression2 = result;
            return sQLQueryValueExpression2;
        }
    }

    @NotNull
    public SQLQueryValueExpression collectKnownValueExpression(@NotNull STMTreeNode node, @Nullable SQLQueryLexicalScope scope) {
        SQLQueryValueExpression result = switch (node.getNodeKindId()) {
            case 281 -> this.collectFunctionCall(node, scope, false);
            case 101 -> new SQLQueryValueSubqueryExpression(node, this.collectQueryExpression(node));
            case 89 -> this.collectValueReferenceExpression(node, false);
            case 169 -> {
                STMTreeNode valueExprNode = node.findFirstChildOfName(STMKnownRuleNames.valueExpressionAtom);
                if (valueExprNode == null) {
                    yield null;
                }
                SQLQueryValueExpression subexpr = this.collectValueExpression(valueExprNode, scope);
                STMTreeNode castSpecNode = node.findFirstChildOfName(STMKnownRuleNames.valueExpressionCastSpec);
                if (castSpecNode != null) {
                    STMTreeNode dataTypeNode = castSpecNode.findLastChildOfName(STMKnownRuleNames.dataType);
                    String typeName = dataTypeNode == null ? "UNKNOWN" : dataTypeNode.getTextContent();
                    yield new SQLQueryValueTypeCastExpression(node, subexpr, typeName);
                }
                yield subexpr;
            }
            case 173 -> {
                STMTreeNode varExprNode = node.findFirstNonErrorChild();
                if (varExprNode instanceof STMTreeTermNode) {
                    STMTreeTermNode varExprTermNode = (STMTreeTermNode)varExprNode;
                    String rawName = varExprTermNode.getTextContent();
                    switch (rawName.charAt(0)) {
                        case '@': {
                            yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, rawName.substring(1), rawName, null), SQLQueryValueVariableExpression.VariableExpressionKind.BATCH_VARIABLE, rawName);
                        }
                        case '$': {
                            yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, rawName.substring(2, rawName.length() - 1), rawName, null), SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_VARIABLE, rawName);
                        }
                    }
                    log.debug((Object)("Unsupported term variable expression: " + node.getTextContent()));
                    yield null;
                }
                if (varExprNode != null) {
                    switch (varExprNode.getNodeKindId()) {
                        case 174: {
                            STMTreeNode identifierNode = varExprNode.findLastNonErrorChild();
                            String name = identifierNode == null ? "?" : identifierNode.getTextContent();
                            yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, name, varExprNode.getTextContent(), null), SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_PARAMETER, varExprNode.getTextContent());
                        }
                        case 175: {
                            STMTreeNode markNode = varExprNode.findLastNonErrorChild();
                            String mark = markNode == null ? "?" : markNode.getTextContent();
                            this.registerSymbolEntry(node, mark, mark, null);
                            yield new SQLQueryValueVariableExpression(node, null, SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_PARAMETER, varExprNode.getTextContent());
                        }
                    }
                    log.debug((Object)("Unsupported variable expression: " + node.getTextContent()));
                    yield null;
                }
                yield null;
            }
            case 205 -> this.makeValueConstantExpression(node, SQLQueryExprType.NUMERIC);
            case 69 -> this.makeValueConstantExpression(node, SQLQueryExprType.BOOLEAN);
            case 6 -> this.makeValueConstantExpression(node, SQLQueryExprType.NUMERIC);
            case 7 -> this.makeValueConstantExpression(node, SQLQueryExprType.NUMERIC);
            case 8 -> this.makeValueConstantExpression(node, SQLQueryExprType.STRING);
            case 10 -> this.makeValueConstantExpression(node, SQLQueryExprType.DATETIME);
            default -> throw new UnsupportedOperationException("Unknown expression kind " + node.getNodeName());
        };
        return result != null ? result : new SQLQueryValueFlattenedExpression(node, Collections.emptyList());
    }

    @NotNull
    private SQLQueryValueExpression makeValueConstantExpression(@NotNull STMTreeNode node, @NotNull SQLQueryExprType type) {
        return new SQLQueryValueConstantExpression(node, node.getTextContent(), type);
    }

    @NotNull
    private SQLQueryValueExpression collectValueReferenceExpression(@NotNull STMTreeNode node, boolean rowRefAllowed) {
        static interface LazyExpr {
            public SQLQueryValueExpression getExpression(boolean var1);

            public static LazyExpr of(SQLQueryValueExpression expr) {
                return b -> expr;
            }
        }
        LazyExpr expr;
        List subnodes = node.findNonErrorChildren();
        if (subnodes.size() > 0) {
            STMTreeNode head = (STMTreeNode)subnodes.get(0);
            expr = switch (head.getNodeKindId()) {
                case 87 -> b -> this.collectColumnReferenceExpression(head, b);
                case 90 -> {
                    STMTreeNode valueRefNode = head.findFirstChildOfName(STMKnownRuleNames.valueReference);
                    if (valueRefNode == null) {
                        yield null;
                    }
                    yield b -> this.collectValueReferenceExpression(valueRefNode, b);
                }
                default -> {
                    log.debug((Object)("Value reference expression expected while facing with " + head.getNodeName()));
                    yield null;
                }
            };
        } else {
            expr = null;
        }
        if (expr != null && subnodes.size() > 1) {
            int rangeStart = node.getRealInterval().a;
            boolean[] slicingFlags = new boolean[subnodes.size()];
            int i = 1;
            while (i < subnodes.size()) {
                STMTreeNode step = (STMTreeNode)subnodes.get(i);
                Interval range = new Interval(rangeStart, step.getRealInterval().b);
                expr = switch (step.getNodeKindId()) {
                    case 91 -> {
                        int s = i;
                        while (i < subnodes.size() && (step = (STMTreeNode)subnodes.get(i)).getNodeKindId() == 91) {
                            slicingFlags[i] = step.findFirstChildOfName(STMKnownRuleNames.valueRefIndexingStepSlice) != null;
                            ++i;
                        }
                        boolean[] slicingSpec = Arrays.copyOfRange(slicingFlags, s, i);
                        yield LazyExpr.of(new SQLQueryValueIndexingExpression(range, node, expr.getExpression(false), slicingSpec));
                    }
                    case 94 -> {
                        ++i;
                        STMTreeNode periodNode = step.findLastChildOfName(STMKnownRuleNames.PERIOD_TERM);
                        STMTreeNode memberNameNode = step.findLastChildOfName(STMKnownRuleNames.identifier);
                        SQLQuerySymbolEntry memberName = memberNameNode == null ? null : this.collectIdentifier(memberNameNode, periodNode);
                        SQLQueryMemberAccessEntry memberAccessEntry = memberName != null ? memberName.getMemberAccess() : this.registerScopeItem(new SQLQueryMemberAccessEntry(periodNode));
                        yield LazyExpr.of(new SQLQueryValueMemberExpression(range, node, expr.getExpression(true), memberName, memberAccessEntry));
                    }
                    default -> throw new UnsupportedOperationException("Value member expression expected while facing with " + step.getNodeName());
                };
            }
        }
        return expr != null ? expr.getExpression(rowRefAllowed) : new SQLQueryValueFlattenedExpression(node, Collections.emptyList());
    }

    @Nullable
    private SQLQueryValueExpression collectColumnReferenceExpression(@NotNull STMTreeNode head, boolean rowRefAllowed) {
        STMTreeNode nameNode = head.findFirstChildOfName(STMKnownRuleNames.qualifiedName);
        if (nameNode == null) {
            return null;
        }
        SQLQueryComplexName name = this.collectQualifiedName(nameNode);
        if (name == null) {
            return null;
        }
        STMTreeNode tupleRefNode = head.findLastChildOfName(STMKnownRuleNames.tupleRefSuffix);
        if (tupleRefNode == null) {
            return new SQLQueryValueReferenceExpression(head, rowRefAllowed, name);
        }
        STMTreeNode asteriskNode = tupleRefNode.findFirstChildOfName(STMKnownRuleNames.ASTERISK_TERM);
        SQLQueryTupleRefEntry tupleRefEntry = asteriskNode == null ? null : new SQLQueryTupleRefEntry(asteriskNode);
        STMTreeNode periodNode = tupleRefNode.findFirstChildOfName(STMKnownRuleNames.PERIOD_TERM);
        SQLQueryMemberAccessEntry memberAccessEntry = periodNode == null ? null : this.registerScopeItem(new SQLQueryMemberAccessEntry(periodNode));
        return new SQLQueryValueTupleReferenceExpression(head, name, memberAccessEntry, tupleRefEntry);
    }

    @NotNull
    public SQLQueryValueFunctionExpression collectFunctionCall(@NotNull STMTreeNode callNode, @Nullable SQLQueryLexicalScope scope, boolean forRows) {
        SQLQueryComplexName name;
        STMTreeNode nameNode = callNode.findFirstChildOfName(STMKnownRuleNames.functionCallTargetName);
        if (nameNode != null) {
            STMTreeNode actualNameNode = nameNode.findFirstChildOfName(STMKnownRuleNames.qualifiedName);
            if (actualNameNode != null) {
                name = this.collectQualifiedName(actualNameNode);
            } else {
                STMTreeNode term = nameNode.findFirstNonErrorChild();
                if (term != null) {
                    String nameString = term.getTextContent();
                    String canonicalNameString = SQLUtils.identifierToCanonicalForm((SQLDialect)this.dialect, (String)nameString, (boolean)false, (boolean)false);
                    SQLQuerySymbolEntry nameEntry = this.registerSymbolEntry(term, canonicalNameString, nameString, null);
                    name = new SQLQueryComplexName(term, List.of(nameEntry), 0, null);
                } else {
                    name = null;
                }
            }
        } else {
            name = null;
        }
        List argNodes = callNode.findChildrenOfName(STMKnownRuleNames.functionCallOperand);
        ArrayList<SQLQueryValueExpression> argExprs = new ArrayList<SQLQueryValueExpression>(argNodes.size());
        for (STMTreeNode argNode : argNodes) {
            STMTreeNode value = argNode.findFirstNonErrorChild();
            STMTreeNode n = value == null ? null : value.findFirstNonErrorChild();
            SQLQueryValueExpression expr = n != null ? this.collectValueExpression(n, scope) : new SQLQueryValueFlattenedExpression(argNode, Collections.emptyList());
            argExprs.add(expr);
        }
        return new SQLQueryValueFunctionExpression(callNode, name, argExprs, forRows);
    }

    @Nullable
    public static SQLQuerySymbolClass tryFallbackSymbolForStringLiteral(@NotNull SQLDialect dialect, @NotNull SQLQuerySymbolEntry symbolEntry, boolean isColumnResolved) {
        SQLQuerySymbolClass forcedClass = null;
        boolean isQuotedIdentifier = dialect.isQuotedIdentifier(symbolEntry.getRawName());
        char quoteChar = symbolEntry.getRawName().charAt(0);
        if (!isQuotedIdentifier && (quoteChar == '\"' || quoteChar == '`' || quoteChar == '\'') || isQuotedIdentifier && !isColumnResolved) {
            forcedClass = switch (quoteChar) {
                case '\'' -> SQLQuerySymbolClass.STRING;
                case '\"', '`' -> SQLQuerySymbolClass.QUOTED;
                default -> null;
            };
        }
        return forcedClass;
    }

    private SQLQueryLexicalScope beginScope() {
        SQLQueryLexicalScope scope = new SQLQueryLexicalScope();
        this.currentLexicalScopes.addLast(scope);
        return scope;
    }

    private void endScope(SQLQueryLexicalScope scope) {
        if (this.currentLexicalScopes.peekLast() != scope) {
            throw new IllegalStateException();
        }
        this.currentLexicalScopes.removeLast();
    }

    public <T extends SQLQueryLexicalScopeItem> T registerScopeItem(T item) {
        SQLQueryLexicalScope scope = this.currentLexicalScopes.peekLast();
        if (scope != null) {
            scope.registerItem(item);
        }
        this.lexicalItems.put(item.getSyntaxNode().getRealInterval().a, item);
        return item;
    }

    public LexicalScopeHolder openScope() {
        return new LexicalScopeHolder(this.beginScope());
    }

    @Nullable
    public static SQLQueryModel recognizeQuery(@NotNull SQLQueryRecognitionContext recognitionContext, @NotNull String queryText) {
        SQLQueryModelRecognizer recognizer = new SQLQueryModelRecognizer(recognitionContext);
        return recognizer.recognizeQuery(queryText);
    }

    public class LexicalScopeHolder
    implements AutoCloseable {
        @NotNull
        public final SQLQueryLexicalScope lexicalScope;

        public LexicalScopeHolder(SQLQueryLexicalScope scope) {
            this.lexicalScope = scope;
        }

        @Override
        public void close() {
            SQLQueryModelRecognizer.this.endScope(this.lexicalScope);
        }
    }
}

