﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/VpcConfig.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>Security options.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AutoMLSecurityConfig">AWS
 * API Reference</a></p>
 */
class AutoMLSecurityConfig {
 public:
  AWS_SAGEMAKER_API AutoMLSecurityConfig() = default;
  AWS_SAGEMAKER_API AutoMLSecurityConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API AutoMLSecurityConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The key used to encrypt stored data.</p>
   */
  inline const Aws::String& GetVolumeKmsKeyId() const { return m_volumeKmsKeyId; }
  inline bool VolumeKmsKeyIdHasBeenSet() const { return m_volumeKmsKeyIdHasBeenSet; }
  template <typename VolumeKmsKeyIdT = Aws::String>
  void SetVolumeKmsKeyId(VolumeKmsKeyIdT&& value) {
    m_volumeKmsKeyIdHasBeenSet = true;
    m_volumeKmsKeyId = std::forward<VolumeKmsKeyIdT>(value);
  }
  template <typename VolumeKmsKeyIdT = Aws::String>
  AutoMLSecurityConfig& WithVolumeKmsKeyId(VolumeKmsKeyIdT&& value) {
    SetVolumeKmsKeyId(std::forward<VolumeKmsKeyIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether to use traffic encryption between the container layers.</p>
   */
  inline bool GetEnableInterContainerTrafficEncryption() const { return m_enableInterContainerTrafficEncryption; }
  inline bool EnableInterContainerTrafficEncryptionHasBeenSet() const { return m_enableInterContainerTrafficEncryptionHasBeenSet; }
  inline void SetEnableInterContainerTrafficEncryption(bool value) {
    m_enableInterContainerTrafficEncryptionHasBeenSet = true;
    m_enableInterContainerTrafficEncryption = value;
  }
  inline AutoMLSecurityConfig& WithEnableInterContainerTrafficEncryption(bool value) {
    SetEnableInterContainerTrafficEncryption(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The VPC configuration.</p>
   */
  inline const VpcConfig& GetVpcConfig() const { return m_vpcConfig; }
  inline bool VpcConfigHasBeenSet() const { return m_vpcConfigHasBeenSet; }
  template <typename VpcConfigT = VpcConfig>
  void SetVpcConfig(VpcConfigT&& value) {
    m_vpcConfigHasBeenSet = true;
    m_vpcConfig = std::forward<VpcConfigT>(value);
  }
  template <typename VpcConfigT = VpcConfig>
  AutoMLSecurityConfig& WithVpcConfig(VpcConfigT&& value) {
    SetVpcConfig(std::forward<VpcConfigT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_volumeKmsKeyId;
  bool m_volumeKmsKeyIdHasBeenSet = false;

  bool m_enableInterContainerTrafficEncryption{false};
  bool m_enableInterContainerTrafficEncryptionHasBeenSet = false;

  VpcConfig m_vpcConfig;
  bool m_vpcConfigHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
