// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from fu540.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/SiFive-Community

//go:build sifive && fu540

/*
// SiFive Freedom U540 64-bit RISC-V CPU
*/

package sifive

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "FU540"
)

// Interrupt numbers.
const (
	// Highest interrupt number on this device.
	IRQ_max = 0
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	}
}

// Peripherals.
var (
	// Mode Select
	MSEL = (*MSEL_Type)(unsafe.Pointer(uintptr(0x1000)))

	// PRCI (Power Reset Clocking Interrupt) Block
	PRCI = (*PRCI_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x10010000)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x10011000)))
)

// Mode Select
type MSEL_Type struct {
	MSEL volatile.Register32 // 0x0
}

// MSEL.MSEL: The MSEL pin state
func (o *MSEL_Type) SetMSEL(value uint32) {
	volatile.StoreUint32(&o.MSEL.Reg, volatile.LoadUint32(&o.MSEL.Reg)&^(0xf)|value)
}
func (o *MSEL_Type) GetMSEL() uint32 {
	return volatile.LoadUint32(&o.MSEL.Reg) & 0xf
}

// PRCI (Power Reset Clocking Interrupt) Block
type PRCI_Type struct {
	HFXOSCCFG       volatile.Register32 // 0x0
	COREPLLCFG0     volatile.Register32 // 0x4
	_               [4]byte
	DDRPLLCFG0      volatile.Register32 // 0xC
	DDRPLLCFG1      volatile.Register32 // 0x10
	_               [8]byte
	GEMGXLPLLCFG0   volatile.Register32 // 0x1C
	GEMGXLPLLCFG1   volatile.Register32 // 0x20
	CORECLKSEL      volatile.Register32 // 0x24
	DEVICESRESETREG volatile.Register32 // 0x28
	CLKMUXSTATUS    volatile.Register32 // 0x2C
	_               [192]byte
	PROCMONCFG      volatile.Register32 // 0xF0
}

// PRCI.HFXOSCCFG: Crystal Input Control Register
func (o *PRCI_Type) SetHFXOSCCFG_XOSC_RDY(value uint32) {
	volatile.StoreUint32(&o.HFXOSCCFG.Reg, volatile.LoadUint32(&o.HFXOSCCFG.Reg)&^(0x20000000)|value<<29)
}
func (o *PRCI_Type) GetHFXOSCCFG_XOSC_RDY() uint32 {
	return (volatile.LoadUint32(&o.HFXOSCCFG.Reg) & 0x20000000) >> 29
}
func (o *PRCI_Type) SetHFXOSCCFG_XOSCCFG_EN(value uint32) {
	volatile.StoreUint32(&o.HFXOSCCFG.Reg, volatile.LoadUint32(&o.HFXOSCCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *PRCI_Type) GetHFXOSCCFG_XOSCCFG_EN() uint32 {
	return (volatile.LoadUint32(&o.HFXOSCCFG.Reg) & 0x40000000) >> 30
}

// PRCI.COREPLLCFG0: Core PLL Configuration Register
func (o *PRCI_Type) SetCOREPLLCFG0_DIVR(value uint32) {
	volatile.StoreUint32(&o.COREPLLCFG0.Reg, volatile.LoadUint32(&o.COREPLLCFG0.Reg)&^(0x3f)|value)
}
func (o *PRCI_Type) GetCOREPLLCFG0_DIVR() uint32 {
	return volatile.LoadUint32(&o.COREPLLCFG0.Reg) & 0x3f
}
func (o *PRCI_Type) SetCOREPLLCFG0_DIVF(value uint32) {
	volatile.StoreUint32(&o.COREPLLCFG0.Reg, volatile.LoadUint32(&o.COREPLLCFG0.Reg)&^(0x7fc0)|value<<6)
}
func (o *PRCI_Type) GetCOREPLLCFG0_DIVF() uint32 {
	return (volatile.LoadUint32(&o.COREPLLCFG0.Reg) & 0x7fc0) >> 6
}
func (o *PRCI_Type) SetCOREPLLCFG0_DIVQ(value uint32) {
	volatile.StoreUint32(&o.COREPLLCFG0.Reg, volatile.LoadUint32(&o.COREPLLCFG0.Reg)&^(0x38000)|value<<15)
}
func (o *PRCI_Type) GetCOREPLLCFG0_DIVQ() uint32 {
	return (volatile.LoadUint32(&o.COREPLLCFG0.Reg) & 0x38000) >> 15
}
func (o *PRCI_Type) SetCOREPLLCFG0_RANGE(value uint32) {
	volatile.StoreUint32(&o.COREPLLCFG0.Reg, volatile.LoadUint32(&o.COREPLLCFG0.Reg)&^(0x1c0000)|value<<18)
}
func (o *PRCI_Type) GetCOREPLLCFG0_RANGE() uint32 {
	return (volatile.LoadUint32(&o.COREPLLCFG0.Reg) & 0x1c0000) >> 18
}
func (o *PRCI_Type) SetCOREPLLCFG0_BYPASS(value uint32) {
	volatile.StoreUint32(&o.COREPLLCFG0.Reg, volatile.LoadUint32(&o.COREPLLCFG0.Reg)&^(0x1000000)|value<<24)
}
func (o *PRCI_Type) GetCOREPLLCFG0_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.COREPLLCFG0.Reg) & 0x1000000) >> 24
}
func (o *PRCI_Type) SetCOREPLLCFG0_FSE(value uint32) {
	volatile.StoreUint32(&o.COREPLLCFG0.Reg, volatile.LoadUint32(&o.COREPLLCFG0.Reg)&^(0x2000000)|value<<25)
}
func (o *PRCI_Type) GetCOREPLLCFG0_FSE() uint32 {
	return (volatile.LoadUint32(&o.COREPLLCFG0.Reg) & 0x2000000) >> 25
}
func (o *PRCI_Type) SetCOREPLLCFG0_LOCK(value uint32) {
	volatile.StoreUint32(&o.COREPLLCFG0.Reg, volatile.LoadUint32(&o.COREPLLCFG0.Reg)&^(0x80000000)|value<<31)
}
func (o *PRCI_Type) GetCOREPLLCFG0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COREPLLCFG0.Reg) & 0x80000000) >> 31
}

// PRCI.DDRPLLCFG0: DDR PLL Configuration Register
func (o *PRCI_Type) SetDDRPLLCFG0_DIVR(value uint32) {
	volatile.StoreUint32(&o.DDRPLLCFG0.Reg, volatile.LoadUint32(&o.DDRPLLCFG0.Reg)&^(0x3f)|value)
}
func (o *PRCI_Type) GetDDRPLLCFG0_DIVR() uint32 {
	return volatile.LoadUint32(&o.DDRPLLCFG0.Reg) & 0x3f
}
func (o *PRCI_Type) SetDDRPLLCFG0_DIVF(value uint32) {
	volatile.StoreUint32(&o.DDRPLLCFG0.Reg, volatile.LoadUint32(&o.DDRPLLCFG0.Reg)&^(0x7fc0)|value<<6)
}
func (o *PRCI_Type) GetDDRPLLCFG0_DIVF() uint32 {
	return (volatile.LoadUint32(&o.DDRPLLCFG0.Reg) & 0x7fc0) >> 6
}
func (o *PRCI_Type) SetDDRPLLCFG0_DIVQ(value uint32) {
	volatile.StoreUint32(&o.DDRPLLCFG0.Reg, volatile.LoadUint32(&o.DDRPLLCFG0.Reg)&^(0x38000)|value<<15)
}
func (o *PRCI_Type) GetDDRPLLCFG0_DIVQ() uint32 {
	return (volatile.LoadUint32(&o.DDRPLLCFG0.Reg) & 0x38000) >> 15
}
func (o *PRCI_Type) SetDDRPLLCFG0_RANGE(value uint32) {
	volatile.StoreUint32(&o.DDRPLLCFG0.Reg, volatile.LoadUint32(&o.DDRPLLCFG0.Reg)&^(0x1c0000)|value<<18)
}
func (o *PRCI_Type) GetDDRPLLCFG0_RANGE() uint32 {
	return (volatile.LoadUint32(&o.DDRPLLCFG0.Reg) & 0x1c0000) >> 18
}
func (o *PRCI_Type) SetDDRPLLCFG0_BYPASS(value uint32) {
	volatile.StoreUint32(&o.DDRPLLCFG0.Reg, volatile.LoadUint32(&o.DDRPLLCFG0.Reg)&^(0x1000000)|value<<24)
}
func (o *PRCI_Type) GetDDRPLLCFG0_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.DDRPLLCFG0.Reg) & 0x1000000) >> 24
}
func (o *PRCI_Type) SetDDRPLLCFG0_FSE(value uint32) {
	volatile.StoreUint32(&o.DDRPLLCFG0.Reg, volatile.LoadUint32(&o.DDRPLLCFG0.Reg)&^(0x2000000)|value<<25)
}
func (o *PRCI_Type) GetDDRPLLCFG0_FSE() uint32 {
	return (volatile.LoadUint32(&o.DDRPLLCFG0.Reg) & 0x2000000) >> 25
}
func (o *PRCI_Type) SetDDRPLLCFG0_LOCK(value uint32) {
	volatile.StoreUint32(&o.DDRPLLCFG0.Reg, volatile.LoadUint32(&o.DDRPLLCFG0.Reg)&^(0x80000000)|value<<31)
}
func (o *PRCI_Type) GetDDRPLLCFG0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.DDRPLLCFG0.Reg) & 0x80000000) >> 31
}

// PRCI.DDRPLLCFG1: DDR PLL Configuration Register
func (o *PRCI_Type) SetDDRPLLCFG1_CKE(value uint32) {
	volatile.StoreUint32(&o.DDRPLLCFG1.Reg, volatile.LoadUint32(&o.DDRPLLCFG1.Reg)&^(0x1000000)|value<<24)
}
func (o *PRCI_Type) GetDDRPLLCFG1_CKE() uint32 {
	return (volatile.LoadUint32(&o.DDRPLLCFG1.Reg) & 0x1000000) >> 24
}

// PRCI.GEMGXLPLLCFG0: Gigabit Ethernet PLL Configuration Register
func (o *PRCI_Type) SetGEMGXLPLLCFG0_DIVR(value uint32) {
	volatile.StoreUint32(&o.GEMGXLPLLCFG0.Reg, volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg)&^(0x3f)|value)
}
func (o *PRCI_Type) GetGEMGXLPLLCFG0_DIVR() uint32 {
	return volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg) & 0x3f
}
func (o *PRCI_Type) SetGEMGXLPLLCFG0_DIVF(value uint32) {
	volatile.StoreUint32(&o.GEMGXLPLLCFG0.Reg, volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg)&^(0x7fc0)|value<<6)
}
func (o *PRCI_Type) GetGEMGXLPLLCFG0_DIVF() uint32 {
	return (volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg) & 0x7fc0) >> 6
}
func (o *PRCI_Type) SetGEMGXLPLLCFG0_DIVQ(value uint32) {
	volatile.StoreUint32(&o.GEMGXLPLLCFG0.Reg, volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg)&^(0x38000)|value<<15)
}
func (o *PRCI_Type) GetGEMGXLPLLCFG0_DIVQ() uint32 {
	return (volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg) & 0x38000) >> 15
}
func (o *PRCI_Type) SetGEMGXLPLLCFG0_RANGE(value uint32) {
	volatile.StoreUint32(&o.GEMGXLPLLCFG0.Reg, volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg)&^(0x1c0000)|value<<18)
}
func (o *PRCI_Type) GetGEMGXLPLLCFG0_RANGE() uint32 {
	return (volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg) & 0x1c0000) >> 18
}
func (o *PRCI_Type) SetGEMGXLPLLCFG0_BYPASS(value uint32) {
	volatile.StoreUint32(&o.GEMGXLPLLCFG0.Reg, volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg)&^(0x1000000)|value<<24)
}
func (o *PRCI_Type) GetGEMGXLPLLCFG0_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg) & 0x1000000) >> 24
}
func (o *PRCI_Type) SetGEMGXLPLLCFG0_FSE(value uint32) {
	volatile.StoreUint32(&o.GEMGXLPLLCFG0.Reg, volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg)&^(0x2000000)|value<<25)
}
func (o *PRCI_Type) GetGEMGXLPLLCFG0_FSE() uint32 {
	return (volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg) & 0x2000000) >> 25
}
func (o *PRCI_Type) SetGEMGXLPLLCFG0_LOCK(value uint32) {
	volatile.StoreUint32(&o.GEMGXLPLLCFG0.Reg, volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg)&^(0x80000000)|value<<31)
}
func (o *PRCI_Type) GetGEMGXLPLLCFG0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.GEMGXLPLLCFG0.Reg) & 0x80000000) >> 31
}

// PRCI.GEMGXLPLLCFG1: Gigabit Ethernet PLL Configuration Register
func (o *PRCI_Type) SetGEMGXLPLLCFG1_CKE(value uint32) {
	volatile.StoreUint32(&o.GEMGXLPLLCFG1.Reg, volatile.LoadUint32(&o.GEMGXLPLLCFG1.Reg)&^(0x1000000)|value<<24)
}
func (o *PRCI_Type) GetGEMGXLPLLCFG1_CKE() uint32 {
	return (volatile.LoadUint32(&o.GEMGXLPLLCFG1.Reg) & 0x1000000) >> 24
}

// PRCI.CORECLKSEL: CORECLK Source Selection Register
func (o *PRCI_Type) SetCORECLKSEL(value uint32) {
	volatile.StoreUint32(&o.CORECLKSEL.Reg, volatile.LoadUint32(&o.CORECLKSEL.Reg)&^(0x1)|value)
}
func (o *PRCI_Type) GetCORECLKSEL() uint32 {
	return volatile.LoadUint32(&o.CORECLKSEL.Reg) & 0x1
}

// PRCI.DEVICESRESETREG: Peripheral Devices Reset Control Register
func (o *PRCI_Type) SetDEVICESRESETREG_DDR_CTRL_RST_N(value uint32) {
	volatile.StoreUint32(&o.DEVICESRESETREG.Reg, volatile.LoadUint32(&o.DEVICESRESETREG.Reg)&^(0x1)|value)
}
func (o *PRCI_Type) GetDEVICESRESETREG_DDR_CTRL_RST_N() uint32 {
	return volatile.LoadUint32(&o.DEVICESRESETREG.Reg) & 0x1
}
func (o *PRCI_Type) SetDEVICESRESETREG_DDR_AXI_RST_N(value uint32) {
	volatile.StoreUint32(&o.DEVICESRESETREG.Reg, volatile.LoadUint32(&o.DEVICESRESETREG.Reg)&^(0x2)|value<<1)
}
func (o *PRCI_Type) GetDEVICESRESETREG_DDR_AXI_RST_N() uint32 {
	return (volatile.LoadUint32(&o.DEVICESRESETREG.Reg) & 0x2) >> 1
}
func (o *PRCI_Type) SetDEVICESRESETREG_DDR_AHB_RST_N(value uint32) {
	volatile.StoreUint32(&o.DEVICESRESETREG.Reg, volatile.LoadUint32(&o.DEVICESRESETREG.Reg)&^(0x4)|value<<2)
}
func (o *PRCI_Type) GetDEVICESRESETREG_DDR_AHB_RST_N() uint32 {
	return (volatile.LoadUint32(&o.DEVICESRESETREG.Reg) & 0x4) >> 2
}
func (o *PRCI_Type) SetDEVICESRESETREG_DDR_PHY_RST_N(value uint32) {
	volatile.StoreUint32(&o.DEVICESRESETREG.Reg, volatile.LoadUint32(&o.DEVICESRESETREG.Reg)&^(0x8)|value<<3)
}
func (o *PRCI_Type) GetDEVICESRESETREG_DDR_PHY_RST_N() uint32 {
	return (volatile.LoadUint32(&o.DEVICESRESETREG.Reg) & 0x8) >> 3
}
func (o *PRCI_Type) SetDEVICESRESETREG_GEMGXL_RST_N(value uint32) {
	volatile.StoreUint32(&o.DEVICESRESETREG.Reg, volatile.LoadUint32(&o.DEVICESRESETREG.Reg)&^(0x20)|value<<5)
}
func (o *PRCI_Type) GetDEVICESRESETREG_GEMGXL_RST_N() uint32 {
	return (volatile.LoadUint32(&o.DEVICESRESETREG.Reg) & 0x20) >> 5
}

// PRCI.CLKMUXSTATUS: CLKMUX Status Register
func (o *PRCI_Type) SetCLKMUXSTATUS_CORECLKPLLSEL(value uint32) {
	volatile.StoreUint32(&o.CLKMUXSTATUS.Reg, volatile.LoadUint32(&o.CLKMUXSTATUS.Reg)&^(0x1)|value)
}
func (o *PRCI_Type) GetCLKMUXSTATUS_CORECLKPLLSEL() uint32 {
	return volatile.LoadUint32(&o.CLKMUXSTATUS.Reg) & 0x1
}
func (o *PRCI_Type) SetCLKMUXSTATUS_TLCLKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKMUXSTATUS.Reg, volatile.LoadUint32(&o.CLKMUXSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *PRCI_Type) GetCLKMUXSTATUS_TLCLKSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKMUXSTATUS.Reg) & 0x2) >> 1
}
func (o *PRCI_Type) SetCLKMUXSTATUS_RTCXSEL(value uint32) {
	volatile.StoreUint32(&o.CLKMUXSTATUS.Reg, volatile.LoadUint32(&o.CLKMUXSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *PRCI_Type) GetCLKMUXSTATUS_RTCXSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKMUXSTATUS.Reg) & 0x4) >> 2
}
func (o *PRCI_Type) SetCLKMUXSTATUS_DDRCTRLCLKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKMUXSTATUS.Reg, volatile.LoadUint32(&o.CLKMUXSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *PRCI_Type) GetCLKMUXSTATUS_DDRCTRLCLKSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKMUXSTATUS.Reg) & 0x8) >> 3
}
func (o *PRCI_Type) SetCLKMUXSTATUS_DDRPHYCLKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKMUXSTATUS.Reg, volatile.LoadUint32(&o.CLKMUXSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *PRCI_Type) GetCLKMUXSTATUS_DDRPHYCLKSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKMUXSTATUS.Reg) & 0x10) >> 4
}
func (o *PRCI_Type) SetCLKMUXSTATUS_GEMGXLCLKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKMUXSTATUS.Reg, volatile.LoadUint32(&o.CLKMUXSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *PRCI_Type) GetCLKMUXSTATUS_GEMGXLCLKSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKMUXSTATUS.Reg) & 0x40) >> 6
}

// PRCI.PROCMONCFG: PROCMON Configuration Register
func (o *PRCI_Type) SetPROCMONCFG_CORECLKSEL(value uint32) {
	volatile.StoreUint32(&o.PROCMONCFG.Reg, volatile.LoadUint32(&o.PROCMONCFG.Reg)&^(0x1000000)|value<<24)
}
func (o *PRCI_Type) GetPROCMONCFG_CORECLKSEL() uint32 {
	return (volatile.LoadUint32(&o.PROCMONCFG.Reg) & 0x1000000) >> 24
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	TXDATA volatile.Register32 // 0x0
	RXDATA volatile.Register32 // 0x4
	TXCTRL volatile.Register32 // 0x8
	RXCTRL volatile.Register32 // 0xC
	IE     volatile.Register32 // 0x10
	IP     volatile.Register32 // 0x14
	DIV    volatile.Register32 // 0x18
}

// UART.TXDATA: Transmit Data Register
func (o *UART_Type) SetTXDATA_DATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTXDATA_DATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg) & 0xff
}
func (o *UART_Type) SetTXDATA_FULL(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_Type) GetTXDATA_FULL() uint32 {
	return (volatile.LoadUint32(&o.TXDATA.Reg) & 0x80000000) >> 31
}

// UART.RXDATA: Receive Data Register
func (o *UART_Type) SetRXDATA_DATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRXDATA_DATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg) & 0xff
}
func (o *UART_Type) SetRXDATA_EMPTY(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_Type) GetRXDATA_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.RXDATA.Reg) & 0x80000000) >> 31
}

// UART.TXCTRL: Transmit Control Register
func (o *UART_Type) SetTXCTRL_TXEN(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetTXCTRL_TXEN() uint32 {
	return volatile.LoadUint32(&o.TXCTRL.Reg) & 0x1
}
func (o *UART_Type) SetTXCTRL_NSTOP(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetTXCTRL_NSTOP() uint32 {
	return (volatile.LoadUint32(&o.TXCTRL.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetTXCTRL_TXCNT(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x70000)|value<<16)
}
func (o *UART_Type) GetTXCTRL_TXCNT() uint32 {
	return (volatile.LoadUint32(&o.TXCTRL.Reg) & 0x70000) >> 16
}

// UART.RXCTRL: Receive Control Register
func (o *UART_Type) SetRXCTRL_RXEN(value uint32) {
	volatile.StoreUint32(&o.RXCTRL.Reg, volatile.LoadUint32(&o.RXCTRL.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetRXCTRL_RXEN() uint32 {
	return volatile.LoadUint32(&o.RXCTRL.Reg) & 0x1
}
func (o *UART_Type) SetRXCTRL_RXCNT(value uint32) {
	volatile.StoreUint32(&o.RXCTRL.Reg, volatile.LoadUint32(&o.RXCTRL.Reg)&^(0x70000)|value<<16)
}
func (o *UART_Type) GetRXCTRL_RXCNT() uint32 {
	return (volatile.LoadUint32(&o.RXCTRL.Reg) & 0x70000) >> 16
}

// UART.IE: Interrupt Enable Register
func (o *UART_Type) SetIE_TXWM(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIE_TXWM() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}
func (o *UART_Type) SetIE_RXWM(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIE_RXWM() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}

// UART.IP: Interrupt Pending Register
func (o *UART_Type) SetIP_TXWM(value uint32) {
	volatile.StoreUint32(&o.IP.Reg, volatile.LoadUint32(&o.IP.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIP_TXWM() uint32 {
	return volatile.LoadUint32(&o.IP.Reg) & 0x1
}
func (o *UART_Type) SetIP_RXWM(value uint32) {
	volatile.StoreUint32(&o.IP.Reg, volatile.LoadUint32(&o.IP.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIP_RXWM() uint32 {
	return (volatile.LoadUint32(&o.IP.Reg) & 0x2) >> 1
}

// UART.DIV: Baud Rate Divisor Register
func (o *UART_Type) SetDIV(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xfffff)|value)
}
func (o *UART_Type) GetDIV() uint32 {
	return volatile.LoadUint32(&o.DIV.Reg) & 0xfffff
}

// Constants for MSEL: Mode Select
const (
	// MSEL: The MSEL pin state
	// Position of MSEL field.
	MSEL_MSEL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	MSEL_MSEL_MSEL_Msk = 0xf
)

// Constants for PRCI: PRCI (Power Reset Clocking Interrupt) Block
const (
	// HFXOSCCFG: Crystal Input Control Register
	// Position of XOSC_RDY field.
	PRCI_HFXOSCCFG_XOSC_RDY_Pos = 0x1d
	// Bit mask of XOSC_RDY field.
	PRCI_HFXOSCCFG_XOSC_RDY_Msk = 0x20000000
	// Bit XOSC_RDY.
	PRCI_HFXOSCCFG_XOSC_RDY = 0x20000000
	// Position of XOSCCFG_EN field.
	PRCI_HFXOSCCFG_XOSCCFG_EN_Pos = 0x1e
	// Bit mask of XOSCCFG_EN field.
	PRCI_HFXOSCCFG_XOSCCFG_EN_Msk = 0x40000000
	// Bit XOSCCFG_EN.
	PRCI_HFXOSCCFG_XOSCCFG_EN = 0x40000000

	// COREPLLCFG0: Core PLL Configuration Register
	// Position of DIVR field.
	PRCI_COREPLLCFG0_DIVR_Pos = 0x0
	// Bit mask of DIVR field.
	PRCI_COREPLLCFG0_DIVR_Msk = 0x3f
	// Position of DIVF field.
	PRCI_COREPLLCFG0_DIVF_Pos = 0x6
	// Bit mask of DIVF field.
	PRCI_COREPLLCFG0_DIVF_Msk = 0x7fc0
	// Position of DIVQ field.
	PRCI_COREPLLCFG0_DIVQ_Pos = 0xf
	// Bit mask of DIVQ field.
	PRCI_COREPLLCFG0_DIVQ_Msk = 0x38000
	// Position of RANGE field.
	PRCI_COREPLLCFG0_RANGE_Pos = 0x12
	// Bit mask of RANGE field.
	PRCI_COREPLLCFG0_RANGE_Msk = 0x1c0000
	// Position of BYPASS field.
	PRCI_COREPLLCFG0_BYPASS_Pos = 0x18
	// Bit mask of BYPASS field.
	PRCI_COREPLLCFG0_BYPASS_Msk = 0x1000000
	// Bit BYPASS.
	PRCI_COREPLLCFG0_BYPASS = 0x1000000
	// Position of FSE field.
	PRCI_COREPLLCFG0_FSE_Pos = 0x19
	// Bit mask of FSE field.
	PRCI_COREPLLCFG0_FSE_Msk = 0x2000000
	// Bit FSE.
	PRCI_COREPLLCFG0_FSE = 0x2000000
	// Position of LOCK field.
	PRCI_COREPLLCFG0_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	PRCI_COREPLLCFG0_LOCK_Msk = 0x80000000
	// Bit LOCK.
	PRCI_COREPLLCFG0_LOCK = 0x80000000

	// DDRPLLCFG0: DDR PLL Configuration Register
	// Position of DIVR field.
	PRCI_DDRPLLCFG0_DIVR_Pos = 0x0
	// Bit mask of DIVR field.
	PRCI_DDRPLLCFG0_DIVR_Msk = 0x3f
	// Position of DIVF field.
	PRCI_DDRPLLCFG0_DIVF_Pos = 0x6
	// Bit mask of DIVF field.
	PRCI_DDRPLLCFG0_DIVF_Msk = 0x7fc0
	// Position of DIVQ field.
	PRCI_DDRPLLCFG0_DIVQ_Pos = 0xf
	// Bit mask of DIVQ field.
	PRCI_DDRPLLCFG0_DIVQ_Msk = 0x38000
	// Position of RANGE field.
	PRCI_DDRPLLCFG0_RANGE_Pos = 0x12
	// Bit mask of RANGE field.
	PRCI_DDRPLLCFG0_RANGE_Msk = 0x1c0000
	// Position of BYPASS field.
	PRCI_DDRPLLCFG0_BYPASS_Pos = 0x18
	// Bit mask of BYPASS field.
	PRCI_DDRPLLCFG0_BYPASS_Msk = 0x1000000
	// Bit BYPASS.
	PRCI_DDRPLLCFG0_BYPASS = 0x1000000
	// Position of FSE field.
	PRCI_DDRPLLCFG0_FSE_Pos = 0x19
	// Bit mask of FSE field.
	PRCI_DDRPLLCFG0_FSE_Msk = 0x2000000
	// Bit FSE.
	PRCI_DDRPLLCFG0_FSE = 0x2000000
	// Position of LOCK field.
	PRCI_DDRPLLCFG0_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	PRCI_DDRPLLCFG0_LOCK_Msk = 0x80000000
	// Bit LOCK.
	PRCI_DDRPLLCFG0_LOCK = 0x80000000

	// DDRPLLCFG1: DDR PLL Configuration Register
	// Position of CKE field.
	PRCI_DDRPLLCFG1_CKE_Pos = 0x18
	// Bit mask of CKE field.
	PRCI_DDRPLLCFG1_CKE_Msk = 0x1000000
	// Bit CKE.
	PRCI_DDRPLLCFG1_CKE = 0x1000000

	// GEMGXLPLLCFG0: Gigabit Ethernet PLL Configuration Register
	// Position of DIVR field.
	PRCI_GEMGXLPLLCFG0_DIVR_Pos = 0x0
	// Bit mask of DIVR field.
	PRCI_GEMGXLPLLCFG0_DIVR_Msk = 0x3f
	// Position of DIVF field.
	PRCI_GEMGXLPLLCFG0_DIVF_Pos = 0x6
	// Bit mask of DIVF field.
	PRCI_GEMGXLPLLCFG0_DIVF_Msk = 0x7fc0
	// Position of DIVQ field.
	PRCI_GEMGXLPLLCFG0_DIVQ_Pos = 0xf
	// Bit mask of DIVQ field.
	PRCI_GEMGXLPLLCFG0_DIVQ_Msk = 0x38000
	// Position of RANGE field.
	PRCI_GEMGXLPLLCFG0_RANGE_Pos = 0x12
	// Bit mask of RANGE field.
	PRCI_GEMGXLPLLCFG0_RANGE_Msk = 0x1c0000
	// Position of BYPASS field.
	PRCI_GEMGXLPLLCFG0_BYPASS_Pos = 0x18
	// Bit mask of BYPASS field.
	PRCI_GEMGXLPLLCFG0_BYPASS_Msk = 0x1000000
	// Bit BYPASS.
	PRCI_GEMGXLPLLCFG0_BYPASS = 0x1000000
	// Position of FSE field.
	PRCI_GEMGXLPLLCFG0_FSE_Pos = 0x19
	// Bit mask of FSE field.
	PRCI_GEMGXLPLLCFG0_FSE_Msk = 0x2000000
	// Bit FSE.
	PRCI_GEMGXLPLLCFG0_FSE = 0x2000000
	// Position of LOCK field.
	PRCI_GEMGXLPLLCFG0_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	PRCI_GEMGXLPLLCFG0_LOCK_Msk = 0x80000000
	// Bit LOCK.
	PRCI_GEMGXLPLLCFG0_LOCK = 0x80000000

	// GEMGXLPLLCFG1: Gigabit Ethernet PLL Configuration Register
	// Position of CKE field.
	PRCI_GEMGXLPLLCFG1_CKE_Pos = 0x18
	// Bit mask of CKE field.
	PRCI_GEMGXLPLLCFG1_CKE_Msk = 0x1000000
	// Bit CKE.
	PRCI_GEMGXLPLLCFG1_CKE = 0x1000000

	// CORECLKSEL: CORECLK Source Selection Register
	// Position of CORECLKSEL field.
	PRCI_CORECLKSEL_CORECLKSEL_Pos = 0x0
	// Bit mask of CORECLKSEL field.
	PRCI_CORECLKSEL_CORECLKSEL_Msk = 0x1
	// Bit CORECLKSEL.
	PRCI_CORECLKSEL_CORECLKSEL = 0x1

	// DEVICESRESETREG: Peripheral Devices Reset Control Register
	// Position of DDR_CTRL_RST_N field.
	PRCI_DEVICESRESETREG_DDR_CTRL_RST_N_Pos = 0x0
	// Bit mask of DDR_CTRL_RST_N field.
	PRCI_DEVICESRESETREG_DDR_CTRL_RST_N_Msk = 0x1
	// Bit DDR_CTRL_RST_N.
	PRCI_DEVICESRESETREG_DDR_CTRL_RST_N = 0x1
	// Position of DDR_AXI_RST_N field.
	PRCI_DEVICESRESETREG_DDR_AXI_RST_N_Pos = 0x1
	// Bit mask of DDR_AXI_RST_N field.
	PRCI_DEVICESRESETREG_DDR_AXI_RST_N_Msk = 0x2
	// Bit DDR_AXI_RST_N.
	PRCI_DEVICESRESETREG_DDR_AXI_RST_N = 0x2
	// Position of DDR_AHB_RST_N field.
	PRCI_DEVICESRESETREG_DDR_AHB_RST_N_Pos = 0x2
	// Bit mask of DDR_AHB_RST_N field.
	PRCI_DEVICESRESETREG_DDR_AHB_RST_N_Msk = 0x4
	// Bit DDR_AHB_RST_N.
	PRCI_DEVICESRESETREG_DDR_AHB_RST_N = 0x4
	// Position of DDR_PHY_RST_N field.
	PRCI_DEVICESRESETREG_DDR_PHY_RST_N_Pos = 0x3
	// Bit mask of DDR_PHY_RST_N field.
	PRCI_DEVICESRESETREG_DDR_PHY_RST_N_Msk = 0x8
	// Bit DDR_PHY_RST_N.
	PRCI_DEVICESRESETREG_DDR_PHY_RST_N = 0x8
	// Position of GEMGXL_RST_N field.
	PRCI_DEVICESRESETREG_GEMGXL_RST_N_Pos = 0x5
	// Bit mask of GEMGXL_RST_N field.
	PRCI_DEVICESRESETREG_GEMGXL_RST_N_Msk = 0x20
	// Bit GEMGXL_RST_N.
	PRCI_DEVICESRESETREG_GEMGXL_RST_N = 0x20

	// CLKMUXSTATUS: CLKMUX Status Register
	// Position of CORECLKPLLSEL field.
	PRCI_CLKMUXSTATUS_CORECLKPLLSEL_Pos = 0x0
	// Bit mask of CORECLKPLLSEL field.
	PRCI_CLKMUXSTATUS_CORECLKPLLSEL_Msk = 0x1
	// Bit CORECLKPLLSEL.
	PRCI_CLKMUXSTATUS_CORECLKPLLSEL = 0x1
	// Position of TLCLKSEL field.
	PRCI_CLKMUXSTATUS_TLCLKSEL_Pos = 0x1
	// Bit mask of TLCLKSEL field.
	PRCI_CLKMUXSTATUS_TLCLKSEL_Msk = 0x2
	// Bit TLCLKSEL.
	PRCI_CLKMUXSTATUS_TLCLKSEL = 0x2
	// Position of RTCXSEL field.
	PRCI_CLKMUXSTATUS_RTCXSEL_Pos = 0x2
	// Bit mask of RTCXSEL field.
	PRCI_CLKMUXSTATUS_RTCXSEL_Msk = 0x4
	// Bit RTCXSEL.
	PRCI_CLKMUXSTATUS_RTCXSEL = 0x4
	// Position of DDRCTRLCLKSEL field.
	PRCI_CLKMUXSTATUS_DDRCTRLCLKSEL_Pos = 0x3
	// Bit mask of DDRCTRLCLKSEL field.
	PRCI_CLKMUXSTATUS_DDRCTRLCLKSEL_Msk = 0x8
	// Bit DDRCTRLCLKSEL.
	PRCI_CLKMUXSTATUS_DDRCTRLCLKSEL = 0x8
	// Position of DDRPHYCLKSEL field.
	PRCI_CLKMUXSTATUS_DDRPHYCLKSEL_Pos = 0x4
	// Bit mask of DDRPHYCLKSEL field.
	PRCI_CLKMUXSTATUS_DDRPHYCLKSEL_Msk = 0x10
	// Bit DDRPHYCLKSEL.
	PRCI_CLKMUXSTATUS_DDRPHYCLKSEL = 0x10
	// Position of GEMGXLCLKSEL field.
	PRCI_CLKMUXSTATUS_GEMGXLCLKSEL_Pos = 0x6
	// Bit mask of GEMGXLCLKSEL field.
	PRCI_CLKMUXSTATUS_GEMGXLCLKSEL_Msk = 0x40
	// Bit GEMGXLCLKSEL.
	PRCI_CLKMUXSTATUS_GEMGXLCLKSEL = 0x40

	// PROCMONCFG: PROCMON Configuration Register
	// Position of CORECLKSEL field.
	PRCI_PROCMONCFG_CORECLKSEL_Pos = 0x18
	// Bit mask of CORECLKSEL field.
	PRCI_PROCMONCFG_CORECLKSEL_Msk = 0x1000000
	// Bit CORECLKSEL.
	PRCI_PROCMONCFG_CORECLKSEL = 0x1000000
)

// Constants for UART0: Universal Asynchronous Receiver Transmitter 0
const (
	// TXDATA: Transmit Data Register
	// Position of DATA field.
	UART_TXDATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	UART_TXDATA_DATA_Msk = 0xff
	// Position of FULL field.
	UART_TXDATA_FULL_Pos = 0x1f
	// Bit mask of FULL field.
	UART_TXDATA_FULL_Msk = 0x80000000
	// Bit FULL.
	UART_TXDATA_FULL = 0x80000000

	// RXDATA: Receive Data Register
	// Position of DATA field.
	UART_RXDATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	UART_RXDATA_DATA_Msk = 0xff
	// Position of EMPTY field.
	UART_RXDATA_EMPTY_Pos = 0x1f
	// Bit mask of EMPTY field.
	UART_RXDATA_EMPTY_Msk = 0x80000000
	// Bit EMPTY.
	UART_RXDATA_EMPTY = 0x80000000

	// TXCTRL: Transmit Control Register
	// Position of TXEN field.
	UART_TXCTRL_TXEN_Pos = 0x0
	// Bit mask of TXEN field.
	UART_TXCTRL_TXEN_Msk = 0x1
	// Bit TXEN.
	UART_TXCTRL_TXEN = 0x1
	// Position of NSTOP field.
	UART_TXCTRL_NSTOP_Pos = 0x1
	// Bit mask of NSTOP field.
	UART_TXCTRL_NSTOP_Msk = 0x2
	// Bit NSTOP.
	UART_TXCTRL_NSTOP = 0x2
	// Position of TXCNT field.
	UART_TXCTRL_TXCNT_Pos = 0x10
	// Bit mask of TXCNT field.
	UART_TXCTRL_TXCNT_Msk = 0x70000

	// RXCTRL: Receive Control Register
	// Position of RXEN field.
	UART_RXCTRL_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	UART_RXCTRL_RXEN_Msk = 0x1
	// Bit RXEN.
	UART_RXCTRL_RXEN = 0x1
	// Position of RXCNT field.
	UART_RXCTRL_RXCNT_Pos = 0x10
	// Bit mask of RXCNT field.
	UART_RXCTRL_RXCNT_Msk = 0x70000

	// IE: Interrupt Enable Register
	// Position of TXWM field.
	UART_IE_TXWM_Pos = 0x0
	// Bit mask of TXWM field.
	UART_IE_TXWM_Msk = 0x1
	// Bit TXWM.
	UART_IE_TXWM = 0x1
	// Position of RXWM field.
	UART_IE_RXWM_Pos = 0x1
	// Bit mask of RXWM field.
	UART_IE_RXWM_Msk = 0x2
	// Bit RXWM.
	UART_IE_RXWM = 0x2

	// IP: Interrupt Pending Register
	// Position of TXWM field.
	UART_IP_TXWM_Pos = 0x0
	// Bit mask of TXWM field.
	UART_IP_TXWM_Msk = 0x1
	// Bit TXWM.
	UART_IP_TXWM = 0x1
	// Position of RXWM field.
	UART_IP_RXWM_Pos = 0x1
	// Bit mask of RXWM field.
	UART_IP_RXWM_Msk = 0x2
	// Bit RXWM.
	UART_IP_RXWM = 0x2

	// DIV: Baud Rate Divisor Register
	// Position of DIV field.
	UART_DIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	UART_DIV_DIV_Msk = 0xfffff
)
