/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

final class Column
extends TableColumn<Class<?>>
implements Serializable {
    private static final long serialVersionUID = -6297242452383159294L;
    static final Column SOURCE = new Column(false);
    static final Column TARGET = new Column(true);
    private final boolean target;

    private Column(boolean bl) {
        super(Class.class, bl ? "target" : "source");
        this.target = bl;
    }

    @Override
    public InternationalString getHeader() {
        return Vocabulary.formatInternational(this.target ? (short)61 : 182);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.target ? TARGET : SOURCE;
    }

    static TreeTable createTable() {
        return new DefaultTreeTable(TARGET, SOURCE);
    }

    static void toTree(ObjectConverter<?, ?> objectConverter, TreeTable.Node node) {
        TreeTable.Node node2 = node.newChild();
        node2.setValue(SOURCE, objectConverter.getSourceClass());
        node2.setValue(TARGET, objectConverter.getTargetClass());
    }

    static String format(TreeTable treeTable) {
        TreeTableFormat treeTableFormat = new TreeTableFormat(null, null);
        treeTableFormat.setColumnSeparatorPattern("?[\u00a0]\u00a0\u2190\u00a0");
        return treeTableFormat.format(treeTable);
    }
}

