/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.bytecode.BytecodeFrameInfo;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLFrameInfo;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@ReportPolymorphism
@GenerateUncached
@GenerateInline(value=false)
public abstract class MaterializeFrameNode
extends Node {
    @NeverDefault
    public static MaterializeFrameNode create() {
        return MaterializeFrameNodeGen.create();
    }

    public static MaterializeFrameNode getUncached() {
        return MaterializeFrameNodeGen.getUncached();
    }

    public final PFrame execute(Frame frame, Node location, boolean markAsEscaped, boolean forceSync) {
        return this.execute(location, markAsEscaped, forceSync, frame);
    }

    public final PFrame executeOnStack(boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize) {
        PFrame.Reference info = PArguments.getCurrentFrameInfo(frameToMaterialize);
        RootNode location = info.getRootNode();
        if (location instanceof PBytecodeDSLRootNode) {
            PBytecodeDSLRootNode rootNode = (PBytecodeDSLRootNode)location;
            location = rootNode.getBytecodeNode();
        }
        return this.execute((Node)location, markAsEscaped, forceSync, frameToMaterialize);
    }

    public abstract PFrame execute(Node var1, boolean var2, boolean var3, Frame var4);

    @Specialization(guards={"cachedFD == frameToMaterialize.getFrameDescriptor()", "getPFrame(frameToMaterialize) == null", "!hasGeneratorFrame(frameToMaterialize)", "!hasCustomLocals(frameToMaterialize)"}, limit="1")
    static PFrame freshPFrameCachedFD(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Cached(value="frameToMaterialize.getFrameDescriptor()") FrameDescriptor cachedFD, @Bind PythonLanguage language, @Cached.Shared(value="syncValuesNode") @Cached SyncFrameValuesNode syncValuesNode) {
        MaterializedFrame locals = MaterializeFrameNode.createLocalsFrame(cachedFD);
        PFrame escapedFrame = PFactory.createPFrame(language, PArguments.getCurrentFrameInfo(frameToMaterialize), location, locals);
        return MaterializeFrameNode.doEscapeFrame(frameToMaterialize, escapedFrame, markAsEscaped, forceSync, location, syncValuesNode);
    }

    @Specialization(guards={"getPFrame(frameToMaterialize) == null", "!hasGeneratorFrame(frameToMaterialize)", "!hasCustomLocals(frameToMaterialize)"}, replaces={"freshPFrameCachedFD"})
    static PFrame freshPFrame(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Bind PythonLanguage language, @Cached.Shared(value="syncValuesNode") @Cached SyncFrameValuesNode syncValuesNode) {
        MaterializedFrame locals = MaterializeFrameNode.createLocalsFrame(frameToMaterialize.getFrameDescriptor());
        PFrame escapedFrame = PFactory.createPFrame(language, PArguments.getCurrentFrameInfo(frameToMaterialize), location, locals);
        return MaterializeFrameNode.doEscapeFrame(frameToMaterialize, escapedFrame, markAsEscaped, forceSync, location, syncValuesNode);
    }

    @Specialization(guards={"getPFrame(frameToMaterialize) == null", "!hasGeneratorFrame(frameToMaterialize)", "hasCustomLocals(frameToMaterialize)"})
    static PFrame freshPFrameCusstomLocals(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Bind PythonLanguage language) {
        PFrame escapedFrame = PFactory.createPFrame(language, PArguments.getCurrentFrameInfo(frameToMaterialize), location, null);
        escapedFrame.setLocalsDict(PArguments.getSpecialArgument(frameToMaterialize));
        return MaterializeFrameNode.doEscapeFrame(frameToMaterialize, escapedFrame, markAsEscaped, false, location, null);
    }

    @Specialization(guards={"getPFrame(frameToMaterialize) == null", "hasGeneratorFrame(frameToMaterialize)"})
    static PFrame freshPFrameForGenerator(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize) {
        MaterializedFrame generatorFrame = PArguments.getGeneratorFrame(frameToMaterialize);
        PFrame.Reference frameRef = PArguments.getCurrentFrameInfo(frameToMaterialize);
        PFrame escapedFrame = MaterializeFrameNode.materializeGeneratorFrame(location, generatorFrame, frameRef);
        frameRef.setPyFrame(escapedFrame);
        return MaterializeFrameNode.doEscapeFrame(frameToMaterialize, escapedFrame, markAsEscaped, false, location, null);
    }

    @Specialization(guards={"getPFrame(frameToMaterialize) != null"})
    static PFrame alreadyEscapedFrame(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Bind Node inliningTarget, @Cached.Shared(value="syncValuesNode") @Cached SyncFrameValuesNode syncValuesNode, @Cached InlinedConditionProfile syncProfile) {
        PFrame pyFrame = MaterializeFrameNode.getPFrame(frameToMaterialize);
        if (syncProfile.profile(inliningTarget, forceSync && !MaterializeFrameNode.hasGeneratorFrame(frameToMaterialize))) {
            syncValuesNode.execute(pyFrame, frameToMaterialize);
        }
        if (markAsEscaped) {
            pyFrame.getRef().markAsEscaped();
        }
        MaterializeFrameNode.processBytecodeFrame(frameToMaterialize, pyFrame, location);
        return pyFrame;
    }

    private static MaterializedFrame createLocalsFrame(FrameDescriptor cachedFD) {
        return Truffle.getRuntime().createMaterializedFrame(PythonUtils.EMPTY_OBJECT_ARRAY, cachedFD);
    }

    public static PFrame materializeGeneratorFrame(Node location, MaterializedFrame generatorFrame, PFrame.Reference frameRef) {
        PFrame escapedFrame = PFactory.createPFrame(PythonLanguage.get(location), frameRef, location, generatorFrame);
        PArguments.synchronizeArgs((Frame)generatorFrame, escapedFrame);
        return escapedFrame;
    }

    private static void processBytecodeFrame(Frame frameToMaterialize, PFrame pyFrame, Node location) {
        Object info = frameToMaterialize.getFrameDescriptor().getInfo();
        if (info == null) {
            return;
        }
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            BytecodeNode bytecodeNode = BytecodeNode.get((Node)location);
            if (bytecodeNode == null) {
                pyFrame.setBci(-1);
                pyFrame.setLocation(location);
            } else {
                pyFrame.setBci(bytecodeNode.getBytecodeIndex(frameToMaterialize));
                pyFrame.setLocation((Node)bytecodeNode);
            }
        } else {
            BytecodeFrameInfo bytecodeFrameInfo = (BytecodeFrameInfo)info;
            pyFrame.setBci(bytecodeFrameInfo.getBci(frameToMaterialize));
            pyFrame.setLocation((Node)bytecodeFrameInfo.getRootNode());
        }
    }

    private static PFrame doEscapeFrame(Frame frameToMaterialize, PFrame escapedFrame, boolean markAsEscaped, boolean forceSync, Node location, SyncFrameValuesNode syncValuesNode) {
        PFrame.Reference topFrameRef = PArguments.getCurrentFrameInfo(frameToMaterialize);
        topFrameRef.setPyFrame(escapedFrame);
        PArguments.synchronizeArgs(frameToMaterialize, escapedFrame);
        if (forceSync) {
            syncValuesNode.execute(escapedFrame, frameToMaterialize);
        }
        if (markAsEscaped) {
            topFrameRef.markAsEscaped();
        }
        MaterializeFrameNode.processBytecodeFrame(frameToMaterialize, escapedFrame, location);
        return escapedFrame;
    }

    protected static boolean hasGeneratorFrame(Frame frame) {
        return !PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER && PArguments.getGeneratorFrame(frame) != null;
    }

    protected static boolean hasCustomLocals(Frame frame) {
        return PArguments.getSpecialArgument(frame) != null;
    }

    protected static PFrame getPFrame(Frame frame) {
        return PArguments.getCurrentFrameInfo(frame).getPyFrame();
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class SyncFrameValuesNode
    extends Node {
        public abstract void execute(PFrame var1, Frame var2);

        @Specialization(guards={"!pyFrame.hasCustomLocals()", "frameToSync.getFrameDescriptor() == cachedFd", "variableSlotCount(cachedFd) < 32"}, limit="1")
        @ExplodeLoop
        static void doSyncExploded(PFrame pyFrame, Frame frameToSync, @Cached(value="frameToSync.getFrameDescriptor()") FrameDescriptor cachedFd) {
            MaterializedFrame target = pyFrame.getLocals();
            assert (cachedFd == target.getFrameDescriptor());
            int slotCount = SyncFrameValuesNode.variableSlotCount(cachedFd);
            if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                FrameInfo info = (FrameInfo)cachedFd.getInfo();
                if (info instanceof BytecodeDSLFrameInfo) {
                    BytecodeDSLFrameInfo bytecodeDSLFrameInfo = (BytecodeDSLFrameInfo)info;
                    PBytecodeDSLRootNode rootNode = bytecodeDSLFrameInfo.getRootNode();
                    rootNode.getBytecodeNode().copyLocalValues(0, frameToSync, (Frame)target, 0, slotCount);
                }
            } else {
                for (int i = 0; i < slotCount; ++i) {
                    PythonUtils.copyFrameSlot(frameToSync, target, i);
                }
            }
        }

        @Specialization(guards={"!pyFrame.hasCustomLocals()"}, replaces={"doSyncExploded"})
        @ExplodeLoop
        static void doSync(PFrame pyFrame, Frame frameToSync) {
            MaterializedFrame target = pyFrame.getLocals();
            FrameDescriptor fd = target.getFrameDescriptor();
            int slotCount = SyncFrameValuesNode.variableSlotCount(fd);
            if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                FrameInfo info = (FrameInfo)fd.getInfo();
                if (info instanceof BytecodeDSLFrameInfo) {
                    BytecodeDSLFrameInfo bytecodeDSLFrameInfo = (BytecodeDSLFrameInfo)info;
                    PBytecodeDSLRootNode rootNode = bytecodeDSLFrameInfo.getRootNode();
                    rootNode.getBytecodeNode().copyLocalValues(0, frameToSync, (Frame)target, 0, slotCount);
                }
            } else {
                for (int i = 0; i < slotCount; ++i) {
                    PythonUtils.copyFrameSlot(frameToSync, target, i);
                }
            }
        }

        @Specialization(guards={"pyFrame.hasCustomLocals()"})
        static void doCustomLocals(PFrame pyFrame, Frame frameToSync) {
        }

        @Idempotent
        protected static int variableSlotCount(FrameDescriptor fd) {
            FrameInfo info = (FrameInfo)fd.getInfo();
            if (info == null) {
                return 0;
            }
            return info.getVariableCount();
        }
    }
}

