/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.copying;

import com.oracle.graal.python.builtins.objects.cext.copying.SharedObject;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.io.TruffleProcessBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

final class PEFile
extends SharedObject {
    private final PythonContext context;
    private final TruffleFile tempfile;

    PEFile(byte[] b, PythonContext context) throws IOException {
        this.context = context;
        this.tempfile = context.getEnv().createTempFile(null, null, ".dll", new FileAttribute[0]);
        try (OutputStream os = this.tempfile.newOutputStream(new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE});){
            os.write(b);
        }
    }

    @Override
    public void setId(String newId) throws IOException {
    }

    private String getDelvewheelPython() {
        TruffleFile python;
        TruffleFile delvewheel = PEFile.which(this.context, "delvewheel.exe");
        if (!delvewheel.exists(new LinkOption[0])) {
            delvewheel = PEFile.which(this.context, "delvewheel.bat");
        }
        if (!delvewheel.exists(new LinkOption[0])) {
            delvewheel = PEFile.which(this.context, "delvewheel.cmd");
        }
        if (!(python = delvewheel.resolveSibling("python.exe")).exists(new LinkOption[0])) {
            python = delvewheel.resolveSibling("python.bat");
        }
        if (!python.exists(new LinkOption[0])) {
            python = delvewheel.resolveSibling("python.cmd");
        }
        if (!python.exists(new LinkOption[0])) {
            python = delvewheel.getParent().resolveSibling("python.exe");
        }
        if (!python.exists(new LinkOption[0])) {
            python = delvewheel.getParent().resolveSibling("python.bat");
        }
        if (!python.exists(new LinkOption[0])) {
            python = delvewheel.getParent().resolveSibling("python.cmd");
        }
        return python.toString();
    }

    @Override
    public void changeOrAddDependency(String oldName, String newName) throws IOException, InterruptedException {
        TruffleProcessBuilder pb = PEFile.newProcessBuilder(this.context);
        String tempfileWithForwardSlashes = this.tempfile.toString().replace('\\', '/');
        String pythonExe = this.getDelvewheelPython();
        pb.command(new String[]{pythonExe, "-c", String.format("from delvewheel import _dll_utils; _dll_utils.replace_needed('%s', ['%s'], {'%s': '%s'}, strip=True, verbose=2, test=[])", tempfileWithForwardSlashes, oldName, oldName, newName)});
        Process proc = pb.start();
        if (proc.waitFor() != 0) {
            throw new IOException("Failed to run `delvewheel` 1.9.0 to copy required DLL. Make sure you have it installed in your venv.");
        }
    }

    @Override
    public void write(TruffleFile copy) throws IOException {
        this.tempfile.copy(copy, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES});
    }

    @Override
    public void close() throws IOException {
        this.tempfile.delete();
    }
}

