/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonBuffer;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonGeneratorImpl;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.parser.JsonParserImpl;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public final class OracleJsonFactory {
    private static final boolean DISABLE_GENERATOR_POOL;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final OsonGeneratorImpl.OsonGeneratorStatePool generatorPool = DISABLE_GENERATOR_POOL ? null : new OsonGeneratorImpl.OsonGeneratorStatePool();
    private final BufferPoolImpl bufferPool = new BufferPoolImpl();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    public OracleJsonParser createJsonBinaryParser(InputStream in) throws OracleJsonException {
        byte[] bytes = OracleJsonFactory.readInputStream(in);
        ByteBuffer b2 = ByteBuffer.wrap(bytes);
        OsonContext ctx = new OsonContext(new OsonBuffer(b2));
        OsonParserImpl result = new OsonParserImpl(ctx);
        result.setCloseable(in);
        return result;
    }

    public OracleJsonParser createJsonTextParser(InputStream in) throws OracleJsonException {
        return new JsonParserImpl(in, this.bufferPool);
    }

    public OracleJsonParser createJsonTextParser(Reader in) throws OracleJsonException {
        return new JsonParserImpl(in, this.bufferPool);
    }

    public OracleJsonParser createJsonBinaryParser(ByteBuffer in) throws OracleJsonException {
        OsonContext ctx = new OsonContext(new OsonBuffer(in));
        return new OsonParserImpl(ctx);
    }

    public OracleJsonValue createJsonBinaryValue(InputStream in) throws OracleJsonException {
        byte[] bytes = OracleJsonFactory.readInputStream(in);
        ByteBuffer b2 = ByteBuffer.wrap(bytes);
        return this.createJsonBinaryValue(b2);
    }

    public OracleJsonValue createJsonTextValue(InputStream in) throws OracleJsonException {
        try (OracleJsonParser parser = this.createJsonTextParser(in);){
            parser.next();
            OracleJsonValue oracleJsonValue = parser.getValue();
            return oracleJsonValue;
        }
    }

    public OracleJsonValue createJsonTextValue(Reader in) throws OracleJsonException {
        try (OracleJsonParser parser = this.createJsonTextParser(in);){
            parser.next();
            OracleJsonValue oracleJsonValue = parser.getValue();
            return oracleJsonValue;
        }
    }

    public OracleJsonValue createJsonBinaryValue(ByteBuffer in) throws OracleJsonException {
        OsonContext ctx = new OsonContext(new OsonBuffer(in));
        int offset = ctx.getHeader().getTreeSegmentOffset();
        return (OracleJsonValue)OsonStructureImpl.getValueInternal(offset, ctx.getFactory(), ctx);
    }

    public final OracleJsonGenerator createJsonBinaryGenerator(OutputStream out) {
        return new OsonGeneratorImpl(this.generatorPool, out);
    }

    public OracleJsonGenerator createJsonTextGenerator(OutputStream out) {
        return new JsonSerializerImpl(out);
    }

    public OracleJsonGenerator createJsonTextGenerator(Writer out) {
        return new JsonSerializerImpl(out);
    }

    public OracleJsonObject createObject() {
        return new OracleJsonObjectImpl();
    }

    public OracleJsonArray createArray() {
        return new OracleJsonArrayImpl();
    }

    public OracleJsonObject createObject(OracleJsonObject other) {
        return new OracleJsonObjectImpl(other);
    }

    public OracleJsonArray createArray(OracleJsonArray other) {
        return new OracleJsonArrayImpl(other);
    }

    public OracleJsonString createString(String value) {
        return new OracleJsonStringImpl(value);
    }

    public OracleJsonDecimal createDecimal(BigDecimal value) throws OracleJsonException {
        return new OracleJsonDecimalImpl(value);
    }

    public OracleJsonDecimal createDecimal(int value) {
        return new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.INT);
    }

    public OracleJsonDecimal createDecimal(long value) {
        return new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.LONG);
    }

    public OracleJsonFloat createFloat(float value) {
        return new OracleJsonFloatImpl(value);
    }

    public OracleJsonDouble createDouble(double value) {
        return new OracleJsonDoubleImpl(value);
    }

    public OracleJsonBinary createBinary(byte[] value) {
        return new OracleJsonBinaryImpl(value, false);
    }

    public OracleJsonValue createBoolean(boolean value) {
        return value ? OracleJsonValue.TRUE : OracleJsonValue.FALSE;
    }

    public OracleJsonValue createNull() {
        return OracleJsonValue.NULL;
    }

    public OracleJsonTimestamp createTimestamp(LocalDateTime value) {
        return new OracleJsonTimestampImpl(value);
    }

    public OracleJsonDate createDate(LocalDateTime i2) {
        return new OracleJsonDateImpl(i2);
    }

    public OracleJsonTimestampTZ createTimestampTZ(OffsetDateTime i2) {
        return new OracleJsonTimestampTZImpl(i2);
    }

    public OracleJsonIntervalDS createIntervalDS(Duration d2) {
        return new OracleJsonIntervalDSImpl(d2);
    }

    public OracleJsonIntervalYM createIntervalYM(Period p2) {
        return new OracleJsonIntervalYMImpl(p2);
    }

    public OracleJsonValue createValue(Datum datum) {
        try {
            if (datum instanceof CHAR) {
                return new OracleJsonStringImpl(datum.stringValue());
            }
            if (datum instanceof NUMBER) {
                return new OracleJsonDecimalImpl(datum.getBytes(), null);
            }
            if (datum instanceof BINARY_DOUBLE) {
                return new OracleJsonDoubleImpl(datum.doubleValue());
            }
            if (datum instanceof BINARY_FLOAT) {
                return new OracleJsonFloatImpl(datum.floatValue());
            }
            if (datum instanceof RAW) {
                return new OracleJsonBinaryImpl(datum.getBytes(), false);
            }
            if (datum instanceof DATE) {
                return new OracleJsonDateImpl(datum.getBytes());
            }
            if (datum instanceof TIMESTAMP) {
                return new OracleJsonTimestampImpl(datum.getBytes());
            }
            if (datum instanceof INTERVALDS) {
                return new OracleJsonIntervalDSImpl(datum.getBytes());
            }
            if (datum instanceof INTERVALYM) {
                return new OracleJsonIntervalYMImpl(datum.getBytes());
            }
            if (datum instanceof OracleJsonDatum) {
                OracleJsonDatum jdatum = (OracleJsonDatum)datum;
                return this.createJsonBinaryValue(ByteBuffer.wrap(jdatum.shareBytes()));
            }
            if (datum instanceof TIMESTAMPTZ) {
                return new OracleJsonTimestampTZImpl(datum.getBytes());
            }
            throw new UnsupportedOperationException();
        }
        catch (SQLException e2) {
            throw new OracleJsonException(e2.getMessage(), e2);
        }
    }

    private static byte[] readInputStream(InputStream in) throws OracleJsonException {
        try {
            int n2;
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((n2 = in.read(buffer)) != -1) {
                baos.write(buffer, 0, n2);
            }
            in.close();
            return baos.toByteArray();
        }
        catch (IOException e2) {
            throw OracleJsonExceptions.IO.create(OracleJsonExceptions.ORACLE_FACTORY, e2, new Object[0]);
        }
    }

    static {
        try {
            $$$methodRef$$$31 = OracleJsonFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleJsonFactory.class.getDeclaredMethod("readInputStream", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleJsonFactory.class.getDeclaredMethod("createValue", Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleJsonFactory.class.getDeclaredMethod("createIntervalYM", Period.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleJsonFactory.class.getDeclaredMethod("createIntervalDS", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleJsonFactory.class.getDeclaredMethod("createTimestampTZ", OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleJsonFactory.class.getDeclaredMethod("createDate", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleJsonFactory.class.getDeclaredMethod("createTimestamp", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleJsonFactory.class.getDeclaredMethod("createNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleJsonFactory.class.getDeclaredMethod("createBoolean", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleJsonFactory.class.getDeclaredMethod("createBinary", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleJsonFactory.class.getDeclaredMethod("createDouble", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleJsonFactory.class.getDeclaredMethod("createFloat", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleJsonFactory.class.getDeclaredMethod("createDecimal", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleJsonFactory.class.getDeclaredMethod("createDecimal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleJsonFactory.class.getDeclaredMethod("createDecimal", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleJsonFactory.class.getDeclaredMethod("createString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleJsonFactory.class.getDeclaredMethod("createArray", OracleJsonArray.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleJsonFactory.class.getDeclaredMethod("createObject", OracleJsonObject.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleJsonFactory.class.getDeclaredMethod("createArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleJsonFactory.class.getDeclaredMethod("createObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleJsonFactory.class.getDeclaredMethod("createJsonTextGenerator", Writer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleJsonFactory.class.getDeclaredMethod("createJsonTextGenerator", OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleJsonFactory.class.getDeclaredMethod("createJsonBinaryGenerator", OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleJsonFactory.class.getDeclaredMethod("createJsonBinaryValue", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleJsonFactory.class.getDeclaredMethod("createJsonTextValue", Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleJsonFactory.class.getDeclaredMethod("createJsonTextValue", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleJsonFactory.class.getDeclaredMethod("createJsonBinaryValue", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleJsonFactory.class.getDeclaredMethod("createJsonBinaryParser", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleJsonFactory.class.getDeclaredMethod("createJsonTextParser", Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleJsonFactory.class.getDeclaredMethod("createJsonTextParser", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleJsonFactory.class.getDeclaredMethod("createJsonBinaryParser", InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        DISABLE_GENERATOR_POOL = Boolean.getBoolean("oracle.sql.json.OracleJsonFactory.DISABLE_GENERATOR_POOL");
    }
}

