/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.internal.FastSafeIterableMap;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistryKt;
import androidx.lifecycle.LifecycleRegistry_desktopKt;
import androidx.lifecycle.Lifecycling;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 <2\u00020\u0001:\u0002;<B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000bH\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u000bH\u0017J\b\u0010/\u001a\u00020\u0019H\u0002J\u0010\u00100\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u00101\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u000bH\u0017J\u0010\u00105\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0010\u00106\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\b\u00107\u001a\u00020\u0019H\u0002J\u0010\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020:H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0016j\b\u0012\u0004\u0012\u00020\u000e`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010*\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u00102\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006="}, d2={"Landroidx/lifecycle/LifecycleRegistry;", "Landroidx/lifecycle/Lifecycle;", "provider", "Landroidx/lifecycle/LifecycleOwner;", "enforceMainThread", "", "<init>", "(Landroidx/lifecycle/LifecycleOwner;Z)V", "(Landroidx/lifecycle/LifecycleOwner;)V", "observerMap", "Landroidx/arch/core/internal/FastSafeIterableMap;", "Landroidx/lifecycle/LifecycleObserver;", "Landroidx/lifecycle/LifecycleRegistry$ObserverWithState;", "state", "Landroidx/lifecycle/Lifecycle$State;", "lifecycleOwner", "Ljava/lang/ref/WeakReference;", "addingObserverCounter", "", "handlingEvent", "newEventOccurred", "parentStates", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "markState", "", "currentState", "getCurrentState", "()Landroidx/lifecycle/Lifecycle$State;", "setCurrentState", "(Landroidx/lifecycle/Lifecycle$State;)V", "_currentStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "currentStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getCurrentStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "handleLifecycleEvent", "event", "Landroidx/lifecycle/Lifecycle$Event;", "moveToState", "next", "isSynced", "()Z", "calculateTargetState", "observer", "addObserver", "popParentState", "pushParentState", "removeObserver", "observerCount", "getObserverCount", "()I", "forwardPass", "backwardPass", "sync", "enforceMainThreadIfNeeded", "methodName", "", "ObserverWithState", "Companion", "lifecycle-runtime"})
@SourceDebugExtension(value={"SMAP\nLifecycleRegistry.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LifecycleRegistry.jvm.kt\nandroidx/lifecycle/LifecycleRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1#2:347\n*E\n"})
public class LifecycleRegistry
extends Lifecycle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enforceMainThread;
    @NotNull
    private FastSafeIterableMap<LifecycleObserver, ObserverWithState> observerMap;
    @NotNull
    private Lifecycle.State state;
    @NotNull
    private final WeakReference<LifecycleOwner> lifecycleOwner;
    private int addingObserverCounter;
    private boolean handlingEvent;
    private boolean newEventOccurred;
    @NotNull
    private ArrayList<Lifecycle.State> parentStates;
    @NotNull
    private final MutableStateFlow<Lifecycle.State> _currentStateFlow;

    private LifecycleRegistry(LifecycleOwner provider, boolean enforceMainThread) {
        this.enforceMainThread = enforceMainThread;
        this.observerMap = new FastSafeIterableMap();
        this.state = Lifecycle.State.INITIALIZED;
        this.parentStates = new ArrayList();
        this.lifecycleOwner = new WeakReference<LifecycleOwner>(provider);
        this._currentStateFlow = StateFlowKt.MutableStateFlow((Object)((Object)Lifecycle.State.INITIALIZED));
    }

    public LifecycleRegistry(@NotNull LifecycleOwner provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this(provider, true);
    }

    @Deprecated(message="Override [currentState].")
    @MainThread
    public void markState(@NotNull Lifecycle.State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.enforceMainThreadIfNeeded("markState");
        this.setCurrentState(state);
    }

    @Override
    @NotNull
    public Lifecycle.State getCurrentState() {
        return this.state;
    }

    public void setCurrentState(@NotNull Lifecycle.State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.enforceMainThreadIfNeeded("setCurrentState");
        this.moveToState(state);
    }

    @Override
    @NotNull
    public StateFlow<Lifecycle.State> getCurrentStateFlow() {
        return FlowKt.asStateFlow(this._currentStateFlow);
    }

    public void handleLifecycleEvent(@NotNull Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        this.enforceMainThreadIfNeeded("handleLifecycleEvent");
        this.moveToState(event.getTargetState());
    }

    private final void moveToState(Lifecycle.State next2) {
        if (this.state == next2) {
            return;
        }
        LifecycleRegistryKt.checkLifecycleStateTransition((LifecycleOwner)this.lifecycleOwner.get(), this.state, next2);
        this.state = next2;
        if (this.handlingEvent || this.addingObserverCounter != 0) {
            this.newEventOccurred = true;
            return;
        }
        this.handlingEvent = true;
        this.sync();
        this.handlingEvent = false;
        if (this.state == Lifecycle.State.DESTROYED) {
            this.observerMap = new FastSafeIterableMap();
        }
    }

    private final boolean isSynced() {
        if (this.observerMap.size() == 0) {
            return true;
        }
        Map.Entry entry = this.observerMap.eldest();
        Intrinsics.checkNotNull(entry);
        Lifecycle.State eldestObserverState = ((ObserverWithState)entry.getValue()).getState();
        Map.Entry entry2 = this.observerMap.newest();
        Intrinsics.checkNotNull(entry2);
        Lifecycle.State newestObserverState = ((ObserverWithState)entry2.getValue()).getState();
        return eldestObserverState == newestObserverState && this.state == newestObserverState;
    }

    private final Lifecycle.State calculateTargetState(LifecycleObserver observer2) {
        Map.Entry<LifecycleObserver, ObserverWithState> map = this.observerMap.ceil(observer2);
        Map.Entry<LifecycleObserver, ObserverWithState> entry = map;
        Lifecycle.State siblingState = entry != null && (entry = entry.getValue()) != null ? ((ObserverWithState)((Object)entry)).getState() : null;
        Lifecycle.State parentState = !((Collection)this.parentStates).isEmpty() ? this.parentStates.get(this.parentStates.size() - 1) : null;
        return Companion.min$lifecycle_runtime(Companion.min$lifecycle_runtime(this.state, siblingState), parentState);
    }

    @Override
    @MainThread
    public void addObserver(@NotNull LifecycleObserver observer2) {
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        this.enforceMainThreadIfNeeded("addObserver");
        Lifecycle.State initialState = this.state == Lifecycle.State.DESTROYED ? Lifecycle.State.DESTROYED : Lifecycle.State.INITIALIZED;
        ObserverWithState statefulObserver = new ObserverWithState(observer2, initialState);
        ObserverWithState previous = this.observerMap.putIfAbsent(observer2, statefulObserver);
        if (previous != null) {
            return;
        }
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.lifecycleOwner.get();
        if (lifecycleOwner == null) {
            return;
        }
        LifecycleOwner lifecycleOwner2 = lifecycleOwner;
        boolean isReentrance = this.addingObserverCounter != 0 || this.handlingEvent;
        Lifecycle.State targetState = this.calculateTargetState(observer2);
        int n = this.addingObserverCounter;
        this.addingObserverCounter = n + 1;
        while (statefulObserver.getState().compareTo((Enum)targetState) < 0 && this.observerMap.contains(observer2)) {
            Lifecycle.Event event;
            this.pushParentState(statefulObserver.getState());
            if (Lifecycle.Event.Companion.upFrom(statefulObserver.getState()) == null) {
                throw new IllegalStateException("no event up from " + statefulObserver.getState());
            }
            statefulObserver.dispatchEvent(lifecycleOwner2, event);
            this.popParentState();
            targetState = this.calculateTargetState(observer2);
        }
        if (!isReentrance) {
            this.sync();
        }
        n = this.addingObserverCounter;
        this.addingObserverCounter = n + -1;
    }

    private final void popParentState() {
        this.parentStates.remove(this.parentStates.size() - 1);
    }

    private final void pushParentState(Lifecycle.State state) {
        this.parentStates.add(state);
    }

    @Override
    @MainThread
    public void removeObserver(@NotNull LifecycleObserver observer2) {
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        this.enforceMainThreadIfNeeded("removeObserver");
        this.observerMap.remove(observer2);
    }

    public int getObserverCount() {
        this.enforceMainThreadIfNeeded("getObserverCount");
        return this.observerMap.size();
    }

    private final void forwardPass(LifecycleOwner lifecycleOwner) {
        SafeIterableMap.IteratorWithAdditions iteratorWithAdditions = this.observerMap.iteratorWithAdditions();
        Intrinsics.checkNotNullExpressionValue((Object)iteratorWithAdditions, (String)"iteratorWithAdditions(...)");
        Iterator ascendingIterator = iteratorWithAdditions;
        while (ascendingIterator.hasNext() && !this.newEventOccurred) {
            Map.Entry entry = (Map.Entry)ascendingIterator.next();
            LifecycleObserver key = (LifecycleObserver)entry.getKey();
            ObserverWithState observer2 = (ObserverWithState)entry.getValue();
            while (observer2.getState().compareTo((Enum)this.state) < 0 && !this.newEventOccurred && this.observerMap.contains(key)) {
                Lifecycle.Event event;
                this.pushParentState(observer2.getState());
                if (Lifecycle.Event.Companion.upFrom(observer2.getState()) == null) {
                    throw new IllegalStateException("no event up from " + observer2.getState());
                }
                observer2.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    private final void backwardPass(LifecycleOwner lifecycleOwner) {
        Iterator iterator2 = this.observerMap.descendingIterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"descendingIterator(...)");
        Iterator descendingIterator = iterator2;
        while (descendingIterator.hasNext() && !this.newEventOccurred) {
            Map.Entry entry = descendingIterator.next();
            Intrinsics.checkNotNull(entry);
            LifecycleObserver key = (LifecycleObserver)entry.getKey();
            ObserverWithState observer2 = (ObserverWithState)entry.getValue();
            while (observer2.getState().compareTo((Enum)this.state) > 0 && !this.newEventOccurred && this.observerMap.contains(key)) {
                Lifecycle.Event event;
                if (Lifecycle.Event.Companion.downFrom(observer2.getState()) == null) {
                    throw new IllegalStateException("no event down from " + observer2.getState());
                }
                this.pushParentState(event.getTargetState());
                observer2.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    private final void sync() {
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.lifecycleOwner.get();
        if (lifecycleOwner == null) {
            throw new IllegalStateException("LifecycleOwner of this LifecycleRegistry is already garbage collected. It is too late to change lifecycle state.");
        }
        LifecycleOwner lifecycleOwner2 = lifecycleOwner;
        while (!this.isSynced()) {
            this.newEventOccurred = false;
            Map.Entry entry = this.observerMap.eldest();
            Intrinsics.checkNotNull(entry);
            if (this.state.compareTo((Enum)((ObserverWithState)entry.getValue()).getState()) < 0) {
                this.backwardPass(lifecycleOwner2);
            }
            Map.Entry newest = this.observerMap.newest();
            if (this.newEventOccurred || newest == null || this.state.compareTo((Enum)((ObserverWithState)newest.getValue()).getState()) <= 0) continue;
            this.forwardPass(lifecycleOwner2);
        }
        this.newEventOccurred = false;
        this._currentStateFlow.setValue((Object)this.getCurrentState());
    }

    private final void enforceMainThreadIfNeeded(String methodName) {
        if (this.enforceMainThread && !LifecycleRegistry_desktopKt.isMainThread()) {
            boolean bl = false;
            String string = "Method " + methodName + " must be called on the main thread";
            throw new IllegalStateException(string.toString());
        }
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final LifecycleRegistry createUnsafe(@NotNull LifecycleOwner owner) {
        return Companion.createUnsafe(owner);
    }

    @JvmStatic
    @NotNull
    public static final Lifecycle.State min$lifecycle_runtime(@NotNull Lifecycle.State state1, @Nullable Lifecycle.State state2) {
        return Companion.min$lifecycle_runtime(state1, state2);
    }

    public /* synthetic */ LifecycleRegistry(LifecycleOwner provider, boolean enforceMainThread, DefaultConstructorMarker $constructor_marker) {
        this(provider, enforceMainThread);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001f\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0001\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Landroidx/lifecycle/LifecycleRegistry$Companion;", "", "<init>", "()V", "createUnsafe", "Landroidx/lifecycle/LifecycleRegistry;", "owner", "Landroidx/lifecycle/LifecycleOwner;", "min", "Landroidx/lifecycle/Lifecycle$State;", "state1", "state2", "min$lifecycle_runtime", "lifecycle-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final LifecycleRegistry createUnsafe(@NotNull LifecycleOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new LifecycleRegistry(owner, false, null);
        }

        @JvmStatic
        @NotNull
        public final Lifecycle.State min$lifecycle_runtime(@NotNull Lifecycle.State state1, @Nullable Lifecycle.State state2) {
            Intrinsics.checkNotNullParameter((Object)((Object)state1), (String)"state1");
            return state2 != null && state2.compareTo((Enum)state1) < 0 ? state2 : state1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Landroidx/lifecycle/LifecycleRegistry$ObserverWithState;", "", "observer", "Landroidx/lifecycle/LifecycleObserver;", "initialState", "Landroidx/lifecycle/Lifecycle$State;", "<init>", "(Landroidx/lifecycle/LifecycleObserver;Landroidx/lifecycle/Lifecycle$State;)V", "state", "getState", "()Landroidx/lifecycle/Lifecycle$State;", "setState", "(Landroidx/lifecycle/Lifecycle$State;)V", "lifecycleObserver", "Landroidx/lifecycle/LifecycleEventObserver;", "getLifecycleObserver", "()Landroidx/lifecycle/LifecycleEventObserver;", "setLifecycleObserver", "(Landroidx/lifecycle/LifecycleEventObserver;)V", "dispatchEvent", "", "owner", "Landroidx/lifecycle/LifecycleOwner;", "event", "Landroidx/lifecycle/Lifecycle$Event;", "lifecycle-runtime"})
    public static final class ObserverWithState {
        @NotNull
        private Lifecycle.State state;
        @NotNull
        private LifecycleEventObserver lifecycleObserver;

        public ObserverWithState(@Nullable LifecycleObserver observer2, @NotNull Lifecycle.State initialState) {
            Intrinsics.checkNotNullParameter((Object)((Object)initialState), (String)"initialState");
            LifecycleObserver lifecycleObserver = observer2;
            Intrinsics.checkNotNull((Object)lifecycleObserver);
            this.lifecycleObserver = Lifecycling.lifecycleEventObserver(lifecycleObserver);
            this.state = initialState;
        }

        @NotNull
        public final Lifecycle.State getState() {
            return this.state;
        }

        public final void setState(@NotNull Lifecycle.State state) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
            this.state = state;
        }

        @NotNull
        public final LifecycleEventObserver getLifecycleObserver() {
            return this.lifecycleObserver;
        }

        public final void setLifecycleObserver(@NotNull LifecycleEventObserver lifecycleEventObserver) {
            Intrinsics.checkNotNullParameter((Object)lifecycleEventObserver, (String)"<set-?>");
            this.lifecycleObserver = lifecycleEventObserver;
        }

        public final void dispatchEvent(@Nullable LifecycleOwner owner, @NotNull Lifecycle.Event event) {
            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
            Lifecycle.State newState = event.getTargetState();
            this.state = Companion.min$lifecycle_runtime(this.state, newState);
            LifecycleOwner lifecycleOwner = owner;
            Intrinsics.checkNotNull((Object)lifecycleOwner);
            this.lifecycleObserver.onStateChanged(lifecycleOwner, event);
            this.state = newState;
        }
    }
}

