/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import java.io.Serializable;

public final class DoubleArrays {
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final double[] DEFAULT_EMPTY_ARRAY = new double[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<double[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static double[] forceCapacity(double[] array, int length, int preserve) {
        double[] t = new double[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static double[] ensureCapacity(double[] array, int length, int preserve) {
        return length > array.length ? DoubleArrays.forceCapacity(array, length, preserve) : array;
    }

    public static void ensureOffsetLength(double[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    public static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            DoubleArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(double[] x, int a, int b, int c, DoubleComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(double[] a, int from, int to, DoubleComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            double u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(double[] a, int from, int to, DoubleComparator comp) {
        int i = from;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(double[] x, int from, int to, DoubleComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            DoubleArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = DoubleArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = DoubleArrays.med3(x, m - s, m, m + s, comp);
            n = DoubleArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = DoubleArrays.med3(x, l, m, n, comp);
        double v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            DoubleArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        DoubleArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        DoubleArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            DoubleArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(double[] x, int a, int b, int c) {
        int ab = Double.compare(x[a], x[b]);
        int ac = Double.compare(x[a], x[c]);
        int bc = Double.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(double[] a, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (Double.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            double u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(double[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (Double.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(double[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            DoubleArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = DoubleArrays.med3(x, l, l + s, l + 2 * s);
            m = DoubleArrays.med3(x, m - s, m, m + s);
            n = DoubleArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = DoubleArrays.med3(x, l, m, n);
        double v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Double.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Double.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            DoubleArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        DoubleArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        DoubleArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            DoubleArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(double[] a, int from, int to) {
        if (to - from >= 4000) {
            DoubleArrays.radixSort(a, from, to);
        } else {
            DoubleArrays.quickSort(a, from, to);
        }
    }

    public static void unstableSort(double[] a, int from, int to, DoubleComparator comp) {
        DoubleArrays.quickSort(a, from, to, comp);
    }

    public static void mergeSort(double[] a, int from, int to, double[] supp) {
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSort(a, from, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, a);
        DoubleArrays.mergeSort(supp, mid, to, a);
        if (Double.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && Double.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(double[] a, int from, int to) {
        DoubleArrays.mergeSort(a, from, to, (double[])null);
    }

    public static void mergeSort(double[] a, int from, int to, DoubleComparator comp, double[] supp) {
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSort(a, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, comp, a);
        DoubleArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(double[] a, int from, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a, from, to, comp, null);
    }

    public static void stableSort(double[] a, int from, int to) {
        DoubleArrays.mergeSort(a, from, to);
    }

    public static void stableSort(double[] a) {
        DoubleArrays.stableSort(a, 0, a.length);
    }

    public static void stableSort(double[] a, int from, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a, from, to, comp);
    }

    public static void stableSort(double[] a, DoubleComparator comp) {
        DoubleArrays.stableSort(a, 0, a.length, comp);
    }

    private static final long fixDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        return l >= 0L ? l : l ^ Long.MAX_VALUE;
    }

    public static void radixSort(double[] a, int from, int to) {
        if (to - from < 1024) {
            DoubleArrays.quickSort(a, from, to);
            return;
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int stackPos = 0;
        int[] offsetStack = new int[1786];
        int[] lengthStack = new int[1786];
        int[] levelStack = new int[1786];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            int shift = (7 - level % 8) * 8;
            int i = first + length;
            while (i-- != first) {
                int n = (int)(DoubleArrays.fixDouble(a[i]) >>> shift & 0xFFL ^ (long)signMask);
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count[i2];
            }
            int end = first + length - count[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count[c]) {
                double t = a[i3];
                c = (int)(DoubleArrays.fixDouble(t) >>> shift & 0xFFL ^ (long)signMask);
                if (i3 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        double z = t;
                        t = a[d];
                        a[d] = z;
                        c = (int)(DoubleArrays.fixDouble(t) >>> shift & 0xFFL ^ (long)signMask);
                    }
                    a[i3] = t;
                }
                if (level < 7 && count[c] > 1) {
                    if (count[c] < 1024) {
                        DoubleArrays.quickSort(a, i3, i3 + count[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(double[] a, double[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

