/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.rules.CategoryId;

public final class Category {
    private final String name;
    private final CategoryId id;
    private final Location location;
    private final boolean defaultOff;
    private final String tabName;

    public Category(CategoryId id, String name) {
        this(id, name, Location.INTERNAL, true);
    }

    public Category(CategoryId id, String name, Location location) {
        this(id, name, location, true);
    }

    public Category(CategoryId id, String name, Location location, boolean onByDefault) {
        this(id, name, location, onByDefault, null);
    }

    public Category(CategoryId id, String name, Location location, boolean onByDefault, String tabName) {
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.location = location;
        this.defaultOff = !onByDefault;
        this.tabName = tabName;
    }

    @NotNull
    public CategoryId getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Nullable
    public String getTabName() {
        return this.tabName;
    }

    public boolean isDefaultOff() {
        return this.defaultOff;
    }

    public Location getLocation() {
        return this.location;
    }

    public static enum Location {
        INTERNAL,
        EXTERNAL;

    }
}

