/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.temporal.WeekFields;
import java.util.Locale;
import net.sourceforge.plantuml.project.Value;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.time.MonthUtils;
import net.sourceforge.plantuml.project.time.WeekNumberStrategy;
import net.sourceforge.plantuml.project.time.YearMonthUtils;

public class Day
implements Comparable<Day>,
Value {
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    private final LocalDateTime utcDateTime;

    public static Day epoch() {
        return new Day(LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC));
    }

    public static Day create(int year, String month, int dayOfMonth) {
        return new Day(LocalDateTime.of(year, MonthUtils.fromString(month), dayOfMonth, 0, 0));
    }

    public static Day create(int year, int month, int dayOfMonth) {
        return new Day(LocalDateTime.of(year, month, dayOfMonth, 0, 0));
    }

    public static Day create(long ms) {
        return new Day(LocalDateTime.ofInstant(Instant.ofEpochMilli(ms), ZoneOffset.UTC));
    }

    public static Day today() {
        return new Day(LocalDateTime.now(ZoneOffset.UTC));
    }

    private Day(LocalDateTime utcDateTime) {
        this.utcDateTime = utcDateTime;
    }

    public String toStringShort(Locale locale) {
        return YearMonthUtils.shortName(this.monthYear(), locale) + " " + this.getDayOfMonth();
    }

    public int getWeekOfYear(WeekNumberStrategy strategy) {
        WeekFields wf = WeekFields.of(strategy.getFirstDayOfWeek(), strategy.getMinimalDaysInFirstWeek());
        return this.utcDateTime.toLocalDate().get(wf.weekOfYear());
    }

    public Day increment() {
        return this.addDays(1);
    }

    public Day decrement() {
        return this.addDays(-1);
    }

    public Day addDays(int nday) {
        return new Day(this.utcDateTime.toLocalDate().plusDays(nday).atStartOfDay());
    }

    public final int getAbsoluteDayNum() {
        return (int)Math.floorDiv(this.getMillis(), 86400000L);
    }

    public final long getMillis() {
        return this.utcDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public int year() {
        return this.monthYear().getYear();
    }

    public String toString() {
        return this.monthYear().toString() + "/" + this.getDayOfMonth();
    }

    public int hashCode() {
        return this.utcDateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != Day.class) {
            return false;
        }
        Day other = (Day)obj;
        return this.utcDateTime.equals(other.utcDateTime);
    }

    @Override
    public int compareTo(Day other) {
        return this.utcDateTime.compareTo(other.utcDateTime);
    }

    public final int getDayOfMonth() {
        return this.utcDateTime.getDayOfMonth();
    }

    public Month month() {
        return this.utcDateTime.getMonth();
    }

    public YearMonth monthYear() {
        return YearMonth.from(this.utcDateTime);
    }

    public DayOfWeek getDayOfWeek() {
        return this.utcDateTime.getDayOfWeek();
    }

    public static Day min(Day d1, Day d2) {
        return d1.compareTo(d2) <= 0 ? d1 : d2;
    }

    public static Day max(Day d1, Day d2) {
        return d1.compareTo(d2) >= 0 ? d1 : d2;
    }

    public Day increment(PrintScale printScale) {
        if (printScale == PrintScale.WEEKLY) {
            return this.addDays(7);
        }
        return this.increment();
    }

    public Day roundDayDown() {
        long ms = this.getMillis();
        long floored = Math.floorDiv(ms, 86400000L) * 86400000L;
        return Day.create(floored);
    }

    public Day roundDayUp() {
        long ms = this.getMillis();
        long ceiled = Math.floorDiv(ms + 86400000L - 1L, 86400000L) * 86400000L;
        return Day.create(ceiled);
    }
}

