/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectDataBLOBReference;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;

public class ObjectGroupData
extends StreamObject {
    public List<ObjectGroupObjectData> objectGroupObjectDataList = new ArrayList<ObjectGroupObjectData>();
    public List<ObjectGroupObjectDataBLOBReference> objectGroupObjectDataBLOBReferenceList = new ArrayList<ObjectGroupObjectDataBLOBReference>();

    public ObjectGroupData() {
        super(StreamObjectTypeHeaderStart.ObjectGroupData);
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws TikaException, IOException {
        if (this.objectGroupObjectDataList != null) {
            for (ObjectGroupObjectData objectGroupObjectData : this.objectGroupObjectDataList) {
                byteList.addAll(objectGroupObjectData.serializeToByteList());
            }
        }
        if (this.objectGroupObjectDataBLOBReferenceList != null) {
            for (ObjectGroupObjectDataBLOBReference objectGroupObjectDataBLOBReference : this.objectGroupObjectDataBLOBReferenceList) {
                byteList.addAll(objectGroupObjectDataBLOBReference.serializeToByteList());
            }
        }
        return 0;
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        if (lengthOfItems != 0) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "ObjectGroupDeclarations", "Stream object over-parse error", null);
        }
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        int headerLength = 0;
        AtomicReference<StreamObjectHeaderStart> header = new AtomicReference<StreamObjectHeaderStart>();
        this.objectGroupObjectDataList = new ArrayList<ObjectGroupObjectData>();
        this.objectGroupObjectDataBLOBReferenceList = new ArrayList<ObjectGroupObjectDataBLOBReference>();
        while ((headerLength = StreamObjectHeaderStart.tryParse(byteArray, index.get(), header)) != 0) {
            StreamObjectTypeHeaderStart type = header.get().type;
            if (type == StreamObjectTypeHeaderStart.ObjectGroupObjectData) {
                index.addAndGet(headerLength);
                this.objectGroupObjectDataList.add((ObjectGroupObjectData)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            if (type == StreamObjectTypeHeaderStart.ObjectGroupObjectDataBLOBReference) {
                index.addAndGet(headerLength);
                this.objectGroupObjectDataBLOBReferenceList.add((ObjectGroupObjectDataBLOBReference)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            throw new StreamObjectParseErrorException(index.get(), "ObjectGroupDeclarations", "Failed to parse ObjectGroupData, expect the inner object type either ObjectGroupObjectData or ObjectGroupObjectDataBLOBReference, but actual type value is " + type, null);
        }
        currentIndex.set(index.get());
    }
}

