/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.KoMorphData;
import org.apache.lucene.analysis.morph.DictionaryEntryWriter;
import org.apache.lucene.analysis.util.CSVUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;

class TokenInfoDictionaryEntryWriter
extends DictionaryEntryWriter {
    private static final int ID_LIMIT = 8192;

    TokenInfoDictionaryEntryWriter(int size) {
        super(size);
    }

    protected int putEntry(String[] entry) {
        boolean hasSinglePOS;
        POS.Tag rightPOS;
        POS.Tag leftPOS;
        short leftId = Short.parseShort(entry[1]);
        short rightId = Short.parseShort(entry[2]);
        short wordCost = Short.parseShort(entry[3]);
        POS.Type posType = POS.resolveType(entry[8]);
        if (posType == POS.Type.MORPHEME || posType == POS.Type.COMPOUND || entry[9].equals("*")) {
            leftPOS = POS.resolveTag(entry[4]);
            assert (entry[9].equals("*") && entry[10].equals("*"));
            rightPOS = leftPOS;
        } else {
            leftPOS = POS.resolveTag(entry[9]);
            rightPOS = POS.resolveTag(entry[10]);
        }
        String reading = entry[7].equals("*") ? "" : (entry[0].equals(entry[7]) ? "" : entry[7]);
        String expression = entry[11].equals("*") ? "" : entry[11];
        int left = this.buffer.remaining();
        int worstCase = 9 + 2 * (expression.length() + reading.length());
        if (worstCase > left) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(ArrayUtil.oversize((int)(this.buffer.limit() + worstCase - left), (int)1));
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        int toFill = 1 + leftId - this.posDict.size();
        for (int i = 0; i < toFill; ++i) {
            this.posDict.add(null);
        }
        String fullPOSData = leftPOS.name() + "," + entry[5];
        String existing = (String)this.posDict.get(leftId);
        assert (existing == null || existing.equals(fullPOSData));
        this.posDict.set(leftId, fullPOSData);
        ArrayList<KoMorphData.Morpheme> morphemes = new ArrayList<KoMorphData.Morpheme>();
        boolean bl = hasSinglePOS = leftPOS == rightPOS;
        if (posType != POS.Type.MORPHEME && expression.length() > 0) {
            String[] exprTokens;
            for (String exprToken : exprTokens = expression.split("\\+")) {
                String[] tokenSplit = exprToken.split("/");
                assert (tokenSplit.length == 3);
                String surfaceForm = tokenSplit[0].trim();
                if (surfaceForm.isEmpty()) continue;
                POS.Tag exprTag = POS.resolveTag(tokenSplit[1]);
                morphemes.add(new KoMorphData.Morpheme(exprTag, tokenSplit[0]));
                if (leftPOS == exprTag) continue;
                hasSinglePOS = false;
            }
        }
        int flags = 0;
        if (hasSinglePOS) {
            flags |= 1;
        }
        if (posType == POS.Type.MORPHEME && reading.length() > 0) {
            flags |= 2;
        }
        if (leftId >= 8192) {
            throw new IllegalArgumentException("leftId >= 8192: " + leftId);
        }
        if (posType.ordinal() >= 4) {
            throw new IllegalArgumentException("posType.ordinal() >= 4: " + posType.name());
        }
        this.buffer.putShort((short)(leftId << 2 | posType.ordinal()));
        this.buffer.putShort((short)(rightId << 2 | flags));
        this.buffer.putShort(wordCost);
        if (posType == POS.Type.MORPHEME) {
            assert (leftPOS == rightPOS);
            if (reading.length() > 0) {
                this.writeString(reading);
            }
        } else {
            if (!hasSinglePOS) {
                this.buffer.put((byte)rightPOS.ordinal());
            }
            this.buffer.put((byte)morphemes.size());
            int compoundOffset = 0;
            for (KoMorphData.Morpheme morpheme : morphemes) {
                if (!hasSinglePOS) {
                    this.buffer.put((byte)morpheme.posTag().ordinal());
                }
                if (posType != POS.Type.INFLECT) {
                    this.buffer.put((byte)morpheme.surfaceForm().length());
                    compoundOffset += morpheme.surfaceForm().length();
                } else {
                    this.writeString(morpheme.surfaceForm());
                }
                assert (compoundOffset <= entry[0].length()) : Arrays.toString(entry);
            }
        }
        return this.buffer.position();
    }

    private void writeString(String s) {
        this.buffer.put((byte)s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.buffer.putChar(s.charAt(i));
        }
    }

    protected void writePosDict(OutputStream bos, DataOutput out) throws IOException {
        out.writeVInt(this.posDict.size());
        for (String s : this.posDict) {
            if (s == null) {
                out.writeByte((byte)POS.Tag.UNKNOWN.ordinal());
                continue;
            }
            String[] data = CSVUtil.parse((String)s);
            if (data.length != 2) {
                throw new IllegalArgumentException("Malformed pos/inflection: " + s + "; expected 2 characters");
            }
            out.writeByte((byte)POS.Tag.valueOf(data[0]).ordinal());
        }
    }
}

