/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.spi;

import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.internal.models.Components;
import io.smallrye.openapi.internal.models.OpenAPI;
import io.smallrye.openapi.internal.models.PathItem;
import io.smallrye.openapi.internal.models.Paths;
import io.smallrye.openapi.internal.models.callbacks.Callback;
import io.smallrye.openapi.internal.models.examples.Example;
import io.smallrye.openapi.internal.models.headers.Header;
import io.smallrye.openapi.internal.models.info.Info;
import io.smallrye.openapi.internal.models.media.MediaType;
import io.smallrye.openapi.internal.models.media.XML;
import io.smallrye.openapi.internal.models.parameters.RequestBody;
import io.smallrye.openapi.internal.models.responses.APIResponse;
import io.smallrye.openapi.internal.models.responses.APIResponses;
import io.smallrye.openapi.internal.models.security.OAuthFlows;
import io.smallrye.openapi.internal.models.security.SecurityRequirement;
import io.smallrye.openapi.internal.models.servers.Server;
import io.smallrye.openapi.internal.models.servers.ServerVariable;
import io.smallrye.openapi.spi.SpiMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;

public class OASFactoryResolverImpl
extends OASFactoryResolver {
    public <T extends Constructible> T createObject(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return (T)OASFactoryResolverRegistry.REGISTRY.getOrDefault(clazz, () -> this.unknownType(clazz)).get();
    }

    <T extends Constructible> T unknownType(Class<T> clazz) {
        throw SpiMessages.msg.classNotConstructible(clazz.getName());
    }

    private static class OASFactoryResolverRegistry {
        private static final Map<Class<? extends Constructible>, Supplier<? extends Constructible>> REGISTRY;

        private OASFactoryResolverRegistry() {
        }

        static {
            HashMap<Class<? extends Constructible>, Supplier<? extends Constructible>> registry = new HashMap<Class<? extends Constructible>, Supplier<? extends Constructible>>(30);
            registry.put(org.eclipse.microprofile.openapi.models.responses.APIResponse.class, APIResponse::new);
            registry.put(org.eclipse.microprofile.openapi.models.responses.APIResponses.class, APIResponses::new);
            registry.put(org.eclipse.microprofile.openapi.models.callbacks.Callback.class, Callback::new);
            registry.put(org.eclipse.microprofile.openapi.models.Components.class, Components::new);
            registry.put(Contact.class, io.smallrye.openapi.internal.models.info.Contact::new);
            registry.put(Content.class, io.smallrye.openapi.internal.models.media.Content::new);
            registry.put(Discriminator.class, io.smallrye.openapi.internal.models.media.Discriminator::new);
            registry.put(Encoding.class, io.smallrye.openapi.internal.models.media.Encoding::new);
            registry.put(org.eclipse.microprofile.openapi.models.examples.Example.class, Example::new);
            registry.put(ExternalDocumentation.class, io.smallrye.openapi.internal.models.ExternalDocumentation::new);
            registry.put(org.eclipse.microprofile.openapi.models.headers.Header.class, Header::new);
            registry.put(org.eclipse.microprofile.openapi.models.info.Info.class, Info::new);
            registry.put(License.class, io.smallrye.openapi.internal.models.info.License::new);
            registry.put(Link.class, io.smallrye.openapi.internal.models.links.Link::new);
            registry.put(org.eclipse.microprofile.openapi.models.media.MediaType.class, MediaType::new);
            registry.put(OAuthFlow.class, io.smallrye.openapi.internal.models.security.OAuthFlow::new);
            registry.put(org.eclipse.microprofile.openapi.models.security.OAuthFlows.class, OAuthFlows::new);
            registry.put(org.eclipse.microprofile.openapi.models.OpenAPI.class, OpenAPI::new);
            registry.put(Operation.class, OperationImpl::new);
            registry.put(Parameter.class, io.smallrye.openapi.internal.models.parameters.Parameter::new);
            registry.put(org.eclipse.microprofile.openapi.models.PathItem.class, PathItem::new);
            registry.put(org.eclipse.microprofile.openapi.models.Paths.class, Paths::new);
            registry.put(org.eclipse.microprofile.openapi.models.parameters.RequestBody.class, RequestBody::new);
            registry.put(Schema.class, io.smallrye.openapi.internal.models.media.Schema::new);
            registry.put(org.eclipse.microprofile.openapi.models.security.SecurityRequirement.class, SecurityRequirement::new);
            registry.put(SecurityScheme.class, io.smallrye.openapi.internal.models.security.SecurityScheme::new);
            registry.put(org.eclipse.microprofile.openapi.models.servers.Server.class, Server::new);
            registry.put(org.eclipse.microprofile.openapi.models.servers.ServerVariable.class, ServerVariable::new);
            registry.put(Tag.class, io.smallrye.openapi.internal.models.tags.Tag::new);
            registry.put(org.eclipse.microprofile.openapi.models.media.XML.class, XML::new);
            REGISTRY = registry;
        }
    }
}

