/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.paths.ManifestAttributes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public abstract class AbstractClassPathElement
implements ClassPathElement {
    private static final Logger log = Logger.getLogger(AbstractClassPathElement.class);
    private volatile ManifestAttributes manifestAttributes;
    private volatile boolean manifestInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManifestAttributes getManifestAttributes() {
        if (this.manifestInitialized) {
            return this.manifestAttributes;
        }
        AbstractClassPathElement abstractClassPathElement = this;
        synchronized (abstractClassPathElement) {
            if (this.manifestInitialized) {
                return this.manifestAttributes;
            }
            this.manifestAttributes = this.readManifest();
            this.manifestInitialized = true;
        }
        return this.manifestAttributes;
    }

    protected ManifestAttributes readManifest() {
        ClassPathResource mf = this.getResource("META-INF/MANIFEST.MF");
        if (mf != null) {
            ManifestAttributes manifestAttributes;
            ByteArrayInputStream manifestIs = new ByteArrayInputStream(mf.getData());
            try {
                manifestAttributes = ManifestAttributes.of((Manifest)new Manifest(manifestIs));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)manifestIs).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warnf("Failed to parse manifest for %s", (Object)this.toString(), (Object)e);
                }
            }
            ((InputStream)manifestIs).close();
            return manifestAttributes;
        }
        return null;
    }
}

