/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.state.MetadataShellState;
import org.jline.reader.Candidate;

public final class CommandUtils {
    public static List<String> getEffectivePaths(List<String> paths) {
        ArrayList<String> effectivePaths = new ArrayList<String>();
        for (String path : paths) {
            if (path.isEmpty()) continue;
            effectivePaths.add(path);
        }
        if (effectivePaths.isEmpty()) {
            effectivePaths.add(".");
        }
        return effectivePaths;
    }

    public static void completeCommand(String commandPrefix, List<Candidate> candidates) {
        String command = Commands.TYPES.ceilingKey(commandPrefix);
        while (command != null && command.startsWith(commandPrefix)) {
            candidates.add(new Candidate(command));
            command = Commands.TYPES.higherKey(command);
        }
    }

    public static List<String> splitPath(String path) {
        String[] components;
        ArrayList<String> results = new ArrayList<String>();
        for (String component : components = path.split("/")) {
            if (component.isEmpty()) continue;
            results.add(component);
        }
        return results;
    }

    public static List<String> stripDotPathComponents(List<String> input) {
        ArrayList<String> output = new ArrayList<String>();
        for (String string : input) {
            if (string.equals("..")) {
                if (output.isEmpty()) continue;
                output.remove(output.size() - 1);
                continue;
            }
            if (string.equals(".")) continue;
            output.add(string);
        }
        return output;
    }

    public static void completePath(MetadataShellState state, String pathPrefix, List<Candidate> candidates) {
        state.visit(data -> {
            String absolutePath = pathPrefix.startsWith("/") ? pathPrefix : data.workingDirectory() + "/" + pathPrefix;
            List<String> pathComponents = CommandUtils.stripDotPathComponents(CommandUtils.splitPath(absolutePath));
            MetadataNode directory = data.root();
            int numDirectories = pathPrefix.endsWith("/") ? pathComponents.size() : pathComponents.size() - 1;
            for (int i = 0; i < numDirectories; ++i) {
                MetadataNode node = directory.child(pathComponents.get(i));
                if (node == null || !node.isDirectory()) {
                    return;
                }
                directory = node;
            }
            String lastComponent = "";
            if (numDirectories >= 0 && numDirectories < pathComponents.size()) {
                lastComponent = pathComponents.get(numDirectories);
            }
            TreeSet<String> children = new TreeSet<String>(directory.childNames());
            String candidate = children.ceiling(lastComponent);
            int lastSlash = pathPrefix.lastIndexOf(47);
            String effectivePrefix = lastSlash < 0 ? "" : pathPrefix.substring(0, lastSlash + 1);
            while (candidate != null && candidate.startsWith(lastComponent)) {
                StringBuilder candidateBuilder = new StringBuilder();
                candidateBuilder.append(effectivePrefix).append(candidate);
                boolean complete = true;
                MetadataNode child = directory.child(candidate);
                if (child != null && child.isDirectory()) {
                    candidateBuilder.append("/");
                    complete = false;
                }
                candidates.add(new Candidate(candidateBuilder.toString(), candidateBuilder.toString(), null, null, null, null, complete));
                candidate = children.higher(candidate);
            }
        });
    }
}

