/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class FilteredQuery
extends Query {
    Query query;
    Filter filter;

    public FilteredQuery(Query query, Filter filter) {
        this.query = query;
        this.filter = filter;
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        final Weight weight = this.query.createWeight(searcher);
        final Similarity similarity = this.query.getSimilarity(searcher);
        return new Weight(){
            private float value;

            public float getValue() {
                return this.value;
            }

            public float sumOfSquaredWeights() throws IOException {
                return weight.sumOfSquaredWeights() * FilteredQuery.this.getBoost() * FilteredQuery.this.getBoost();
            }

            public void normalize(float v) {
                weight.normalize(v);
                this.value = weight.getValue() * FilteredQuery.this.getBoost();
            }

            public Explanation explain(IndexReader ir, int i) throws IOException {
                Filter f;
                DocIdSetIterator docIdSetIterator;
                Explanation inner = weight.explain(ir, i);
                if (FilteredQuery.this.getBoost() != 1.0f) {
                    Explanation preBoost = inner;
                    inner = new Explanation(inner.getValue() * FilteredQuery.this.getBoost(), "product of:");
                    inner.addDetail(new Explanation(FilteredQuery.this.getBoost(), "boost"));
                    inner.addDetail(preBoost);
                }
                if ((docIdSetIterator = (f = FilteredQuery.this.filter).getDocIdSet(ir).iterator()).skipTo(i) && docIdSetIterator.doc() == i) {
                    return inner;
                }
                Explanation result = new Explanation(0.0f, "failure to match filter: " + f.toString());
                result.addDetail(inner);
                return result;
            }

            public Query getQuery() {
                return FilteredQuery.this;
            }

            public Scorer scorer(IndexReader indexReader) throws IOException {
                final Scorer scorer = weight.scorer(indexReader);
                final DocIdSetIterator docIdSetIterator = FilteredQuery.this.filter.getDocIdSet(indexReader).iterator();
                return new Scorer(similarity){

                    private boolean advanceToCommon() throws IOException {
                        while (scorer.doc() != docIdSetIterator.doc()) {
                            if (!(scorer.doc() < docIdSetIterator.doc() ? !scorer.skipTo(docIdSetIterator.doc()) : !docIdSetIterator.skipTo(scorer.doc()))) continue;
                            return false;
                        }
                        return true;
                    }

                    public boolean next() throws IOException {
                        return docIdSetIterator.next() && scorer.next() && this.advanceToCommon();
                    }

                    public int doc() {
                        return scorer.doc();
                    }

                    public boolean skipTo(int i) throws IOException {
                        return docIdSetIterator.skipTo(i) && scorer.skipTo(docIdSetIterator.doc()) && this.advanceToCommon();
                    }

                    public float score() throws IOException {
                        return FilteredQuery.this.getBoost() * scorer.score();
                    }

                    public Explanation explain(int i) throws IOException {
                        Explanation exp = scorer.explain(i);
                        if (docIdSetIterator.skipTo(i) && docIdSetIterator.doc() == i) {
                            exp.setDescription("allowed by filter: " + exp.getDescription());
                            exp.setValue(FilteredQuery.this.getBoost() * exp.getValue());
                        } else {
                            exp.setDescription("removed by filter: " + exp.getDescription());
                            exp.setValue(0.0f);
                        }
                        return exp;
                    }
                };
            }
        };
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            FilteredQuery clone = (FilteredQuery)this.clone();
            clone.query = rewritten;
            return clone;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void extractTerms(Set terms) {
        this.getQuery().extractTerms(terms);
    }

    public String toString(String s) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)o;
            return this.query.equals(fq.query) && this.filter.equals(fq.filter) && this.getBoost() == fq.getBoost();
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() ^ this.filter.hashCode() + Float.floatToRawIntBits(this.getBoost());
    }
}

