---
stage: None - Facilitated functionality, see https://handbook.gitlab.com/handbook/product/categories/#facilitated-functionality
group: Unassigned - Facilitated functionality, see https://handbook.gitlab.com/handbook/product/categories/#facilitated-functionality
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
gitlab_dedicated: yes
description: ロゴ、ファビコン、サインインページ、プログレッシブウェブアプリ設定、システムメッセージ、カラーテーマなど、GitLabインスタンスの外観をカスタマイズします。
title: GitLabの外観
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

設定を更新して、インスタンスのルックアンドフィールを変更できます。

**外観**設定を開くには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。

## ホームページボタンをカスタマイズする {#customize-your-homepage-button}

ホームページボタンの外観をカスタマイズします。

ホームページボタンは、左側のサイドバーの左上隅にあります。デフォルトのGitLabロゴ{{< icon name="tanuki" >}}を任意の画像に置き換えます。

- ファイルのサイズは1MB未満にしてください。
- 画像の高さは24ピクセルにしてください。24ピクセルを超える高さの画像は、サイズが変更されます。

ホームページのアイコン画像をカスタマイズするには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **ナビゲーションバー**で、**ファイルを選択**を選択します。
1. ページの下部にある**外観の設定を更新**を選択します。

パイプラインステータスのメールにも、カスタムロゴが表示されます。ただし、一部のメールアプリケーションはSVG画像をサポートしていません。カスタム画像がSVG形式の場合、パイプラインメールにはデフォルトのロゴが表示されます。

## ファビコンをカスタマイズする {#customize-the-favicon}

ファビコンの外観をカスタマイズします。ファビコンは、ブラウザータブに表示されるウェブサイトのアイコンです。GitLabロゴ{{< icon name="tanuki" >}}は、デフォルトのブラウザーおよびCI/CDステータスのファビコンです。デフォルトのアイコンを、`32 x 32`ピクセルで`.png`または`.ico`形式の任意の画像に置き換えます。

ファビコンを変更するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **ファビコン**で、**ファイルを選択**を選択します。
1. ページの下部にある**外観の設定を更新**を選択します。

## システムのヘッダーとフッターメッセージを追加 {#add-system-header-and-footer-messages}

{{< history >}}

- **メールのヘッダーとフッターを有効にする**チェックボックスは、GitLab 15.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/344819)されました。

{{< /history >}}

GitLabインスタンスのインターフェースに、小さなヘッダーメッセージ、小さなフッターメッセージ、またはその両方を追加します。これらのメッセージは、サインインページや登録ページなど、インスタンスのすべてのプロジェクトとページに表示されます。

- Markdownを使用して、メッセージを斜体にしたり、太字にしたり、リンクを追加したりできます。
- システムメッセージは1行で記述する必要があるため、Markdownのリスト、画像、引用符はサポートされていません。

システムヘッダー、フッターメッセージ、またはその両方を追加するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **システムヘッダーとフッター**セクションに移動します。
1. フィールドに入力します。
1. オプション。**メールのヘッダーとフッターを有効にする**チェックボックスを選択します。システムメッセージを、GitLabインスタンスから送信されるすべてのメールに追加します。
1. ページの下部にある**外観の設定を更新**を選択します。

デフォルトでは、システムヘッダーとフッターのテキストは、オレンジ色の背景に白いテキストで表示されます。メッセージの色をカスタマイズするには:

- **システムヘッダーとフッター**セクションに移動し、**カラーをカスタマイズ**を選択します。

## サインインページと登録ページをカスタマイズする {#customize-your-sign-in-and-register-pages}

サインインページと登録ページのタイトル、説明、ロゴをカスタマイズします。デフォルトでは、登録ページのロゴはページ左側のタイトルと説明の間に配置されています。

サインインページと登録ページのタイトルまたは説明をカスタマイズするには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **サインイン/サインアップページ**セクションに移動します。
1. フィールドに入力します。ページ**タイトル**と**説明**は、Markdownで書式設定できます。
1. ページの下部にある**外観の設定を更新**を選択します。

サインインページと登録ページのロゴをカスタマイズするには:

- ファイルのサイズは1MB未満にしてください。
- 画像の高さは128ピクセルにしてください。128ピクセルを超える高さの画像は、サイズが変更されます。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **サインイン/サインアップページ**セクションに移動します。
1. **ロゴ**で、**ファイルを選択**を選択します。
1. ページの下部にある**外観の設定を更新**を選択します。

サインインメッセージの下に[カスタマイズされたヘルプメッセージ](settings/help_page.md)を追加したり、[サインインテキストメッセージ](settings/sign_in_restrictions.md#sign-in-information)を追加したりすることもできます。

### Cookieベースの言語セレクターを無効にする {#disable-cookie-based-language-selector}

{{< details >}}

- 提供形態: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 16.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144484)されました。

{{< /history >}}

{{< alert type="flag" >}}

GitLab Self-Managedでは、デフォルトでこの機能は使用できません。管理者が`disable_preferred_language_cookie`という名前の[機能フラグを有効にする](feature_flags/_index.md)と、この機能を使用できるようになります。GitLab.comとGitLab Dedicatedでは、この機能は使用できません。

{{< /alert >}}

機能フラグである`disable_preferred_language_cookie`を有効にすることで、Cookieベースの言語セレクターをサインインページと登録ページのフッターから削除できます。

## プログレッシブウェブアプリ(PWA)をカスタマイズする {#customize-the-progressive-web-app}

{{< history >}}

- GitLab 15.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/375708)されました。

{{< /history >}}

プログレッシブウェブアプリ(PWA)のアイコン、表示名、略称、説明をカスタマイズします。詳細については、[Progressive Web App](https://developer.mozilla.org/en-US/docs/Web/Progressive_web_apps)を参照してください。

プログレッシブウェブアプリ(PWA)の名前と略称を追加するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **プログレッシブウェブアプリ(PWA)**セクションに移動します。
1. フィールドに入力します。
   - **名前**は、PWAの表示名です。
   - **略称**は、モバイルデバイスおよび小型画面に表示されます。
1. ページの下部にある**外観の設定を更新**を選択します。

プログレッシブウェブアプリ(PWA) の説明を追加するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **プログレッシブウェブアプリ(PWA)**セクションに移動します。
1. フィールドに入力します。Markdownで**説明**を書式設定できます。
1. ページの下部にある**外観の設定を更新**を選択します。

プログレッシブウェブアプリ(PWA) のアイコンをカスタマイズするには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **プログレッシブウェブアプリ(PWA)**セクションに移動します。
1. **アイコン**で、**ファイルを選択**を選択します。
1. ページの下部にある**外観の設定を更新**を選択します。

## メンバーガイドライン {#member-guidelines}

GitLabのグループおよびプロジェクトのメンバーページに、メンバーガイドラインを追加できます。説明では[Markdown](../user/markdown.md)を使用できます。

メンバーガイドラインは、次のいずれかを管理する[権限](../user/permissions.md)を持つユーザーに表示されます:

- グループのメンバー。
- プロジェクトのメンバー。

グループとプロジェクトのメンバーシップを次のいずれかを使用して管理する場合は、メンバーガイドラインを追加する必要があります:

- 個人ベースではなく、定義済みのグループ。
- 外部ツール。

## 新規プロジェクトページにガイドラインを追加する {#add-guidelines-to-the-new-project-page}

**新規プロジェクトページ**にガイドラインメッセージを追加します。Markdownでメッセージの書式を設定できます。ガイドラインメッセージは、**新規プロジェクト**メッセージの下、および**新規プロジェクトページ**の左側に表示されます。

**新規プロジェクトページ**にガイドラインメッセージを追加するには:

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **新規プロジェクトページ**セクションに移動します。
1. フィールドに入力します。Markdownでガイドラインの書式を設定できます。

## プロフィール画像ガイドラインを追加する {#add-profile-image-guidelines}

プロフィール画像ガイドラインを追加します。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **外観**を選択します。
1. **Profile image guideline**（プロフィール画像のガイドライン） セクションに移動します。
1. フィールドに入力します。Markdownを使用してテキストを書式設定できます。

## リブラアバター {#libravatar}

GitLabは[Libravatar](https://www.libravatar.org)をアバター画像にサポートしていますが、GitLabインスタンスでLibravatarのサポートを手動で有効にする必要があります。詳細については、[Libravatar](libravatar.md)を参照してサービスを使用してください。

## すべての新しいユーザーのカラーテーマを変更する {#change-the-color-theme-for-all-new-users}

{{< details >}}

- 提供形態: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.8で導入: `gitlab_default_theme`は、1〜10の値を指定してデフォルトのテーマを設定できます。
- テーマ: ライトインディゴ、ライトブルー、ライトグリーン、ライトレッドは、GitLab 18.4で[削除](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200475)されました。

{{< /history >}}

すべての新しいユーザーに対して[ナビゲーションテーマのデフォルトを変更](../user/profile/preferences.md#change-the-navigation-theme)するには:

1. `gitlab_rails['gitlab_default_theme']`を`/etc/gitlab/gitlab.rb`のGitLab設定ファイルに追加します:

   ```ruby
   gitlab_rails['gitlab_default_theme'] = 2
   ```

   次の色を使用できます:
   <!-- The themes are defined in lib/gitlab/themes.rb -->

   | 値 | 色  |
   | ----- | -----  |
   | 1     | インディゴ |
   | 2     | 暗い   |
   | 3     | 明るい  |
   | 4     | 青   |
   | 5     | 緑  |
   | 9     | 赤    |

1. [GitLabを再構成して再起動](restart_gitlab.md#reconfigure-a-linux-package-installation)します。
