# frozen_string_literal: true

class AddIndexToVulnerabilityStateTransitionsForResolvedActivity < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.9'

  TABLE_NAME = :vulnerability_state_transitions
  INDEX_NAME = :index_vulnerability_state_transitions_resolved_activity

  def up
    return unless should_run?

    add_concurrent_index TABLE_NAME,
      [:created_at, :vulnerability_id],
      name: INDEX_NAME,
      where: 'to_state = 3' # 3 for resolved vulnerabilities
  end

  def down
    return unless should_run?

    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  private

  # This index is primarily used for optimizing ServicePing queries,
  # which are not needed for GitLab.com, as we rely directly on our data warehouse.
  # See https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176561 for context.
  def should_run?
    !Gitlab.com_except_jh?
  end
end
