/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.EnvUnitImpl;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MathFunctionUnitImpl;
import java.util.Locale;
import org.w3c.dom.DOMException;

class DimensionalAnalyzer {
    private LexicalUnitImpl lunit = null;
    private boolean attrPending;

    public LexicalUnitImpl getNextLexicalUnit() {
        return this.lunit;
    }

    public boolean isAttrPending() {
        return this.attrPending;
    }

    public Dimension expressionDimension(LexicalUnitImpl unit) throws DOMException {
        this.lunit = unit;
        Dimension sum = null;
        Dimension dim = null;
        Ops operation = Ops.ADD;
        block47: while (this.lunit != null) {
            LexicalUnit.LexicalType sacType = this.lunit.getLexicalUnitType();
            switch (sacType) {
                case DIMENSION: {
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = DimensionalAnalyzer.createDimension(this.lunit.getCssUnit());
                            break;
                        }
                        case 1: {
                            dim = dim.multiplyByUnit(this.lunit.getCssUnit());
                            break;
                        }
                        case 2: {
                            dim = dim.divideByUnit(this.lunit.getCssUnit());
                        }
                    }
                    break;
                }
                case IDENT: {
                    String cons = this.lunit.getStringValue().toLowerCase(Locale.ROOT);
                    if (!"pi".equals(cons) && !"e".equals(cons)) {
                        throw new DOMInvalidAccessException("Invalid identifier in expression: " + this.lunit.getCssText());
                    }
                }
                case REAL: {
                    if (operation != Ops.ADD) break;
                    dim = new Dimension();
                    dim.category = CSSValueSyntax.Category.number;
                    break;
                }
                case INTEGER: {
                    if (operation != Ops.ADD) break;
                    dim = new Dimension();
                    dim.category = CSSValueSyntax.Category.integer;
                    break;
                }
                case PERCENTAGE: {
                    this.attrPending = false;
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = DimensionalAnalyzer.createDimension((short)2);
                            break;
                        }
                        case 1: {
                            dim = dim.multiplyByUnit((short)2);
                            break;
                        }
                        case 2: {
                            dim = dim.divideByUnit((short)2);
                        }
                    }
                    break;
                }
                case FUNCTION: {
                    String func = this.lunit.getFunctionName().toLowerCase(Locale.ROOT);
                    if (func.charAt(0) != '-' || !func.endsWith("-calc")) {
                        throw DimensionalAnalyzer.createInvalidUnitException(this.lunit);
                    }
                }
                case CALC: 
                case SUB_EXPRESSION: {
                    DimensionalAnalyzer calcAnal = new DimensionalAnalyzer();
                    Dimension expdim = calcAnal.expressionDimension(this.lunit.parameters);
                    boolean bl = this.attrPending = this.attrPending || calcAnal.isAttrPending();
                    if (expdim == null) {
                        dim = sum;
                        sum = null;
                        this.lunit = this.lunit.nextLexicalUnit;
                        break block47;
                    }
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = expdim;
                            break;
                        }
                        case 1: {
                            dim = dim.multiply(expdim);
                            break;
                        }
                        case 2: {
                            dim = dim.divide(expdim);
                        }
                    }
                    break;
                }
                case VAR: {
                    this.lunit = this.lunit.nextLexicalUnit;
                    return null;
                }
                case MATH_FUNCTION: {
                    DimensionalAnalyzer funcAnal = new DimensionalAnalyzer();
                    Dimension funcdim = ((MathFunctionUnitImpl)this.lunit).dimension(funcAnal);
                    boolean bl = this.attrPending = this.attrPending || funcAnal.isAttrPending();
                    if (funcdim == null) {
                        dim = sum;
                        sum = null;
                        this.lunit = this.lunit.nextLexicalUnit;
                        break block47;
                    }
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = funcdim;
                            break;
                        }
                        case 1: {
                            dim = dim.multiply(funcdim);
                            break;
                        }
                        case 2: {
                            dim = dim.divide(funcdim);
                        }
                    }
                    break;
                }
                case OPERATOR_PLUS: 
                case OPERATOR_MINUS: {
                    if (sum == null) {
                        sum = dim;
                    } else {
                        sum.sum(dim);
                    }
                    operation = Ops.ADD;
                    break;
                }
                case OPERATOR_MULTIPLY: {
                    operation = Ops.MULT;
                    break;
                }
                case OPERATOR_SLASH: {
                    operation = Ops.DIV;
                    break;
                }
                case OPERATOR_COMMA: {
                    break block47;
                }
                case ATTR: {
                    Dimension attrdim = this.attrDimension(this.lunit.parameters);
                    if (attrdim == null) {
                        dim = sum;
                        sum = null;
                        this.lunit = this.lunit.nextLexicalUnit;
                        break block47;
                    }
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = attrdim;
                            break;
                        }
                        case 1: {
                            dim = dim.multiply(attrdim);
                            break;
                        }
                        case 2: {
                            dim = dim.divide(attrdim);
                        }
                    }
                    break;
                }
                case ENV: {
                    Dimension envdim = ((EnvUnitImpl)this.lunit).dimension();
                    if (envdim == null) {
                        dim = sum;
                        sum = null;
                        this.lunit = this.lunit.nextLexicalUnit;
                        break block47;
                    }
                    switch (operation.ordinal()) {
                        case 0: {
                            dim = envdim;
                            break;
                        }
                        case 1: {
                            dim = dim.multiply(envdim);
                            break;
                        }
                        case 2: {
                            dim = dim.divide(envdim);
                        }
                    }
                    break;
                }
                default: {
                    throw DimensionalAnalyzer.createInvalidUnitException(this.lunit);
                }
            }
            this.lunit = this.lunit.nextLexicalUnit;
        }
        if (sum != null) {
            if (!sum.sum(dim)) {
                throw new DOMInvalidAccessException("Invalid attempt to sum " + sum + " and " + dim);
            }
        } else {
            sum = dim;
        }
        return sum;
    }

    private static DOMException createInvalidUnitException(LexicalUnitImpl lunit) {
        return new DOMInvalidAccessException("Invalid unit in expression: " + lunit.getCssText());
    }

    private Dimension attrDimension(LexicalUnitImpl param) throws DOMException {
        LexicalUnitImpl lunit = param.nextLexicalUnit;
        if (lunit != null) {
            Dimension dimfb;
            Dimension dim = DimensionalAnalyzer.typeSpecDimension(lunit);
            if (dim == null || dim.category != CSSValueSyntax.Category.length && dim.category != CSSValueSyntax.Category.percentage || (lunit = lunit.nextLexicalUnit) == null || lunit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA || (lunit = lunit.nextLexicalUnit) == null) {
                return dim;
            }
            DimensionalAnalyzer fbAnal = new DimensionalAnalyzer();
            try {
                dimfb = fbAnal.expressionDimension(lunit);
                this.attrPending = this.attrPending || fbAnal.isAttrPending();
            }
            catch (DOMException e) {
                return dim;
            }
            if (dimfb != null && dim.category != dimfb.category) {
                this.attrPending = dim.sum(dimfb);
                dim.lengthProcessed = false;
                dim.percentageProcessed = false;
            }
            return dim;
        }
        throw new DOMInvalidAccessException("Invalid attr() in expression: " + param.getCssText());
    }

    private static Dimension typeSpecDimension(LexicalUnitImpl param) {
        switch (param.getLexicalUnitType()) {
            case TYPE_FUNCTION: {
                LexicalUnit typeParam = param.getParameters();
                if (typeParam == null) break;
                Dimension dim = new Dimension();
                dim.category = typeParam.getSyntax().getCategory();
                if (dim.category != CSSValueSyntax.Category.number && dim.category != CSSValueSyntax.Category.integer) {
                    dim.exponent = 1;
                }
                return dim;
            }
            case IDENT: {
                String s = param.getStringValue().toLowerCase(Locale.ROOT);
                return DimensionalAnalyzer.createDimension(UnitStringToId.unitFromString(s));
            }
            case OPERATOR_MOD: {
                Dimension dim = new Dimension();
                dim.category = CSSValueSyntax.Category.percentage;
                dim.exponent = 1;
                return dim;
            }
            case VAR: {
                return null;
            }
        }
        throw new DOMInvalidAccessException("Invalid attr() in expression: " + param.getCssText());
    }

    static Dimension createDimension(short unit) throws DOMException {
        Dimension dim = new Dimension();
        if (unit == 0) {
            dim.category = CSSValueSyntax.Category.number;
            dim.exponent = 0;
            return dim;
        }
        dim.exponent = 1;
        if (CSSUnit.isLengthUnitType(unit)) {
            dim.category = CSSValueSyntax.Category.length;
            dim.lengthProcessed = true;
        } else if (unit == 2) {
            dim.category = CSSValueSyntax.Category.percentage;
            dim.percentageProcessed = true;
        } else if (CSSUnit.isAngleUnitType(unit)) {
            dim.category = CSSValueSyntax.Category.angle;
        } else if (CSSUnit.isTimeUnitType(unit)) {
            dim.category = CSSValueSyntax.Category.time;
        } else if (CSSUnit.isResolutionUnitType(unit)) {
            dim.category = CSSValueSyntax.Category.resolution;
        } else if (unit == 100 || unit == 101) {
            dim.category = CSSValueSyntax.Category.frequency;
        } else if (unit == 70) {
            dim.category = CSSValueSyntax.Category.flex;
        } else {
            throw new DOMInvalidAccessException("Invalid unit: " + unit);
        }
        return dim;
    }

    private static enum Ops {
        ADD,
        MULT,
        DIV;

    }
}

