/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.prompt;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AISqlJoinRule;
import org.jkiss.dbeaver.model.ai.impl.AIPromptUtils;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptAbstract;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AIPromptGenerateSql
extends AIPromptAbstract {
    public static final String SQL_GENERATOR_ID = "sql";

    @Override
    @NotNull
    public String generatorId() {
        return SQL_GENERATOR_ID;
    }

    @Override
    @NotNull
    protected AIPromptAbstract create() {
        return new AIPromptGenerateSql();
    }

    @NotNull
    public static AIPromptGenerateSql create(@NotNull DBSLogicalDataSourceSupplier dsSupplier) {
        AIPromptGenerateSql builder = new AIPromptGenerateSql();
        AIPromptGenerateSql.addSqlGenerateInstructions(dsSupplier, builder);
        return builder;
    }

    public static void addSqlGenerateInstructions(@NotNull DBSLogicalDataSourceSupplier dsSupplier, @NotNull AIPromptAbstract builder) {
        DBSLogicalDataSource dataSource = (DBSLogicalDataSource)dsSupplier.get();
        builder.addInstructions(AIPromptUtils.createGeneralRulesInstructions());
        if (dataSource != null) {
            builder.addContexts(AIPromptUtils.describeDataSourceInfo(dataSource)).addInstructions(AIPromptUtils.createGenerateQueryInstructions(dataSource));
        }
        builder.addOutputFormats(AIPromptUtils.SQL_OUTPUT_FORMATS);
        AIPromptGenerateSql.addJoinInstructions(builder);
    }

    public static void addJoinInstructions(@NotNull AIPromptAbstract builder) {
        AISqlJoinRule joinRule = (AISqlJoinRule)CommonUtils.valueOf(AISqlJoinRule.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("ai.joinRule"), (Enum)AISqlJoinRule.DEFAULT);
        String joinHint = switch (joinRule) {
            case AISqlJoinRule.JOIN -> "Use joins only.";
            case AISqlJoinRule.SUB_QUERY -> "Use sub\u2011queries only.";
            default -> "Joins and sub\u2011queries are allowed.";
        };
        builder.addInstructions(joinHint);
    }
}

