/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.forms;

import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.forms.UIObservableImpl;

public sealed interface UIObservable<T>
permits UIObservableImpl {
    @NotNull
    public static UIObservable<Byte> of(byte value) {
        return UIObservable.of(value, Byte.TYPE);
    }

    @NotNull
    public static UIObservable<Short> of(short value) {
        return UIObservable.of(value, Short.TYPE);
    }

    @NotNull
    public static UIObservable<Integer> of(int value) {
        return UIObservable.of(value, Integer.TYPE);
    }

    @NotNull
    public static UIObservable<Long> of(long value) {
        return UIObservable.of(value, Long.TYPE);
    }

    @NotNull
    public static UIObservable<Float> of(float value) {
        return UIObservable.of(Float.valueOf(value), Float.TYPE);
    }

    @NotNull
    public static UIObservable<Double> of(double value) {
        return UIObservable.of(value, Double.TYPE);
    }

    @NotNull
    public static UIObservable<Boolean> of(boolean value) {
        return UIObservable.of(value, Boolean.TYPE);
    }

    @NotNull
    public static UIObservable<Character> of(char value) {
        return UIObservable.of(Character.valueOf(value), Character.TYPE);
    }

    @NotNull
    public static UIObservable<String> of(@Nullable String value) {
        return UIObservable.of(value, String.class);
    }

    @NotNull
    public static <T extends Enum<T>> UIObservable<T> of(@NotNull T value) {
        return UIObservable.of(value, value.getDeclaringClass());
    }

    @NotNull
    public static <T> UIObservable<T> of(@Nullable T value, @NotNull Class<T> type) {
        return new UIObservableImpl<T>(value, type);
    }

    @NotNull
    public static UIObservable<Boolean> predicate(@NotNull Supplier<Boolean> supplier) {
        return UIObservable.computed(supplier, Boolean.class);
    }

    @NotNull
    public static <T> UIObservable<T> computed(@NotNull Supplier<T> supplier, @NotNull Class<T> type) {
        return new UIObservableImpl<IObservableValue>(ComputedValue.create(supplier), (Class<IObservableValue>)type);
    }

    public T get();

    public void set(T var1);

    @NotNull
    public Class<T> type();
}

