﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/vpc-lattice/VPCLattice_EXPORTS.h>
#include <aws/vpc-lattice/model/AuthType.h>
#include <aws/vpc-lattice/model/SharingConfig.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace VPCLattice {
namespace Model {
class GetServiceNetworkResult {
 public:
  AWS_VPCLATTICE_API GetServiceNetworkResult() = default;
  AWS_VPCLATTICE_API GetServiceNetworkResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_VPCLATTICE_API GetServiceNetworkResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the service network.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetServiceNetworkResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the service network.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetServiceNetworkResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that the service network was created, in ISO-8601
   * format.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  GetServiceNetworkResult& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time of the last update, in ISO-8601 format.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedAt() const { return m_lastUpdatedAt; }
  template <typename LastUpdatedAtT = Aws::Utils::DateTime>
  void SetLastUpdatedAt(LastUpdatedAtT&& value) {
    m_lastUpdatedAtHasBeenSet = true;
    m_lastUpdatedAt = std::forward<LastUpdatedAtT>(value);
  }
  template <typename LastUpdatedAtT = Aws::Utils::DateTime>
  GetServiceNetworkResult& WithLastUpdatedAt(LastUpdatedAtT&& value) {
    SetLastUpdatedAt(std::forward<LastUpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the service network.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetServiceNetworkResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of IAM policy.</p>
   */
  inline AuthType GetAuthType() const { return m_authType; }
  inline void SetAuthType(AuthType value) {
    m_authTypeHasBeenSet = true;
    m_authType = value;
  }
  inline GetServiceNetworkResult& WithAuthType(AuthType value) {
    SetAuthType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies if the service network is enabled for sharing.</p>
   */
  inline const SharingConfig& GetSharingConfig() const { return m_sharingConfig; }
  template <typename SharingConfigT = SharingConfig>
  void SetSharingConfig(SharingConfigT&& value) {
    m_sharingConfigHasBeenSet = true;
    m_sharingConfig = std::forward<SharingConfigT>(value);
  }
  template <typename SharingConfigT = SharingConfig>
  GetServiceNetworkResult& WithSharingConfig(SharingConfigT&& value) {
    SetSharingConfig(std::forward<SharingConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of VPCs associated with the service network.</p>
   */
  inline long long GetNumberOfAssociatedVPCs() const { return m_numberOfAssociatedVPCs; }
  inline void SetNumberOfAssociatedVPCs(long long value) {
    m_numberOfAssociatedVPCsHasBeenSet = true;
    m_numberOfAssociatedVPCs = value;
  }
  inline GetServiceNetworkResult& WithNumberOfAssociatedVPCs(long long value) {
    SetNumberOfAssociatedVPCs(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of services associated with the service network.</p>
   */
  inline long long GetNumberOfAssociatedServices() const { return m_numberOfAssociatedServices; }
  inline void SetNumberOfAssociatedServices(long long value) {
    m_numberOfAssociatedServicesHasBeenSet = true;
    m_numberOfAssociatedServices = value;
  }
  inline GetServiceNetworkResult& WithNumberOfAssociatedServices(long long value) {
    SetNumberOfAssociatedServices(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetServiceNetworkResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_name;

  Aws::Utils::DateTime m_createdAt{};

  Aws::Utils::DateTime m_lastUpdatedAt{};

  Aws::String m_arn;

  AuthType m_authType{AuthType::NOT_SET};

  SharingConfig m_sharingConfig;

  long long m_numberOfAssociatedVPCs{0};

  long long m_numberOfAssociatedServices{0};

  Aws::String m_requestId;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_lastUpdatedAtHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_authTypeHasBeenSet = false;
  bool m_sharingConfigHasBeenSet = false;
  bool m_numberOfAssociatedVPCsHasBeenSet = false;
  bool m_numberOfAssociatedServicesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace VPCLattice
}  // namespace Aws
