﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lambda/Lambda_EXPORTS.h>
#include <aws/lambda/model/FunctionConfiguration.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lambda {
namespace Model {
/**
 * <p>A list of Lambda functions.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsResponse">AWS
 * API Reference</a></p>
 */
class ListFunctionsResult {
 public:
  AWS_LAMBDA_API ListFunctionsResult() = default;
  AWS_LAMBDA_API ListFunctionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LAMBDA_API ListFunctionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The pagination token that's included if more results are available.</p>
   */
  inline const Aws::String& GetNextMarker() const { return m_nextMarker; }
  template <typename NextMarkerT = Aws::String>
  void SetNextMarker(NextMarkerT&& value) {
    m_nextMarkerHasBeenSet = true;
    m_nextMarker = std::forward<NextMarkerT>(value);
  }
  template <typename NextMarkerT = Aws::String>
  ListFunctionsResult& WithNextMarker(NextMarkerT&& value) {
    SetNextMarker(std::forward<NextMarkerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of Lambda functions.</p>
   */
  inline const Aws::Vector<FunctionConfiguration>& GetFunctions() const { return m_functions; }
  template <typename FunctionsT = Aws::Vector<FunctionConfiguration>>
  void SetFunctions(FunctionsT&& value) {
    m_functionsHasBeenSet = true;
    m_functions = std::forward<FunctionsT>(value);
  }
  template <typename FunctionsT = Aws::Vector<FunctionConfiguration>>
  ListFunctionsResult& WithFunctions(FunctionsT&& value) {
    SetFunctions(std::forward<FunctionsT>(value));
    return *this;
  }
  template <typename FunctionsT = FunctionConfiguration>
  ListFunctionsResult& AddFunctions(FunctionsT&& value) {
    m_functionsHasBeenSet = true;
    m_functions.emplace_back(std::forward<FunctionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListFunctionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextMarker;

  Aws::Vector<FunctionConfiguration> m_functions;

  Aws::String m_requestId;
  bool m_nextMarkerHasBeenSet = false;
  bool m_functionsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lambda
}  // namespace Aws
