/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.formatter.GroovyBlockProducer;

public class FormattingContext {
    private final CommonCodeStyleSettings mySettings;
    private final GroovyCodeStyleSettings myGroovySettings;
    private final AlignmentProvider myAlignmentProvider;
    private final boolean myForbidWrapping;
    private final boolean myForbidNewLineInSpacing;
    private final GroovyBlockProducer myGroovyBlockProducer;

    public FormattingContext(@NotNull CommonCodeStyleSettings settings, @NotNull AlignmentProvider provider2, @NotNull GroovyCodeStyleSettings groovySettings, boolean forbidWrapping, boolean forbidNewLineInSpacing, @NotNull GroovyBlockProducer producer) {
        if (settings == null) {
            FormattingContext.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            FormattingContext.$$$reportNull$$$0(1);
        }
        if (groovySettings == null) {
            FormattingContext.$$$reportNull$$$0(2);
        }
        if (producer == null) {
            FormattingContext.$$$reportNull$$$0(3);
        }
        this.mySettings = settings;
        this.myAlignmentProvider = provider2;
        this.myGroovySettings = groovySettings;
        this.myForbidWrapping = forbidWrapping;
        this.myForbidNewLineInSpacing = forbidNewLineInSpacing;
        this.myGroovyBlockProducer = producer;
    }

    public FormattingContext(@NotNull CommonCodeStyleSettings settings, @NotNull AlignmentProvider provider2, @NotNull GroovyCodeStyleSettings groovySettings, boolean forbidWrapping) {
        if (settings == null) {
            FormattingContext.$$$reportNull$$$0(4);
        }
        if (provider2 == null) {
            FormattingContext.$$$reportNull$$$0(5);
        }
        if (groovySettings == null) {
            FormattingContext.$$$reportNull$$$0(6);
        }
        this(settings, provider2, groovySettings, forbidWrapping, false, GroovyBlockProducer.DEFAULT);
    }

    public CommonCodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public AlignmentProvider getAlignmentProvider() {
        return this.myAlignmentProvider;
    }

    public GroovyCodeStyleSettings getGroovySettings() {
        return this.myGroovySettings;
    }

    public FormattingContext createContext(boolean forbidWrapping, boolean forbidNewLineInSpacing) {
        return new FormattingContext(this.mySettings, this.myAlignmentProvider, this.myGroovySettings, this.myForbidWrapping || forbidWrapping, this.myForbidNewLineInSpacing || forbidNewLineInSpacing, this.myGroovyBlockProducer);
    }

    public boolean isForbidWrapping() {
        return this.myForbidWrapping;
    }

    public boolean isForbidNewLineInSpacing() {
        return this.myForbidNewLineInSpacing;
    }

    public Block createBlock(@NotNull ASTNode node, @NotNull Indent indent, @Nullable Wrap wrap) {
        if (node == null) {
            FormattingContext.$$$reportNull$$$0(7);
        }
        if (indent == null) {
            FormattingContext.$$$reportNull$$$0(8);
        }
        return this.myGroovyBlockProducer.generateBlock(node, indent, wrap, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovySettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/FormattingContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

