/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.folding.EditPropertyValueAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.jsp.JspLanguage;
import com.intellij.psi.jsp.JspxLanguage;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

public final class PropertyFoldingBuilder
extends FoldingBuilderEx {
    private static final int FOLD_MAX_LENGTH = 50;
    private static final Key<IProperty> CACHE = Key.create((String)"i18n.property.cache");
    public static final IProperty NULL = new PropertyImpl((PropertyStub)new PropertyStubImpl((StubElement)new PsiFileStubImpl(null), null), PropertiesElementTypes.PROPERTY_TYPE);

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement element, final @NotNull Document document, boolean quick) {
        PsiFile file;
        block8: {
            block7: {
                if (element == null) {
                    PropertyFoldingBuilder.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    PropertyFoldingBuilder.$$$reportNull$$$0(1);
                }
                if (!(element instanceof PsiFile)) break block7;
                file = (PsiFile)element;
                if (!quick && PropertyFoldingBuilder.isFoldingsOn()) break block8;
            }
            if (FoldingDescriptor.EMPTY_ARRAY == null) {
                PropertyFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY_ARRAY;
        }
        final ArrayList result = new ArrayList();
        boolean hasJsp = ContainerUtil.exists((Iterable)file.getViewProvider().getLanguages(), l -> l instanceof JspLanguage || l instanceof JspxLanguage);
        file.accept((PsiElementVisitor)(hasJsp ? new JavaRecursiveElementWalkingVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                UInjectionHost injectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)expression, UInjectionHost.class);
                if (injectionHost != null) {
                    PropertyFoldingBuilder.checkLiteral(document, injectionHost, result);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder$1", "visitLiteralExpression"));
            }
        } : new PsiRecursiveElementWalkingVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                UInjectionHost injectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)element, UInjectionHost.class);
                if (injectionHost != null) {
                    PropertyFoldingBuilder.checkLiteral(document, injectionHost, result);
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder$2", "visitElement"));
            }
        }));
        FoldingDescriptor[] foldingDescriptorArray = result.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(3);
        }
        return foldingDescriptorArray;
    }

    private static boolean isFoldingsOn() {
        return JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    private static void checkLiteral(Document document, UInjectionHost injectionHost, List<? super FoldingDescriptor> result) {
        UCallExpression expressions;
        PsiElement sourcePsi = injectionHost.getSourcePsi();
        if (sourcePsi == null) {
            return;
        }
        if (!PropertyFoldingBuilder.isI18nProperty(injectionHost)) {
            return;
        }
        IProperty property = PropertyFoldingBuilder.getI18nProperty(injectionHost);
        HashSet<IProperty> set = new HashSet<IProperty>();
        set.add((IProperty)(property != null ? property : PsiModificationTracker.MODIFICATION_COUNT));
        String msg = PropertyFoldingBuilder.formatI18nProperty(injectionHost, property);
        UElement parent = injectionHost.getUastParent();
        if (!msg.equals(UastLiteralUtils.getValueIfStringLiteral((UElement)injectionHost)) && parent instanceof UCallExpression && ((UExpression)(expressions = (UCallExpression)parent).getValueArguments().get(0)).getSourcePsi() == injectionHost.getSourcePsi()) {
            PsiElement callSourcePsi = expressions.getSourcePsi();
            if (callSourcePsi == null) {
                return;
            }
            int count = JavaI18nUtil.getPropertyValueParamsMaxCount((UExpression)injectionHost);
            List args = expressions.getValueArguments();
            if (args.size() == 1 + count) {
                boolean ok = true;
                for (int i = 1; i < count + 1; ++i) {
                    Object value = ((UExpression)args.get(i)).evaluate();
                    if (value != null || args.get(i) instanceof UReferenceExpression) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    UExpression receiver = expressions.getReceiver();
                    PsiElement receiverSourcePsi = receiver != null ? receiver.getSourcePsi() : null;
                    PsiElement elementToFold = null;
                    if (receiverSourcePsi != null) {
                        elementToFold = PsiTreeUtil.findCommonParent((PsiElement)callSourcePsi, (PsiElement)receiverSourcePsi);
                    }
                    if (elementToFold == null) {
                        elementToFold = callSourcePsi;
                    }
                    result.add((FoldingDescriptor)new FoldingDescriptor(Objects.requireNonNull(elementToFold.getNode()), elementToFold.getTextRange(), null, PropertyFoldingBuilder.formatMethodCallExpression(expressions), Boolean.valueOf(PropertyFoldingBuilder.isFoldingsOn()), set));
                    if (property != null) {
                        EditPropertyValueAction.registerFoldedElement(elementToFold, document);
                    }
                    return;
                }
            } else {
                return;
            }
        }
        result.add((FoldingDescriptor)new FoldingDescriptor(Objects.requireNonNull(sourcePsi.getNode()), sourcePsi.getTextRange(), null, PropertyFoldingBuilder.getI18nMessage(injectionHost), Boolean.valueOf(PropertyFoldingBuilder.isFoldingsOn()), set));
        if (property != null) {
            EditPropertyValueAction.registerFoldedElement(sourcePsi, document);
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    private static String formatMethodCallExpression(@NotNull UCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(5);
        }
        String string = (String)PropertyFoldingBuilder.format((UCallExpression)methodCallExpression).first;
        if (string == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static Pair<String, List<Couple<Integer>>> format(@NotNull UCallExpression methodCallExpression) {
        UInjectionHost injectionHost;
        Object e;
        if (methodCallExpression == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(7);
        }
        List args = methodCallExpression.getValueArguments();
        PsiElement callSourcePsi = methodCallExpression.getSourcePsi();
        if (!args.isEmpty() && (e = args.get(0)) instanceof UInjectionHost && PropertyFoldingBuilder.isI18nProperty(injectionHost = (UInjectionHost)e)) {
            int count = JavaI18nUtil.getPropertyValueParamsMaxCount((UExpression)args.get(0));
            if (args.size() == 1 + count) {
                String text = PropertyFoldingBuilder.getI18nMessage((UInjectionHost)args.get(0));
                ArrayList<Couple<Integer>> replacementPositions = new ArrayList<Couple<Integer>>();
                for (int i = 1; i < count + 1; ++i) {
                    Object value = ((UExpression)args.get(i)).evaluate();
                    if (value == null) {
                        if (args.get(i) instanceof UReferenceExpression) {
                            PsiElement sourcePsi = ((UExpression)args.get(i)).getSourcePsi();
                            value = "{" + (sourcePsi != null ? sourcePsi.getText() : "<error>") + "}";
                        } else {
                            text = null;
                            break;
                        }
                    }
                    text = PropertyFoldingBuilder.replacePlaceholder(text, "{" + (i - 1) + "}", value.toString(), replacementPositions);
                }
                if (text != null) {
                    Pair pair = Pair.create((Object)(text.length() > 50 ? text.substring(0, 47) + "...\"" : text), replacementPositions);
                    if (pair == null) {
                        PropertyFoldingBuilder.$$$reportNull$$$0(8);
                    }
                    return pair;
                }
            }
        }
        Pair pair = Pair.create((Object)(callSourcePsi != null ? callSourcePsi.getText() : "<error>"), null);
        if (pair == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static String replacePlaceholder(String text, String placeholder, String replacement, List<Couple<Integer>> replacementPositions) {
        int placeholderPos;
        int curPos = 0;
        while ((placeholderPos = ((String)text).indexOf(placeholder, curPos)) >= 0) {
            Couple<Integer> next;
            text = ((String)text).substring(0, placeholderPos) + replacement + ((String)text).substring(placeholderPos + placeholder.length());
            ListIterator<Couple<Integer>> it = replacementPositions.listIterator();
            int diff = 0;
            while (it.hasNext()) {
                next = it.next();
                if ((Integer)next.second > placeholderPos) {
                    it.previous();
                    break;
                }
                diff = (Integer)next.second - (Integer)next.first;
            }
            it.add((Couple<Integer>)Couple.of((Object)(placeholderPos - diff), (Object)placeholderPos));
            it.add((Couple<Integer>)Couple.of((Object)(placeholderPos - diff + placeholder.length()), (Object)(placeholderPos + replacement.length())));
            while (it.hasNext()) {
                next = it.next();
                it.set((Couple<Integer>)Couple.of((Object)((Integer)next.first), (Object)((Integer)next.second + replacement.length() - placeholder.length())));
            }
            curPos = placeholderPos + replacement.length();
        }
        return text;
    }

    @NotNull
    private static String getI18nMessage(@NotNull UInjectionHost injectionHost) {
        IProperty property;
        if (injectionHost == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(10);
        }
        return (property = PropertyFoldingBuilder.getI18nProperty(injectionHost)) == null ? injectionHost.evaluateToString() : PropertyFoldingBuilder.formatI18nProperty(injectionHost, property);
    }

    @Nullable
    static IProperty getI18nProperty(@NotNull UInjectionHost injectionHost) {
        PsiElement sourcePsi;
        if (injectionHost == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(11);
        }
        if ((sourcePsi = injectionHost.getSourcePsi()) == null) {
            return null;
        }
        Property property = (Property)sourcePsi.getUserData(CACHE);
        if (property == NULL) {
            return null;
        }
        if (property != null && PropertyFoldingBuilder.isValid(property, injectionHost)) {
            return property;
        }
        if (PropertyFoldingBuilder.isI18nProperty(injectionHost)) {
            Iterable references = UastLiteralUtils.getInjectedReferences((UInjectionHost)injectionHost);
            for (PsiReference reference : references) {
                if (reference instanceof PsiPolyVariantReference) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        PsiElement element = result.getElement();
                        if (!(element instanceof IProperty)) continue;
                        IProperty p = (IProperty)element;
                        sourcePsi.putUserData(CACHE, (Object)p);
                        return p;
                    }
                    continue;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof IProperty)) continue;
                IProperty p = (IProperty)element;
                sourcePsi.putUserData(CACHE, (Object)p);
                return p;
            }
        }
        return null;
    }

    private static boolean isValid(Property property, UInjectionHost injectionHost) {
        if (injectionHost == null || property == null || !property.isValid()) {
            return false;
        }
        Object result = injectionHost.evaluate();
        if (!(result instanceof String)) {
            return false;
        }
        return StringUtil.unquoteString((String)((String)result)).equals(property.getKey());
    }

    @NotNull
    private static String formatI18nProperty(@NotNull UInjectionHost injectionHost, IProperty property) {
        if (injectionHost == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(12);
        }
        Object evaluated = injectionHost.evaluate();
        Object object = property == null ? (evaluated != null ? evaluated.toString() : "null") : "\"" + property.getValue() + "\"";
        if (object == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(13);
        }
        return object;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(14);
        }
        return PropertyFoldingBuilder.isFoldingsOn();
    }

    static boolean isI18nProperty(@NotNull UInjectionHost expr) {
        if (expr == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(15);
        }
        if (!expr.isString()) {
            return false;
        }
        PsiElement sourcePsi = expr.getSourcePsi();
        if (sourcePsi == null) {
            return false;
        }
        IProperty property = (IProperty)sourcePsi.getUserData(CACHE);
        if (property == NULL) {
            return false;
        }
        if (property != null) {
            return true;
        }
        boolean isI18n = JavaI18nUtil.mustBePropertyKey((UExpression)expr, null);
        if (!isI18n) {
            sourcePsi.putUserData(CACHE, (Object)NULL);
        }
        return isI18n;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 8, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethodCallExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatI18nProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatMethodCallExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getI18nMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getI18nProperty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatI18nProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isI18nProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 8, 9, 13 -> new IllegalStateException(string);
        };
    }
}

