/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.sst;

import com.oracle.graal.python.pegparser.tokenizer.CodePoints;
import java.math.BigInteger;

public final class ConstantValue {
    public static final ConstantValue TRUE = new ConstantValue(true, Kind.BOOLEAN);
    public static final ConstantValue FALSE = new ConstantValue(false, Kind.BOOLEAN);
    public static final ConstantValue NONE = new ConstantValue(null, Kind.NONE);
    public static final ConstantValue ELLIPSIS = new ConstantValue(null, Kind.ELLIPSIS);
    private static final int CACHED_MIN = -1;
    private static final int CACHED_MAX = 30;
    private static final ConstantValue[] CACHED_LONGS = new ConstantValue[32];
    private final Object value;
    public final Kind kind;

    private ConstantValue(Object value, Kind kind) {
        assert (kind != null && kind.checkValueType(value));
        this.value = value;
        this.kind = kind;
    }

    public BigInteger getBigInteger() {
        assert (this.kind == Kind.BIGINTEGER);
        return (BigInteger)this.value;
    }

    public boolean getBoolean() {
        assert (this.kind == Kind.BOOLEAN);
        return (Boolean)this.value;
    }

    public byte[] getBytes() {
        assert (this.kind == Kind.BYTES);
        return (byte[])this.value;
    }

    public double[] getComplex() {
        assert (this.kind == Kind.COMPLEX);
        return (double[])this.value;
    }

    public double getDouble() {
        assert (this.kind == Kind.DOUBLE);
        return (Double)this.value;
    }

    public long getLong() {
        assert (this.kind == Kind.LONG);
        return (Long)this.value;
    }

    public CodePoints getCodePoints() {
        assert (this.kind == Kind.CODEPOINTS);
        return (CodePoints)this.value;
    }

    public ConstantValue[] getTupleElements() {
        assert (this.kind == Kind.TUPLE);
        return (ConstantValue[])this.value;
    }

    public ConstantValue[] getFrozensetElements() {
        assert (this.kind == Kind.FROZENSET);
        return (ConstantValue[])this.value;
    }

    public static ConstantValue ofBigInteger(BigInteger v) {
        return new ConstantValue(v, Kind.BIGINTEGER);
    }

    public static ConstantValue ofBoolean(boolean v) {
        return v ? TRUE : FALSE;
    }

    public static ConstantValue ofBytes(byte[] v) {
        return new ConstantValue(v, Kind.BYTES);
    }

    public static ConstantValue ofComplex(double real, double imag) {
        return new ConstantValue(new double[]{real, imag}, Kind.COMPLEX);
    }

    public static ConstantValue ofDouble(double v) {
        return new ConstantValue(v, Kind.DOUBLE);
    }

    public ConstantValue addComplex(ConstantValue right) {
        assert (right.kind == Kind.COMPLEX);
        double ld = this.toDouble();
        double[] rd = right.getComplex();
        return ConstantValue.ofComplex(ld + rd[0], rd[1]);
    }

    public ConstantValue subComplex(ConstantValue right) {
        assert (right.kind == Kind.COMPLEX);
        double ld = this.toDouble();
        double[] rd = right.getComplex();
        return ConstantValue.ofComplex(ld - rd[0], -rd[1]);
    }

    private double toDouble() {
        assert (this.kind == Kind.BIGINTEGER || this.kind == Kind.DOUBLE || this.kind == Kind.LONG) : this.kind;
        switch (this.kind.ordinal()) {
            case 6: {
                return this.getBigInteger().doubleValue();
            }
            case 4: {
                return this.getDouble();
            }
            case 3: {
                return this.getLong();
            }
        }
        throw new IllegalStateException("should not reach here");
    }

    public ConstantValue negate() {
        assert (this.kind == Kind.BIGINTEGER || this.kind == Kind.DOUBLE || this.kind == Kind.LONG || this.kind == Kind.COMPLEX) : this.kind;
        switch (this.kind.ordinal()) {
            case 6: {
                return ConstantValue.ofBigInteger(this.getBigInteger().negate());
            }
            case 4: {
                return ConstantValue.ofDouble(-this.getDouble());
            }
            case 3: {
                long v = this.getLong();
                if (v != Long.MIN_VALUE) {
                    return ConstantValue.ofLong(-v);
                }
                return ConstantValue.ofBigInteger(BigInteger.valueOf(v).negate());
            }
            case 5: {
                double[] complex = this.getComplex();
                return ConstantValue.ofComplex(-complex[0], -complex[1]);
            }
        }
        throw new IllegalStateException("should not reach here");
    }

    public static ConstantValue ofLong(long v) {
        if (v >= -1L && v <= 30L) {
            return CACHED_LONGS[(int)(v - -1L)];
        }
        return new ConstantValue(v, Kind.LONG);
    }

    public static ConstantValue ofCodePoints(CodePoints cp) {
        return new ConstantValue(cp, Kind.CODEPOINTS);
    }

    public static ConstantValue ofTuple(ConstantValue[] values) {
        return new ConstantValue(values, Kind.TUPLE);
    }

    public static ConstantValue ofFrozenset(ConstantValue[] values) {
        return new ConstantValue(values, Kind.FROZENSET);
    }

    static {
        for (int i = -1; i <= 30; ++i) {
            ConstantValue.CACHED_LONGS[i - -1] = new ConstantValue(i, Kind.LONG);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Kind {
        NONE{

            @Override
            boolean checkValueType(Object value) {
                return value == null;
            }
        }
        ,
        ELLIPSIS{

            @Override
            boolean checkValueType(Object value) {
                return value == null;
            }
        }
        ,
        BOOLEAN{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof Boolean;
            }
        }
        ,
        LONG{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof Long;
            }
        }
        ,
        DOUBLE{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof Double;
            }
        }
        ,
        COMPLEX{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof double[] && ((double[])value).length == 2;
            }
        }
        ,
        BIGINTEGER{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof BigInteger;
            }
        }
        ,
        CODEPOINTS{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof CodePoints;
            }
        }
        ,
        BYTES{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof byte[];
            }
        }
        ,
        TUPLE{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof ConstantValue[];
            }
        }
        ,
        FROZENSET{

            @Override
            boolean checkValueType(Object value) {
                return value instanceof ConstantValue[];
            }
        };


        abstract boolean checkValueType(Object var1);
    }
}

